/*
 * Decompiled with CFR 0.152.
 */
package org.muplayer.system;

import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.LinkedHashSet;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;

public class HelpManager {
    private final File fileProps = new File("help.properties");
    private Properties properties;
    private boolean cacheMode = false;
    private static final HelpManager instance = new HelpManager();

    public static HelpManager getInstance() {
        return instance;
    }

    public HelpManager() {
        try {
            this.checkFile();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void checkFile() throws IOException {
        this.properties = new Properties();
        if (this.fileProps.exists()) {
            this.loadData();
            this.checkProperty("st", "Inicia el reproductor");
            this.checkProperty("ist", "Comprueba que el reproductor est\u00e1 iniciado");
            this.checkProperty("pl", "Inicia la reproducci\u00f3n");
            this.checkProperty("s", "Detiene la canci\u00f3n actual");
            this.checkProperty("r", "Inicia la canci\u00f3n actual si est\u00e1 pausada o detenida");
            this.checkProperty("ps", "Pausa la canci\u00f3n actual");
            this.checkProperty("n", "Reproduce la canci\u00f3n siguiente");
            this.checkProperty("p", "Reproduce la canci\u00f3n anterior");
            this.checkProperty("m", "Silencia el reproductor");
            this.checkProperty("um", "Quita el silencio al reproductor");
            this.checkProperty("l", "Lista todas las canciones disponibles en el reproductor");
            this.checkProperty("list", "Lista todas las canciones disponibles en el reproductor");
            this.checkProperty("lc", "Lista todas las canciones de la carpeta actual el reproducci\u00f3n");
            this.checkProperty("lf", "Lista todas las carpetas le\u00eddas por el reproductor");
            this.checkProperty("gv", "Obtiene el volumen actual del reproductor");
            this.checkProperty("v", "Cambia el volumen del reproductor (valor entre 0 y 100 ambos incluidos)");
            this.checkProperty("gsv", "Obtiene el volumen actual del sistema");
            this.checkProperty("sv", "Cambia el volumen del sistema (valor entre 0 y 100 ambos incluidos)");
            this.checkProperty("sh", "Apaga el reproductor");
            this.checkProperty("exit", "Apaga el reproductor y finaliza la ejecuci\u00f3n de MuPlayer");
            this.checkProperty("quit", "Apaga el reproductor y finaliza la ejecuci\u00f3n de MuPlayer");
            this.checkProperty("k", "Salta segundos de la canci\u00f3n actual");
            this.checkProperty("skf", "Salta carpetas");
            this.checkProperty("u", "Vuelve a cargar las canciones nuevamente");
            this.checkProperty("g", "Se dirige a un segundo espec\u00edfico de la canci\u00f3n actual");
            this.checkProperty("c", "Obtiene la cantidad de canciones cargadas");
            this.checkProperty("d", "Obtiene la duraci\u00f3n de la canci\u00f3n actual");
            this.checkProperty("cover", "Obtiene la car\u00e1tula de la canci\u00f3n actual si existe y la guarda en la ruta seleccionada");
            this.checkProperty("info", "Obtiene informaci\u00f3n de la canci\u00f3n actual");
            this.checkProperty("prog", "Obtiene los segundos actuales reproducidos de la canci\u00f3n actual");
            this.checkProperty("clear", "Limpia la pantalla");
            this.checkProperty("cls", "Limpia la pantalla");
            this.checkProperty("h", "Despliega el men\u00fa de ayuda de comandos");
            this.checkProperty("help", "Despliega el men\u00fa de ayuda de comandos");
            this.checkProperty("format", "Obtiene el formato de audio de la canci\u00f3n");
            this.checkProperty("title", "Obtiene el titulo de la canci\u00f3n");
            this.checkProperty("name", "Obtiene el nombre del archivo de la canci\u00f3n");
            this.checkProperty("system", "Ejecuta comandos del sistema");
            this.checkProperty("sys", "Ejecuta comandos del sistema");
            this.checkProperty("sn", "Muestra informaci\u00f3n de la canci\u00f3n siguiente");
            this.checkProperty("sp", "Muestra informaci\u00f3n de la canci\u00f3n anterior");
            this.checkProperty("pf", "Reproduce una carpeta seg\u00fan el \u00edndice entregado");
            this.checkProperty("load", "Reinicia reproductor cargando la carpeta segun la ruta indicada");
            this.checkProperty("arts", "Lista todos los artistas con sus respectivas canciones");
            this.checkProperty("albs", "Lista todos los \u00e1lbums con sus respectivas canciones");
            this.saveData();
        } else {
            this.fileProps.createNewFile();
            this.properties.setProperty("st", "Inicia el reproductor");
            this.properties.setProperty("ist", "Comprueba que el reproductor est\u00e1 iniciado");
            this.properties.setProperty("pl", "Inicia la reproducci\u00f3n");
            this.properties.setProperty("s", "Detiene la canci\u00f3n actual");
            this.properties.setProperty("r", "Inicia la canci\u00f3n actual si est\u00e1 pausada o detenida");
            this.properties.setProperty("ps", "Pausa la canci\u00f3n actual");
            this.properties.setProperty("n", "Reproduce la canci\u00f3n siguiente");
            this.properties.setProperty("p", "Reproduce la canci\u00f3n anterior");
            this.properties.setProperty("m", "Silencia el reproductor");
            this.properties.setProperty("um", "Quita el silencio al reproductor");
            this.properties.setProperty("l", "Lista todas las canciones disponibles en el reproductor");
            this.properties.setProperty("list", "Lista todas las canciones disponibles en el reproductor");
            this.properties.setProperty("lc", "Lista todas las canciones de la carpeta actual el reproducci\u00f3n");
            this.properties.setProperty("lf", "Lista todas las carpetas le\u00eddas por el reproductor");
            this.properties.setProperty("gv", "Obtiene el volumen actual del reproductor");
            this.properties.setProperty("v", "Cambia el volumen del reproductor (valor entre 0 y 100 ambos incluidos)");
            this.properties.setProperty("gsv", "Obtiene el volumen actual del sistema");
            this.properties.setProperty("sv", "Cambia el volumen del sistema (valor entre 0 y 100 ambos incluidos)");
            this.properties.setProperty("sh", "Apaga el reproductor");
            this.properties.setProperty("exit", "Apaga el reproductor y finaliza la ejecuci\u00f3n de MuPlayer");
            this.properties.setProperty("quit", "Apaga el reproductor y finaliza la ejecuci\u00f3n de MuPlayer");
            this.properties.setProperty("k", "Salta segundos de la canci\u00f3n actual");
            this.properties.setProperty("skf", "Salta carpetas");
            this.properties.setProperty("u", "Vuelve a cargar las canciones nuevamente");
            this.properties.setProperty("g", "Se dirige a un segundo espec\u00edfico de la canci\u00f3n actual");
            this.properties.setProperty("c", "Obtiene la cantidad de canciones cargadas");
            this.properties.setProperty("d", "Obtiene la duraci\u00f3n de la canci\u00f3n actual");
            this.properties.setProperty("cover", "Obtiene la car\u00e1tula de la canci\u00f3n actual si existe y la guarda en la ruta seleccionada");
            this.properties.setProperty("info", "Obtiene informaci\u00f3n de la canci\u00f3n actual");
            this.properties.setProperty("prog", "Obtiene los segundos actuales reproducidos de la canci\u00f3n actual");
            this.properties.setProperty("clear", "Limpia la pantalla");
            this.properties.setProperty("cls", "Limpia la pantalla");
            this.properties.setProperty("h", "Despliega el men\u00fa de ayuda de comandos");
            this.properties.setProperty("help", "Despliega el men\u00fa de ayuda de comandos");
            this.properties.setProperty("format", "Obtiene el formato de audio de la canci\u00f3n");
            this.properties.setProperty("title", "Obtiene el titulo de la canci\u00f3n");
            this.properties.setProperty("name", "Obtiene el nombre del archivo de la canci\u00f3n");
            this.properties.setProperty("system", "Ejecuta comandos del sistema");
            this.properties.setProperty("sys", "Ejecuta comandos del sistema");
            this.properties.setProperty("sn", "Muestra informaci\u00f3n de la canci\u00f3n siguiente");
            this.properties.setProperty("sp", "Muestra informaci\u00f3n de la canci\u00f3n anterior");
            this.properties.setProperty("pf", "Reproduce una carpeta seg\u00fan el \u00edndice entregado");
            this.properties.setProperty("load", "Reinicia reproductor cargando la carpeta segun la ruta indicada");
            this.properties.setProperty("arts", "Lista todos los artistas con sus respectivas canciones");
            this.properties.setProperty("albs", "Lista todos los \u00e1lbums con sus respectivas canciones");
            this.saveData();
        }
    }

    private void checkProperty(String key, String defaultValue) {
        String property = this.properties.getProperty(key);
        if (property == null || property.isEmpty()) {
            this.properties.setProperty(key, defaultValue);
        }
    }

    private void saveData() {
        try {
            this.properties.store(new FileWriter(this.fileProps), "MuPlayer Command Help");
            this.properties = null;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void loadData() {
        try {
            this.properties = new Properties();
            this.properties.load(new FileReader(this.fileProps));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void setCacheMode(boolean cacheMode) {
        this.cacheMode = cacheMode;
        if (cacheMode && this.properties == null) {
            this.loadData();
        } else {
            this.properties = null;
            System.gc();
        }
    }

    public String getProperty(String key) {
        if (this.cacheMode) {
            return this.properties.get(key).toString();
        }
        this.loadData();
        String value = this.properties.get(key).toString();
        this.properties = null;
        return value;
    }

    public Set<String> getPropertyNames() {
        Set<String> stringsPropNames;
        if (this.cacheMode) {
            stringsPropNames = this.properties.stringPropertyNames();
        } else {
            this.loadData();
            stringsPropNames = this.properties.stringPropertyNames();
            this.properties = null;
        }
        return stringsPropNames.stream().sorted().collect(Collectors.toCollection(LinkedHashSet::new));
    }
}

