/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jaad.spi.javasound;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.UnsupportedAudioFileException;
import javax.sound.sampled.spi.AudioFileReader;
import net.sourceforge.jaad.aac.syntax.BitStream;
import net.sourceforge.jaad.adts.ADTSDemultiplexer;
import net.sourceforge.jaad.spi.javasound.MP4AudioInputStream;

public class AACAudioFileReader
extends AudioFileReader {
    public static final AudioFileFormat.Type AAC = new AudioFileFormat.Type("AAC", "aac");
    public static final AudioFileFormat.Type MP4 = new AudioFileFormat.Type("MP4", "mp4");
    private static final AudioFormat.Encoding AAC_ENCODING = new AudioFormat.Encoding("AAC");

    @Override
    public AudioFileFormat getAudioFileFormat(InputStream in) throws UnsupportedAudioFileException, IOException {
        try {
            if (!in.markSupported()) {
                in = new BufferedInputStream(in);
            }
            in.mark(4);
            AudioFileFormat audioFileFormat = this.getAudioFileFormat(in, -1);
            return audioFileFormat;
        }
        finally {
            in.reset();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AudioFileFormat getAudioFileFormat(URL url) throws UnsupportedAudioFileException, IOException {
        try (InputStream in = url.openStream();){
            AudioFileFormat audioFileFormat = this.getAudioFileFormat(in);
            return audioFileFormat;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AudioFileFormat getAudioFileFormat(File file) throws UnsupportedAudioFileException, IOException {
        try (InputStream in = null;){
            in = new BufferedInputStream(new FileInputStream(file));
            in.mark(1000);
            AudioFileFormat aff = this.getAudioFileFormat(in, (int)file.length());
            in.reset();
            AudioFileFormat audioFileFormat = aff;
            return audioFileFormat;
        }
    }

    private AudioFileFormat getAudioFileFormat(InputStream in, int mediaLength) throws UnsupportedAudioFileException, IOException {
        byte[] head = new byte[12];
        in.read(head);
        boolean canHandle = false;
        if (new String(head, 4, 4).equals("ftyp")) {
            canHandle = true;
        } else if (head[0] == 82 && head[1] == 73 && head[2] == 70 && head[3] == 70 && head[8] == 87 && head[9] == 65 && head[10] == 86 && head[11] == 69) {
            canHandle = false;
        } else if (head[0] == 46 && head[1] == 115 && head[2] == 110 && head[3] == 100) {
            canHandle = false;
        } else if (head[0] == 70 && head[1] == 79 && head[2] == 82 && head[3] == 77 && head[8] == 65 && head[9] == 73 && head[10] == 70 && head[11] == 70) {
            canHandle = false;
        } else if (head[0] == 77 | head[0] == 109 && head[1] == 65 | head[1] == 97 && head[2] == 67 | head[2] == 99) {
            canHandle = false;
        } else if (head[0] == 70 | head[0] == 102 && head[1] == 76 | head[1] == 108 && head[2] == 65 | head[2] == 97 && head[3] == 67 | head[3] == 99) {
            canHandle = false;
        } else if (head[0] == 73 | head[0] == 105 && head[1] == 67 | head[1] == 99 && head[2] == 89 | head[2] == 121) {
            canHandle = false;
        } else if (head[0] == 79 | head[0] == 111 && head[1] == 71 | head[1] == 103 && head[2] == 71 | head[2] == 103) {
            canHandle = false;
        } else {
            BitStream bit = new BitStream(head);
            try {
                ADTSDemultiplexer adts = new ADTSDemultiplexer(in);
                canHandle = true;
            }
            catch (Exception e) {
                canHandle = false;
            }
        }
        if (canHandle) {
            AudioFormat format = new AudioFormat(AAC_ENCODING, -1.0f, -1, mediaLength, -1, -1.0f, true);
            return new AudioFileFormat(AAC, format, -1);
        }
        throw new UnsupportedAudioFileException();
    }

    @Override
    public AudioInputStream getAudioInputStream(InputStream in) throws UnsupportedAudioFileException, IOException {
        try {
            if (!in.markSupported()) {
                in = new BufferedInputStream(in);
            }
            in.mark(1000);
            AudioFileFormat aff = this.getAudioFileFormat(in, -1);
            in.reset();
            return new MP4AudioInputStream(in, aff.getFormat(), aff.getFrameLength());
        }
        catch (UnsupportedAudioFileException e) {
            in.reset();
            throw e;
        }
        catch (IOException e) {
            if (e.getMessage().equals("movie does not contain any AAC track")) {
                throw new UnsupportedAudioFileException("movie does not contain any AAC track");
            }
            in.reset();
            throw e;
        }
    }

    @Override
    public AudioInputStream getAudioInputStream(URL url) throws UnsupportedAudioFileException, IOException {
        InputStream in = url.openStream();
        try {
            return this.getAudioInputStream(in);
        }
        catch (UnsupportedAudioFileException e) {
            if (in != null) {
                in.close();
            }
            throw e;
        }
        catch (IOException e) {
            if (in != null) {
                in.close();
            }
            throw e;
        }
    }

    @Override
    public AudioInputStream getAudioInputStream(File file) throws UnsupportedAudioFileException, IOException {
        FileInputStream in = new FileInputStream(file);
        try {
            return this.getAudioInputStream(in);
        }
        catch (UnsupportedAudioFileException e) {
            if (in != null) {
                ((InputStream)in).close();
            }
            throw e;
        }
        catch (IOException e) {
            if (in != null) {
                ((InputStream)in).close();
            }
            throw e;
        }
    }
}

