/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.util;

import com.sun.tools.javac.util.Log;
import com.sun.tools.javac.util.Name;
import java.util.HashSet;
import java.util.Set;

public class MandatoryWarningHandler {
    private Log log;
    private boolean verbose;
    private String prefix;
    private Set<Name> sourcesWithReportedWarnings;
    private DeferredDiagnosticKind deferredDiagnosticKind;
    private Object deferredDiagnosticArg;

    public MandatoryWarningHandler(Log log, boolean bl, String string) {
        this.log = log;
        this.verbose = bl;
        this.prefix = string;
    }

    public void report(int n, String string, Object ... objectArray) {
        Name name = this.log.currentSource();
        if (this.verbose) {
            if (this.sourcesWithReportedWarnings == null) {
                this.sourcesWithReportedWarnings = new HashSet<Name>();
            }
            if (this.log.nwarnings < this.log.MaxWarnings) {
                this.log.mandatoryWarning(n, string, objectArray);
                this.sourcesWithReportedWarnings.add(name);
            } else if (this.deferredDiagnosticKind == null) {
                this.deferredDiagnosticKind = this.sourcesWithReportedWarnings.contains(name) ? DeferredDiagnosticKind.ADDITIONAL_IN_FILE : DeferredDiagnosticKind.IN_FILE;
                this.deferredDiagnosticArg = name;
            } else if (!(this.deferredDiagnosticKind != DeferredDiagnosticKind.IN_FILE && this.deferredDiagnosticKind != DeferredDiagnosticKind.ADDITIONAL_IN_FILE || MandatoryWarningHandler.equal(this.deferredDiagnosticArg, name))) {
                this.deferredDiagnosticKind = DeferredDiagnosticKind.ADDITIONAL_IN_FILES;
                this.deferredDiagnosticArg = null;
            }
        } else if (this.deferredDiagnosticKind == null) {
            this.deferredDiagnosticKind = DeferredDiagnosticKind.IN_FILE;
            this.deferredDiagnosticArg = name;
        } else if (this.deferredDiagnosticKind == DeferredDiagnosticKind.IN_FILE && !MandatoryWarningHandler.equal(this.deferredDiagnosticArg, name)) {
            this.deferredDiagnosticKind = DeferredDiagnosticKind.IN_FILES;
            this.deferredDiagnosticArg = null;
        }
    }

    public void reportDeferredDiagnostic() {
        if (this.deferredDiagnosticKind != null) {
            if (this.deferredDiagnosticArg == null) {
                this.log.mandatoryNote(this.deferredDiagnosticKind.getKey(this.prefix), new Object[0]);
            } else {
                this.log.mandatoryNote(this.deferredDiagnosticKind.getKey(this.prefix), this.deferredDiagnosticArg);
            }
            if (!this.verbose) {
                this.log.mandatoryNote(this.prefix + ".recompile", new Object[0]);
            }
        }
    }

    private static boolean equal(Object object, Object object2) {
        return object == null ? object2 == null : object.equals(object2);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum DeferredDiagnosticKind {
        IN_FILE(".filename"),
        ADDITIONAL_IN_FILE(".filename.additional"),
        IN_FILES(".plural"),
        ADDITIONAL_IN_FILES(".plural.additional");

        private String value;

        private DeferredDiagnosticKind(String string2) {
            this.value = string2;
        }

        String getKey(String string) {
            return string + this.value;
        }
    }
}

