/*
 * Decompiled with CFR 0.152.
 */
package sun.rmi.rmic.newrmic;

import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.RootDoc;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import sun.rmi.rmic.newrmic.Resources;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BatchEnvironment {
    private final RootDoc rootDoc;
    private final ClassDoc docRemote;
    private final ClassDoc docException;
    private final ClassDoc docRemoteException;
    private final ClassDoc docRuntimeException;
    private boolean verbose = false;
    private final List<File> generatedFiles = new ArrayList<File>();

    public BatchEnvironment(RootDoc rootDoc) {
        this.rootDoc = rootDoc;
        this.docRemote = this.rootDoc().classNamed("java.rmi.Remote");
        this.docException = this.rootDoc().classNamed("java.lang.Exception");
        this.docRemoteException = this.rootDoc().classNamed("java.rmi.RemoteException");
        this.docRuntimeException = this.rootDoc().classNamed("java.lang.RuntimeException");
    }

    public RootDoc rootDoc() {
        return this.rootDoc;
    }

    public ClassDoc docRemote() {
        return this.docRemote;
    }

    public ClassDoc docException() {
        return this.docException;
    }

    public ClassDoc docRemoteException() {
        return this.docRemoteException;
    }

    public ClassDoc docRuntimeException() {
        return this.docRuntimeException;
    }

    public void setVerbose(boolean bl) {
        this.verbose = bl;
    }

    public boolean verbose() {
        return this.verbose;
    }

    public void addGeneratedFile(File file) {
        this.generatedFiles.add(file);
    }

    public List<File> generatedFiles() {
        return Collections.unmodifiableList(this.generatedFiles);
    }

    public void output(String string) {
        this.rootDoc.printNotice(string);
    }

    public void error(String string, String ... stringArray) {
        this.rootDoc.printError(Resources.getText(string, stringArray));
    }
}

