/*
 * Decompiled with CFR 0.152.
 */
package org.muplayer.audio;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.SourceDataLine;
import javax.sound.sampled.UnsupportedAudioFileException;
import org.aucom.sound.Speaker;
import org.muplayer.audio.Track;
import org.muplayer.audio.info.AudioTag;
import org.muplayer.audio.info.SongData;
import org.muplayer.audio.interfaces.PlayerControls;
import org.muplayer.audio.interfaces.PlayerListener;
import org.muplayer.audio.model.Album;
import org.muplayer.audio.model.Artist;
import org.muplayer.audio.model.SeekOption;
import org.muplayer.audio.model.TrackInfo;
import org.muplayer.audio.trackstates.TrackState;
import org.muplayer.audio.trackstates.UnknownState;
import org.muplayer.audio.util.PlayerInfo;
import org.muplayer.system.AudioUtil;
import org.muplayer.system.LineUtil;
import org.muplayer.thread.ListenerRunner;
import org.muplayer.thread.TaskRunner;
import org.muplayer.thread.ThreadManager;

public class Player
extends Thread
implements PlayerControls {
    private volatile File rootFolder;
    private volatile Track current;
    private final List<String> listSoundPaths;
    private final List<String> listFolderPaths;
    private final List<PlayerListener> listListeners;
    private volatile int trackIndex;
    private volatile float currentVolume;
    private volatile boolean on;
    private volatile boolean isMute;
    public static final float DEFAULT_VOLUME = AudioUtil.convertLineRangeToVolRange(40.4275f);

    public Player() throws FileNotFoundException {
        this((File)null);
    }

    public Player(File rootFolder) throws FileNotFoundException {
        this.rootFolder = rootFolder;
        this.listSoundPaths = new LinkedList<String>();
        this.listFolderPaths = new LinkedList<String>();
        this.listListeners = new LinkedList<PlayerListener>();
        this.currentVolume = DEFAULT_VOLUME;
        this.on = false;
        this.isMute = false;
        this.checkRootFolder();
        this.setName("ThreadPlayer " + this.getId());
        this.trackIndex = -1;
        this.disableLogging();
    }

    private void checkRootFolder() throws FileNotFoundException {
        if (this.rootFolder != null) {
            if (!this.rootFolder.exists()) {
                throw new FileNotFoundException(this.rootFolder.getPath());
            }
            this.loadTracks(this.rootFolder);
            this.sortTracks();
        }
    }

    public Player(String folderPath) throws FileNotFoundException {
        this(new File(folderPath));
    }

    private void disableLogging() {
        Logger.getLogger("org.jaudiotagger").setLevel(Level.OFF);
    }

    private void loadTracks(File folder) {
        File[] fldFiles = folder.listFiles();
        if (fldFiles != null) {
            boolean hasTracks = false;
            for (int i = 0; i < fldFiles.length; ++i) {
                File f = fldFiles[i];
                if (f.isDirectory()) {
                    this.loadTracks(f);
                    continue;
                }
                try {
                    String filePath = f.getCanonicalPath();
                    if (!Track.isValidTrack(filePath)) continue;
                    this.listSoundPaths.add(filePath);
                    hasTracks = true;
                    continue;
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (hasTracks) {
                try {
                    this.listFolderPaths.add(folder.getCanonicalPath());
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private void loadTracks(List<File> listFiles) {
        listFiles.forEach(f -> {
            if (f.isDirectory()) {
                this.loadTracks((File)f);
            } else {
                this.listSoundPaths.add(f.getPath());
            }
        });
    }

    private void sortTracks() {
        Comparator comparator = Comparator.naturalOrder();
        this.listSoundPaths.sort(comparator);
        this.listFolderPaths.sort(comparator);
    }

    private int getFolderIndex() {
        String currentParent = this.current != null ? this.current.getDataSource().getParent() : null;
        return currentParent != null ? this.listFolderPaths.indexOf(currentParent) : -1;
    }

    private Track getTrackBy(int currentIndex, SeekOption param) {
        Track next = null;
        if (param == SeekOption.NEXT) {
            currentIndex = currentIndex == this.getSongsCount() - 1 || currentIndex < 0 ? 0 : ++currentIndex;
            for (int i = currentIndex; i < this.listSoundPaths.size(); ++i) {
                next = Track.getTrack(this.listSoundPaths.get(i), (PlayerControls)this);
                if (next == null || !next.isValidTrack()) continue;
                this.trackIndex = i;
                break;
            }
            return next;
        }
        currentIndex = currentIndex == 0 ? this.getSongsCount() - 1 : --currentIndex;
        for (int i = currentIndex; i >= 0; --i) {
            next = Track.getTrack(this.listSoundPaths.get(i), (PlayerControls)this);
            if (next == null) continue;
            this.trackIndex = i;
            break;
        }
        return next;
    }

    private void getNextTrack(SeekOption param) {
        this.current = this.getTrackBy(this.trackIndex, param);
    }

    private String getThreadName() {
        String trackName = this.current.getDataSource().getName();
        int strLimit = Math.min(trackName.length(), 10);
        return new StringBuilder("ThreadTrack: ").append(trackName, 0, strLimit).toString();
    }

    private void startThreadTrack() {
        if (this.current != null) {
            this.current.setName(this.getThreadName());
            this.current.setGain(this.isMute ? 0.0f : this.currentVolume);
            this.current.start();
        }
    }

    public void loadListenerMethod(String methodName, Track track) {
        if (!this.listListeners.isEmpty()) {
            TaskRunner.execute(new ListenerRunner(this.listListeners, methodName, track));
        }
    }

    private synchronized void freezePlayer() {
        ThreadManager.freezeThread(this);
    }

    private void shutdownCurrent() {
        if (this.current != null) {
            this.current.kill();
        }
    }

    private void waitForSongs() {
        while (this.on && this.getSongsCount() == 0) {
        }
    }

    private Track findFirstIn(String folderPath) {
        File parentFile = new File(folderPath);
        List<File> listSounds = this.getListSounds();
        File fileTrack = listSounds.stream().filter(file -> file.getParentFile().equals(parentFile)).findFirst().orElse(null);
        return fileTrack != null && Track.isValidTrack(fileTrack) ? Track.getTrack(fileTrack, (PlayerControls)this) : null;
    }

    private int moveToFolder(String folderPath) {
        File parentFile = new File(folderPath);
        List<File> listSounds = this.getListSounds();
        int trackIndex = -1;
        for (int i = 0; i < listSounds.size(); ++i) {
            File fileTrack = listSounds.get(i);
            if (!fileTrack.getParentFile().equals(parentFile)) continue;
            trackIndex = i;
            break;
        }
        return trackIndex - 1;
    }

    private void startPlaying() {
        this.on = true;
        this.waitForSongs();
        this.playNext();
    }

    private void playFolderSongs(String fldPath) {
        for (int i = 0; i < this.listSoundPaths.size(); ++i) {
            if (!new File(this.listSoundPaths.get(i)).getParent().equals(fldPath)) continue;
            this.play(i);
            break;
        }
    }

    public boolean hasSounds() {
        return !this.listSoundPaths.isEmpty();
    }

    public boolean isActive() {
        return this.isAlive() && this.hasSounds();
    }

    public boolean existsFolder(String folderPath) {
        return this.listFolderPaths.parallelStream().anyMatch(fp -> fp.equals(folderPath));
    }

    public boolean existsFolder(File folder) {
        return this.existsFolder(folder.getPath());
    }

    public boolean existsParent(String childPath) {
        return this.existsParent(new File(childPath));
    }

    public boolean existsParent(File child) {
        return this.existsFolder(child.getParent());
    }

    public TrackState getCurrentTrackState() {
        return this.current == null ? new UnknownState(this.current) : this.current.getTrackState();
    }

    public String getCurrentTrackStateToString() {
        return this.current == null ? "Unknown" : this.current.getStateToString();
    }

    public int getFoldersCount() {
        return this.listFolderPaths.size();
    }

    public File getRootFolder() {
        return this.rootFolder;
    }

    public List<String> getListFolderPaths() {
        return this.listFolderPaths;
    }

    public synchronized void jumpTrack(int jumps, SeekOption option) {
        if (option == SeekOption.NEXT) {
            this.trackIndex += jumps;
            if (this.trackIndex >= this.listSoundPaths.size()) {
                this.trackIndex = 0;
            }
        } else {
            this.trackIndex -= jumps;
            if (this.trackIndex < 0) {
                this.trackIndex = this.listSoundPaths.size() - 1;
            }
        }
        this.play(this.trackIndex);
    }

    public synchronized List<String> getListSoundPaths() {
        return this.listSoundPaths;
    }

    public synchronized List<File> getListSounds() {
        return this.listSoundPaths.stream().map(File::new).collect(Collectors.toList());
    }

    public synchronized List<AudioTag> getTrackTags() {
        LinkedList<AudioTag> listTags = new LinkedList<AudioTag>();
        this.listSoundPaths.forEach(soundPath -> {
            try {
                AudioTag tag = new AudioTag((String)soundPath);
                if (tag.isValidFile()) {
                    listTags.add(tag);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
        return listTags;
    }

    public synchronized List<TrackInfo> getTracksInfo() {
        LinkedList<TrackInfo> listInfo = new LinkedList<TrackInfo>();
        this.listSoundPaths.forEach(soundPath -> {
            try {
                AudioTag tag = new AudioTag((String)soundPath);
                if (tag.isValidFile()) {
                    listInfo.add(new SongData(tag));
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
        return listInfo;
    }

    public synchronized List<Artist> getArtists() {
        List<TrackInfo> listTracks = this.getTracksInfo();
        LinkedList<Artist> listArtists = new LinkedList<Artist>();
        listTracks.parallelStream().forEach(track -> {
            String art = track.getArtist();
            if (art == null) {
                art = "Unknown";
            }
            List list = listArtists;
            synchronized (list) {
                String finalArt = art;
                Artist artist = listArtists.parallelStream().filter(a -> a.getName().equalsIgnoreCase(finalArt)).findFirst().orElse(null);
                if (artist == null) {
                    artist = new Artist();
                    artist.setName(finalArt);
                    listArtists.add(artist);
                }
                artist.addTrack((TrackInfo)track);
            }
        });
        listArtists.sort(Comparator.comparing(Artist::getName));
        return listArtists;
    }

    public synchronized List<Album> getAlbums() {
        List<TrackInfo> listTracks = this.getTracksInfo();
        LinkedList<Album> listAlbums = new LinkedList<Album>();
        listTracks.parallelStream().forEach(track -> {
            String alb = track.getAlbum();
            if (alb == null) {
                alb = "Unknown";
            }
            List list = listAlbums;
            synchronized (list) {
                String finalAlb = alb;
                Album album = listAlbums.parallelStream().filter(a -> a.getName().equalsIgnoreCase(finalAlb)).findFirst().orElse(null);
                if (album == null) {
                    album = new Album();
                    album.setName(finalAlb);
                    listAlbums.add(album);
                }
                album.addTrack((TrackInfo)track);
            }
        });
        listAlbums.sort(Comparator.comparing(Album::getName));
        return listAlbums;
    }

    public synchronized void addPlayerListener(PlayerListener listener) {
        this.listListeners.add(listener);
    }

    public synchronized List<PlayerListener> getListeners() {
        return this.listListeners;
    }

    public synchronized void removePlayerListener(PlayerListener reference) {
        this.listListeners.removeIf(listener -> listener.equals(reference));
    }

    public synchronized void removeAllListeners() {
        this.listListeners.clear();
    }

    public synchronized void reloadTracks() {
        if (this.rootFolder != null) {
            int currentIndex = this.trackIndex;
            this.listSoundPaths.clear();
            this.listFolderPaths.clear();
            this.loadTracks(this.rootFolder);
            this.sortTracks();
            int songCount = this.getSongsCount();
            if (songCount > currentIndex) {
                this.trackIndex = currentIndex;
            }
        }
    }

    public PlayerInfo getInfo() {
        return new PlayerInfo(this);
    }

    public synchronized Track getCurrent() {
        return this.current;
    }

    public synchronized TrackInfo getNext() {
        int songsCount = this.getSongsCount();
        int nextIndex = this.trackIndex == -1 ? 0 : (this.trackIndex == songsCount - 1 ? 0 : this.trackIndex + 1);
        return Track.getTrack(this.listSoundPaths.get(nextIndex), (PlayerControls)this);
    }

    public synchronized TrackInfo getPrevious() {
        int songsCount = this.getSongsCount();
        int prevIndex = this.trackIndex == -1 ? 0 : (this.trackIndex == 0 ? songsCount - 1 : this.trackIndex - 1);
        return Track.getTrack(this.listSoundPaths.get(prevIndex), (PlayerControls)this);
    }

    public synchronized Speaker getTrackSpeaker() {
        return this.current.getTrackLine();
    }

    public synchronized SourceDataLine getTrackLine() {
        return this.current == null ? null : (this.current.getTrackLine() == null ? null : this.current.getTrackLine().getDriver());
    }

    @Override
    public synchronized boolean isPlaying() {
        return this.current != null && this.current.isPlaying();
    }

    @Override
    public synchronized boolean isPaused() {
        return this.current != null && this.current.isPaused();
    }

    @Override
    public synchronized boolean isStopped() {
        return this.current != null && this.current.isStopped();
    }

    @Override
    public synchronized boolean isFinished() {
        return this.current != null && this.current.isFinished();
    }

    @Override
    public synchronized boolean isMute() {
        return this.isMute;
    }

    @Override
    public synchronized void open(File sound) {
        if (!Track.isValidTrack(sound)) {
            return;
        }
        this.listSoundPaths.clear();
        this.listFolderPaths.clear();
        this.listSoundPaths.add(sound.getPath());
        this.listFolderPaths.add(sound.getParent());
        if (this.isPlaying()) {
            this.current.finish();
        } else if (this.isAlive()) {
            this.current = Track.getTrack(sound, (PlayerControls)this);
            this.startThreadTrack();
        } else {
            this.start();
        }
    }

    @Override
    public synchronized void open(List<File> listSounds) {
        if (listSounds.parallelStream().anyMatch(Track::isValidTrack)) {
            this.listSoundPaths.clear();
            this.listFolderPaths.clear();
            this.loadTracks(listSounds);
            this.sortTracks();
        }
    }

    @Override
    public synchronized void addMusic(List<File> listSounds) {
        if (!listSounds.isEmpty()) {
            Consumer<File> consumer = sound -> {
                if (sound.isDirectory()) {
                    this.loadTracks((File)sound);
                } else if (Track.isValidTrack(sound)) {
                    this.listSoundPaths.add(sound.getPath());
                }
            };
            listSounds.forEach(consumer);
        }
    }

    @Override
    public synchronized void addMusic(File musicFolder) {
        if (musicFolder.isDirectory()) {
            if (this.rootFolder == null) {
                this.rootFolder = musicFolder;
            }
            boolean validSort = !this.hasSounds();
            this.loadTracks(musicFolder);
            if (validSort) {
                this.sortTracks();
            }
        } else if (Track.isValidTrack(musicFolder)) {
            this.listSoundPaths.add(musicFolder.getPath());
            String parentPath = musicFolder.getParent();
            if (!this.listFolderPaths.parallelStream().anyMatch(sp -> parentPath.equals(sp))) {
                this.listFolderPaths.add(parentPath);
            }
        }
    }

    public int getSongsCount() {
        return this.listSoundPaths.size();
    }

    public synchronized void seekFolder(SeekOption param) {
        this.seekFolder(param, 1);
    }

    public synchronized void seekFolder(SeekOption option, int jumps) {
        int folderIndex = this.getFolderIndex();
        if (folderIndex != -1) {
            int newFolderIndex;
            String parentToFind = option == SeekOption.NEXT ? ((newFolderIndex = folderIndex + jumps) >= this.getFoldersCount() ? this.listFolderPaths.get(0) : this.listFolderPaths.get(newFolderIndex)) : ((newFolderIndex = folderIndex - jumps) < 0 ? this.listFolderPaths.get(this.listFolderPaths.size() - 1) : this.listFolderPaths.get(newFolderIndex));
            Track next = this.findFirstIn(parentToFind);
            if (next != null) {
                try {
                    this.trackIndex = this.listSoundPaths.indexOf(next.getDataSource().getCanonicalPath());
                    if (this.current != null) {
                        this.current.kill();
                    }
                    this.current = next;
                    this.startThreadTrack();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    @Override
    public synchronized void play() {
        if (!this.isAlive()) {
            this.start();
        } else if (this.current != null) {
            this.current.play();
            this.loadListenerMethod("onPlayed", this.current);
        }
    }

    public void play(int index) {
        if (index < 0 || index >= this.getSongsCount()) {
            return;
        }
        if (this.current != null) {
            this.current.kill();
            String soundPath = this.listSoundPaths.get(index);
            Track track = Track.getTrack(soundPath, (PlayerControls)this);
            if (track != null) {
                this.current = track;
                this.startThreadTrack();
                this.trackIndex = index;
                this.loadListenerMethod("onPlayed", this.current);
            }
        }
    }

    @Override
    public synchronized void play(File track) {
        int indexOf = this.listSoundPaths.indexOf(track.getPath());
        if (indexOf == -1) {
            if (Track.isValidTrack(track)) {
                this.listSoundPaths.add(track.getPath());
                if (!this.existsFolder(track.getParent())) {
                    this.listFolderPaths.add(track.getParent());
                }
            }
        } else {
            this.trackIndex = indexOf;
            if (this.current != null) {
                this.current.kill();
            }
            this.current = Track.getTrack(track, (PlayerControls)this);
            this.startThreadTrack();
            this.loadListenerMethod("onPlayed", this.current);
        }
    }

    @Override
    public synchronized void play(String trackName) {
        int indexOf = -1;
        File song = null;
        for (int i = 0; i < this.listSoundPaths.size(); ++i) {
            song = new File(this.listSoundPaths.get(i));
            if (song.getName().equals(trackName)) {
                indexOf = i;
                break;
            }
            song = null;
        }
        if (indexOf != -1) {
            this.trackIndex = indexOf;
            if (this.current != null) {
                this.current.kill();
            }
            this.current = Track.getTrack(song, (PlayerControls)this);
            this.startThreadTrack();
            this.loadListenerMethod("onPlayed", this.current);
        }
    }

    @Override
    public synchronized void pause() {
        if (this.current != null) {
            this.current.pause();
            this.loadListenerMethod("onPaused", this.current);
        }
    }

    @Override
    public synchronized void resumeTrack() {
        if (this.current != null) {
            this.current.resumeTrack();
            this.loadListenerMethod("onResumed", this.current);
        }
    }

    @Override
    public synchronized void stopTrack() throws Exception {
        if (this.current != null) {
            this.current.stopTrack();
            this.loadListenerMethod("onStopped", this.current);
        }
    }

    @Override
    public synchronized void finish() {
        this.shutdown();
    }

    @Override
    public synchronized void seek(double seconds) {
        if (this.current != null) {
            try {
                this.current.seek(seconds);
                this.loadListenerMethod("onSeeked", this.current);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public synchronized void gotoSecond(double second) {
        if (this.current != null) {
            try {
                this.current.gotoSecond(second);
            }
            catch (IOException | LineUnavailableException | UnsupportedAudioFileException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public synchronized float getGain() {
        return this.current == null ? this.currentVolume : this.current.getGain();
    }

    @Override
    public synchronized void setGain(float volume) {
        this.currentVolume = volume;
        if (this.current != null) {
            this.current.setGain(volume);
        }
        this.isMute = this.currentVolume == 0.0f;
    }

    @Override
    public float getSystemVolume() {
        return LineUtil.getFormattedMasterVolume();
    }

    @Override
    public void setSystemVolume(float volume) {
        LineUtil.setFormattedMasterVolume(volume);
    }

    @Override
    public synchronized void mute() {
        this.isMute = true;
        if (this.current != null) {
            this.current.mute();
        }
    }

    @Override
    public synchronized void unmute() {
        this.isMute = false;
        if (this.current != null) {
            this.current.setGain(this.currentVolume);
        } else {
            this.currentVolume = 100.0f;
        }
    }

    @Override
    public double getProgress() {
        return this.current == null ? 0.0 : this.current.getProgress();
    }

    public String getFormattedProgress() {
        return this.current == null ? "00:00" : this.current.getFormattedProgress();
    }

    @Override
    public synchronized void playNext() {
        if (this.current != null) {
            this.current.kill();
        }
        this.getNextTrack(SeekOption.NEXT);
        this.startThreadTrack();
        this.loadListenerMethod("onSongChange", this.current);
    }

    @Override
    public synchronized void playPrevious() {
        if (this.current != null) {
            this.current.kill();
        }
        this.getNextTrack(SeekOption.PREV);
        this.startThreadTrack();
        this.loadListenerMethod("onSongChange", this.current);
    }

    public void playFolder(String path) {
        if (this.current != null) {
            this.current.kill();
        }
        if (this.listFolderPaths.contains(path)) {
            this.playFolderSongs(path);
        }
    }

    public void playFolder(int index) {
        if (index < this.getFoldersCount()) {
            this.trackIndex = this.moveToFolder(this.listFolderPaths.get(index));
            this.playNext();
        }
    }

    @Override
    public synchronized void shutdown() {
        this.on = false;
        this.shutdownCurrent();
        this.interrupt();
        this.loadListenerMethod("onShutdown", null);
    }

    @Override
    public synchronized void run() {
        this.loadListenerMethod("onStarted", null);
        this.startPlaying();
        this.freezePlayer();
    }
}

