/*
 * Decompiled with CFR 0.152.
 */
package org.muplayer.audio.formats;

import com.sun.media.sound.AiffFileReader;
import com.sun.media.sound.AuFileReader;
import com.sun.media.sound.WaveFileReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.UnsupportedAudioFileException;
import org.muplayer.audio.Track;
import org.muplayer.audio.interfaces.PlayerControls;
import org.muplayer.system.AudioUtil;

public class PCMTrack
extends Track {
    public PCMTrack(File ftrack) throws LineUnavailableException, IOException, UnsupportedAudioFileException {
        super(ftrack);
    }

    public PCMTrack(String trackPath) throws LineUnavailableException, IOException, UnsupportedAudioFileException {
        super(trackPath);
    }

    public PCMTrack(InputStream inputStream) throws UnsupportedAudioFileException, IOException, LineUnavailableException {
        super(inputStream);
    }

    public PCMTrack(File dataSource, PlayerControls player) throws LineUnavailableException, IOException, UnsupportedAudioFileException {
        super(dataSource, player);
    }

    public PCMTrack(InputStream inputStream, PlayerControls player) throws UnsupportedAudioFileException, IOException, LineUnavailableException {
        super(inputStream, player);
    }

    public PCMTrack(String trackPath, PlayerControls player) throws LineUnavailableException, IOException, UnsupportedAudioFileException {
        super(trackPath, player);
    }

    @Override
    protected void loadAudioStream() throws IOException, UnsupportedAudioFileException {
        String extension;
        AudioFileFormat fileFormat = AudioSystem.getAudioFileFormat(this.dataSource);
        switch (extension = '.' + fileFormat.getType().getExtension().toLowerCase()) {
            case "wav": {
                this.audioReader = new WaveFileReader();
                break;
            }
            case "aiff": 
            case "aifc": {
                this.audioReader = new AiffFileReader();
                break;
            }
            default: {
                this.audioReader = new AuFileReader();
            }
        }
        this.trackStream = AudioUtil.instanceStream(this.audioReader, this.source);
    }

    @Override
    protected double convertSecondsToBytes(Number seconds) {
        AudioFormat audioFormat = this.getAudioFormat();
        float frameRate = audioFormat.getFrameRate();
        int frameSize = audioFormat.getFrameSize();
        double framesToSeek = (double)frameRate * seconds.doubleValue();
        return framesToSeek * (double)frameSize;
    }

    @Override
    protected double convertBytesToSeconds(Number bytes) {
        AudioFormat audioFormat = this.getAudioFormat();
        return bytes.doubleValue() / (double)audioFormat.getFrameSize() / (double)audioFormat.getFrameRate();
    }
}

