/*
 * Decompiled with CFR 0.152.
 */
package org.muplayer.audio.formats;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.UnsupportedAudioFileException;
import javazoom.spi.mpeg.sampled.file.MpegAudioFileReader;
import org.jaudiotagger.audio.exceptions.InvalidAudioFrameException;
import org.jaudiotagger.audio.mp3.MP3AudioHeader;
import org.muplayer.audio.Track;
import org.muplayer.audio.codec.DecodeManager;
import org.muplayer.audio.interfaces.PlayerControls;
import org.muplayer.system.AudioUtil;

public class MP3Track
extends Track {
    private volatile MP3AudioHeader audioHeader;
    private volatile long audioStartByte;
    private volatile long audioSize;
    private volatile long frameCount;
    private volatile long frameSize;
    private volatile double frameDurationInSec;

    public MP3Track(File ftrack) throws IOException, UnsupportedAudioFileException, LineUnavailableException, InvalidAudioFrameException {
        this(ftrack, null);
    }

    public MP3Track(String trackPath) throws UnsupportedAudioFileException, IOException, LineUnavailableException, InvalidAudioFrameException {
        this(trackPath, null);
    }

    public MP3Track(InputStream inputStream) throws UnsupportedAudioFileException, IOException, LineUnavailableException {
        this(inputStream, null);
    }

    public MP3Track(File dataSource, PlayerControls player) throws LineUnavailableException, IOException, UnsupportedAudioFileException, InvalidAudioFrameException {
        super(dataSource, player);
        this.audioHeader = new MP3AudioHeader(dataSource);
        this.audioStartByte = this.audioHeader.getMp3StartByte();
        this.audioSize = dataSource.length() - this.audioStartByte;
        this.frameCount = this.audioHeader.getNumberOfFrames();
        this.frameSize = this.audioSize / this.frameCount;
        this.frameDurationInSec = this.audioHeader.getPreciseTrackLength() / (double)this.frameCount;
    }

    public MP3Track(InputStream inputStream, PlayerControls player) throws UnsupportedAudioFileException, IOException, LineUnavailableException {
        super(inputStream, player);
    }

    public MP3Track(String trackPath, PlayerControls player) throws LineUnavailableException, IOException, UnsupportedAudioFileException, InvalidAudioFrameException {
        this(new File(trackPath), player);
    }

    @Override
    protected void loadAudioStream() throws IOException, UnsupportedAudioFileException {
        this.audioReader = new MpegAudioFileReader();
        AudioInputStream soundAis = AudioUtil.instanceStream(this.audioReader, this.source);
        AudioFormat baseFormat = soundAis.getFormat();
        if (this.trackStream != null) {
            this.trackStream.close();
        }
        this.trackStream = DecodeManager.decodeToPcm(baseFormat, soundAis);
    }

    @Override
    protected double convertSecondsToBytes(Number seconds) {
        double frameNeeded = seconds.doubleValue() / this.frameDurationInSec;
        return frameNeeded * (double)this.frameSize;
    }

    @Override
    protected double convertBytesToSeconds(Number bytes) {
        return bytes.doubleValue() / (double)this.frameSize * this.frameDurationInSec;
    }
}

