/*
 * Decompiled with CFR 0.152.
 */
package org.xiph.speex;

import java.io.DataOutput;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import org.jetbrains.annotations.NotNull;

public abstract class AudioFileWriter {
    public abstract void close() throws IOException;

    public abstract void open(File var1) throws IOException;

    public abstract void open(String var1) throws IOException;

    public abstract void writeHeader(String var1) throws IOException;

    public abstract void writePacket(byte[] var1, int var2, int var3) throws IOException;

    public static int writeOggPageHeader(@NotNull byte[] buf, int offset, int headerType, long granulepos, int streamSerialNumber, int pageCount, int packetCount, @NotNull byte[] packetSizes) {
        AudioFileWriter.writeString(buf, offset, "OggS");
        buf[offset + 4] = 0;
        buf[offset + 5] = (byte)headerType;
        AudioFileWriter.writeLong(buf, offset + 6, granulepos);
        AudioFileWriter.writeInt(buf, offset + 14, streamSerialNumber);
        AudioFileWriter.writeInt(buf, offset + 18, pageCount);
        AudioFileWriter.writeInt(buf, offset + 22, 0);
        buf[offset + 26] = (byte)packetCount;
        System.arraycopy(packetSizes, 0, buf, offset + 27, packetCount);
        return packetCount + 27;
    }

    @NotNull
    public static byte[] buildOggPageHeader(int headerType, long granulepos, int streamSerialNumber, int pageCount, int packetCount, @NotNull byte[] packetSizes) {
        byte[] data = new byte[packetCount + 27];
        AudioFileWriter.writeOggPageHeader(data, 0, headerType, granulepos, streamSerialNumber, pageCount, packetCount, packetSizes);
        return data;
    }

    public static int writeSpeexHeader(@NotNull byte[] buf, int offset, int sampleRate, int mode, int channels, boolean vbr, int nframes) {
        AudioFileWriter.writeString(buf, offset, "Speex   ");
        AudioFileWriter.writeString(buf, offset + 8, "speex-1.0");
        System.arraycopy(new byte[11], 0, buf, offset + 17, 11);
        AudioFileWriter.writeInt(buf, offset + 28, 1);
        AudioFileWriter.writeInt(buf, offset + 32, 80);
        AudioFileWriter.writeInt(buf, offset + 36, sampleRate);
        AudioFileWriter.writeInt(buf, offset + 40, mode);
        AudioFileWriter.writeInt(buf, offset + 44, 4);
        AudioFileWriter.writeInt(buf, offset + 48, channels);
        AudioFileWriter.writeInt(buf, offset + 52, -1);
        AudioFileWriter.writeInt(buf, offset + 56, 160 << mode);
        AudioFileWriter.writeInt(buf, offset + 60, vbr ? 1 : 0);
        AudioFileWriter.writeInt(buf, offset + 64, nframes);
        AudioFileWriter.writeInt(buf, offset + 68, 0);
        AudioFileWriter.writeInt(buf, offset + 72, 0);
        AudioFileWriter.writeInt(buf, offset + 76, 0);
        return 80;
    }

    @NotNull
    public static byte[] buildSpeexHeader(int sampleRate, int mode, int channels, boolean vbr, int nframes) {
        byte[] data = new byte[80];
        AudioFileWriter.writeSpeexHeader(data, 0, sampleRate, mode, channels, vbr, nframes);
        return data;
    }

    public static int writeSpeexComment(@NotNull byte[] buf, int offset, @NotNull String comment) {
        int length = comment.length();
        AudioFileWriter.writeInt(buf, offset, length);
        AudioFileWriter.writeString(buf, offset + 4, comment);
        AudioFileWriter.writeInt(buf, offset + length + 4, 0);
        return length + 8;
    }

    @NotNull
    public static byte[] buildSpeexComment(@NotNull String comment) {
        byte[] data = new byte[comment.length() + 8];
        AudioFileWriter.writeSpeexComment(data, 0, comment);
        return data;
    }

    public static void writeShort(@NotNull DataOutput out, short v) throws IOException {
        out.writeByte(0xFF & v);
        out.writeByte(0xFF & v >>> 8);
    }

    public static void writeInt(@NotNull DataOutput out, int v) throws IOException {
        out.writeByte(0xFF & v);
        out.writeByte(0xFF & v >>> 8);
        out.writeByte(0xFF & v >>> 16);
        out.writeByte(0xFF & v >>> 24);
    }

    public static void writeShort(@NotNull OutputStream os, short v) throws IOException {
        os.write(0xFF & v);
        os.write(0xFF & v >>> 8);
    }

    public static void writeInt(@NotNull OutputStream os, int v) throws IOException {
        os.write(0xFF & v);
        os.write(0xFF & v >>> 8);
        os.write(0xFF & v >>> 16);
        os.write(0xFF & v >>> 24);
    }

    public static void writeLong(@NotNull OutputStream os, long v) throws IOException {
        os.write((int)(0xFFL & v));
        os.write((int)(0xFFL & v >>> 8));
        os.write((int)(0xFFL & v >>> 16));
        os.write((int)(0xFFL & v >>> 24));
        os.write((int)(0xFFL & v >>> 32));
        os.write((int)(0xFFL & v >>> 40));
        os.write((int)(0xFFL & v >>> 48));
        os.write((int)(0xFFL & v >>> 56));
    }

    public static void writeShort(byte[] data, int offset, int v) {
        data[offset] = (byte)(0xFF & v);
        data[offset + 1] = (byte)(0xFF & v >>> 8);
    }

    public static void writeInt(byte[] data, int offset, int v) {
        data[offset] = (byte)(0xFF & v);
        data[offset + 1] = (byte)(0xFF & v >>> 8);
        data[offset + 2] = (byte)(0xFF & v >>> 16);
        data[offset + 3] = (byte)(0xFF & v >>> 24);
    }

    public static void writeLong(byte[] data, int offset, long v) {
        data[offset] = (byte)(0xFFL & v);
        data[offset + 1] = (byte)(0xFFL & v >>> 8);
        data[offset + 2] = (byte)(0xFFL & v >>> 16);
        data[offset + 3] = (byte)(0xFFL & v >>> 24);
        data[offset + 4] = (byte)(0xFFL & v >>> 32);
        data[offset + 5] = (byte)(0xFFL & v >>> 40);
        data[offset + 6] = (byte)(0xFFL & v >>> 48);
        data[offset + 7] = (byte)(0xFFL & v >>> 56);
    }

    public static void writeString(@NotNull byte[] data, int offset, @NotNull String v) {
        byte[] str = v.getBytes();
        System.arraycopy(str, 0, data, offset, str.length);
    }
}

