/*
 * Decompiled with CFR 0.152.
 */
package sun.tools.asm;

import java.io.DataOutputStream;
import java.io.IOException;
import sun.tools.asm.ConstantPool;
import sun.tools.asm.LocalVariable;
import sun.tools.java.Environment;
import sun.tools.java.MemberDefinition;

final class LocalVariableTable {
    LocalVariable[] locals = new LocalVariable[8];
    int len;

    LocalVariableTable() {
    }

    void define(MemberDefinition memberDefinition, int n, int n2, int n3) {
        if (n2 >= n3) {
            return;
        }
        for (int i = 0; i < this.len; ++i) {
            if (this.locals[i].field != memberDefinition || this.locals[i].slot != n || n2 > this.locals[i].to || n3 < this.locals[i].from) continue;
            this.locals[i].from = Math.min(this.locals[i].from, n2);
            this.locals[i].to = Math.max(this.locals[i].to, n3);
            return;
        }
        if (this.len == this.locals.length) {
            LocalVariable[] localVariableArray = new LocalVariable[this.len * 2];
            System.arraycopy(this.locals, 0, localVariableArray, 0, this.len);
            this.locals = localVariableArray;
        }
        this.locals[this.len++] = new LocalVariable(memberDefinition, n, n2, n3);
    }

    private void trim_ranges() {
        for (int i = 0; i < this.len; ++i) {
            for (int j = i + 1; j < this.len; ++j) {
                if (this.locals[i].field.getName() != this.locals[j].field.getName() || this.locals[i].from > this.locals[j].to || this.locals[i].to < this.locals[j].from) continue;
                if (this.locals[i].slot < this.locals[j].slot) {
                    if (this.locals[i].from >= this.locals[j].from) continue;
                    this.locals[i].to = Math.min(this.locals[i].to, this.locals[j].from);
                    continue;
                }
                if (this.locals[i].slot <= this.locals[j].slot || this.locals[i].from <= this.locals[j].from) continue;
                this.locals[j].to = Math.min(this.locals[j].to, this.locals[i].from);
            }
        }
    }

    void write(Environment environment, DataOutputStream dataOutputStream, ConstantPool constantPool) throws IOException {
        this.trim_ranges();
        dataOutputStream.writeShort(this.len);
        for (int i = 0; i < this.len; ++i) {
            dataOutputStream.writeShort(this.locals[i].from);
            dataOutputStream.writeShort(this.locals[i].to - this.locals[i].from);
            dataOutputStream.writeShort(constantPool.index(this.locals[i].field.getName().toString()));
            dataOutputStream.writeShort(constantPool.index(this.locals[i].field.getType().getTypeSignature()));
            dataOutputStream.writeShort(this.locals[i].slot);
        }
    }
}

