/*
 * Decompiled with CFR 0.152.
 */
package org.muplayer.audio.formats;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.util.List;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.UnsupportedAudioFileException;
import net.sourceforge.jaad.aac.Decoder;
import net.sourceforge.jaad.aac.SampleBuffer;
import net.sourceforge.jaad.mp4.MP4Container;
import net.sourceforge.jaad.mp4.api.AudioTrack;
import net.sourceforge.jaad.mp4.api.Frame;
import net.sourceforge.jaad.mp4.api.Movie;
import net.sourceforge.jaad.spi.javasound.AACAudioFileReader;
import org.muplayer.audio.Track;
import org.muplayer.audio.interfaces.PlayerControls;
import org.muplayer.system.AudioUtil;
import org.orangelogger.sys.Logger;

public class M4ATrack
extends Track {
    private boolean isAac;

    public M4ATrack(File ftrack) throws LineUnavailableException, IOException, UnsupportedAudioFileException {
        super(ftrack);
    }

    public M4ATrack(String trackPath) throws LineUnavailableException, IOException, UnsupportedAudioFileException {
        this(new File(trackPath));
    }

    public M4ATrack(InputStream inputStream) throws UnsupportedAudioFileException, IOException, LineUnavailableException {
        super(inputStream);
    }

    public M4ATrack(File dataSource, PlayerControls player) throws LineUnavailableException, IOException, UnsupportedAudioFileException {
        super(dataSource, player);
    }

    public M4ATrack(InputStream inputStream, PlayerControls player) throws UnsupportedAudioFileException, IOException, LineUnavailableException {
        super(inputStream, player);
    }

    public M4ATrack(String trackPath, PlayerControls player) throws LineUnavailableException, IOException, UnsupportedAudioFileException {
        super(trackPath, player);
    }

    @Override
    protected void loadAudioStream() {
        try {
            this.decodeAAC();
            this.isAac = true;
        }
        catch (UnsupportedAudioFileException e) {
            Logger.getLogger(this, (Object)"File not supported!").rawError();
            e.printStackTrace();
        }
        catch (IOException e) {
            this.trackStream = this.decodeM4A(this.source);
            this.isAac = false;
        }
    }

    private void decodeAAC() throws IOException, UnsupportedAudioFileException {
        this.audioReader = new AACAudioFileReader();
        this.trackStream = AudioUtil.instanceStream(this.audioReader, this.source);
    }

    private AudioTrack getM4ATrack(Object source) throws IOException, UnsupportedAudioFileException {
        MP4Container cont = source instanceof RandomAccessFile ? new MP4Container((RandomAccessFile)source) : new MP4Container((InputStream)source);
        Movie movie = cont.getMovie();
        List<net.sourceforge.jaad.mp4.api.Track> tracks = movie.getTracks(AudioTrack.AudioCodec.AAC);
        if (tracks.isEmpty()) {
            throw new UnsupportedAudioFileException("Movie does not contain any AAC track");
        }
        return (AudioTrack)tracks.get(0);
    }

    private AudioInputStream decodeM4A(Object source) {
        try {
            AudioTrack track;
            if (source instanceof File) {
                RandomAccessFile randomAccess = new RandomAccessFile((File)source, "r");
                track = this.getM4ATrack(randomAccess);
            } else {
                track = this.getM4ATrack(source);
            }
            Decoder dec = new Decoder(track.getDecoderSpecificInfo());
            SampleBuffer buffer = new SampleBuffer();
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            AudioFormat decFormat = new AudioFormat(track.getSampleRate(), track.getSampleSize(), track.getChannelCount(), true, true);
            while (track.hasMoreFrames()) {
                try {
                    Frame frame = track.readNextFrame();
                    dec.decodeFrame(frame.getData(), buffer);
                    baos.write(buffer.getData());
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            byte[] audioData = baos.toByteArray();
            if (audioData == null) {
                return null;
            }
            return new AudioInputStream(new ByteArrayInputStream(audioData), decFormat, audioData.length);
        }
        catch (Exception e) {
            Logger.getLogger(this, "Exception", (Object)e).error();
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public void seek(double seconds) throws IOException {
        if (this.isAac) {
            this.mute();
            super.seek(seconds);
            this.unmute();
        } else {
            super.seek(seconds);
        }
    }

    @Override
    public void gotoSecond(double second) throws IOException, LineUnavailableException, UnsupportedAudioFileException {
        double progress = this.getProgress();
        if (second >= progress) {
            int gt = (int)Math.round(second - this.getProgress());
            this.seek(gt);
        } else if (second < progress) {
            this.pause();
            if (this.isAac) {
                this.resetStream();
            } else {
                this.trackStream.reset();
                this.initLine();
            }
            this.resumeTrack();
            this.secsSeeked = 0.0;
            this.seek(second);
        }
    }
}

