/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jaad.mp4.boxes.impl;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.sourceforge.jaad.mp4.MP4InputStream;
import net.sourceforge.jaad.mp4.boxes.FullBox;
import net.sourceforge.jaad.mp4.od.Descriptor;
import net.sourceforge.jaad.mp4.od.ObjectDescriptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IPMPInfoBox
extends FullBox {
    private List<Descriptor> ipmpDescriptors;

    public IPMPInfoBox() {
        super("IPMP Info Box");
    }

    @Override
    public void decode(MP4InputStream in) throws IOException {
        super.decode(in);
        this.ipmpDescriptors = new ArrayList<Descriptor>();
        while (this.getLeft(in) > 0L) {
            Descriptor desc = ObjectDescriptor.createDescriptor(in);
            this.ipmpDescriptors.add(desc);
        }
    }

    public List<Descriptor> getIPMPDescriptors() {
        return Collections.unmodifiableList(this.ipmpDescriptors);
    }
}

