/*
 * Decompiled with CFR 0.152.
 */
package org.aucom.io;

import java.io.IOException;
import java.io.OutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.aucom.io.ElectroInputStream;
import org.bytebuffer.ByteBuffer;

public class ElectroOutputStream
extends OutputStream {
    private final ElectroInputStream electroInput;
    private boolean closed;

    public ElectroOutputStream() {
        this(new ElectroInputStream());
    }

    public ElectroOutputStream(ElectroInputStream electroInput) {
        this.electroInput = electroInput;
        this.closed = false;
    }

    public ElectroInputStream getElectroInput() {
        return this.electroInput;
    }

    public ByteBuffer getListBytes() {
        return this.electroInput.getListBytes();
    }

    public byte[] toByteArray() {
        return this.electroInput.getListBytes().toArray();
    }

    public void clear() {
        this.electroInput.clear();
    }

    public int size() {
        try {
            return this.electroInput.available();
        }
        catch (IOException ex) {
            Logger.getLogger(ElectroOutputStream.class.getName()).log(Level.SEVERE, null, ex);
            return 0;
        }
    }

    @Override
    public void close() throws IOException {
        this.closed = true;
    }

    @Override
    public void flush() throws IOException {
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        if (!this.closed) {
            for (int i = off; i < len; ++i) {
                this.write(b[i]);
            }
        }
    }

    @Override
    public void write(byte[] b) throws IOException {
        if (!this.closed) {
            for (int i = 0; i < b.length; ++i) {
                this.write(b[i]);
            }
        }
    }

    @Override
    public void write(int b) throws IOException {
        this.electroInput.addBytes((byte)b);
    }
}

