/*
 * Decompiled with CFR 0.152.
 */
package org.muplayer.audio.formats;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.UnsupportedAudioFileException;
import org.aucom.sound.Speaker;
import org.muplayer.audio.Track;
import org.muplayer.audio.codec.DecodeManager;
import org.muplayer.system.AudioUtil;
import org.tritonus.sampled.file.jorbis.JorbisAudioFileReader;

public class OGGTrack
extends Track {
    public OGGTrack(File ftrack) throws UnsupportedAudioFileException, IOException, LineUnavailableException {
        super(ftrack);
    }

    public OGGTrack(String trackPath) throws IOException, LineUnavailableException, UnsupportedAudioFileException {
        this(new File(trackPath));
    }

    public OGGTrack(InputStream inputStream) throws UnsupportedAudioFileException, IOException, LineUnavailableException {
        super(inputStream);
    }

    private AudioInputStream createAudioStream() throws IOException, UnsupportedAudioFileException {
        this.audioReader = new JorbisAudioFileReader();
        AudioInputStream soundAis = AudioUtil.instanceStream(this.audioReader, this.source);
        return DecodeManager.decodeToPcm(soundAis);
    }

    private Speaker createLine() throws LineUnavailableException {
        Speaker line = new Speaker(this.trackStream.getFormat());
        line.open();
        this.setGain(this.volume);
        return line;
    }

    @Override
    protected void loadAudioStream() throws IOException, UnsupportedAudioFileException {
        this.trackStream = this.createAudioStream();
    }

    @Override
    protected void initLine() throws LineUnavailableException {
        if (this.trackStream != null) {
            if (this.trackLine != null) {
                this.trackLine.stop();
                this.trackLine.close();
            }
            try {
                this.trackLine = this.createLine();
            }
            catch (IllegalArgumentException e1) {
                System.err.println("Error: " + e1.getMessage());
            }
        } else {
            System.out.println("TrackStream & TrackLine null");
        }
    }

    @Override
    public void seek(double seconds) throws IOException {
        this.pause();
        super.seek(seconds);
        this.resumeTrack();
    }

    @Override
    public void gotoSecond(double second) throws IOException, LineUnavailableException, UnsupportedAudioFileException {
        double progress = this.getProgress();
        if (second >= progress) {
            int duration = (int)this.getDuration();
            if (second > (double)duration) {
                second = duration;
            }
            int gt = (int)Math.round(second - this.getProgress());
            this.seek(gt);
        } else if (second < progress && this.isPlaying()) {
            if (second < 0.0) {
                second = 0.0;
            }
            AudioInputStream newStream = this.createAudioStream();
            Speaker newLine = this.createLine();
            this.suspend();
            this.closeAllStreams();
            this.trackStream = newStream;
            this.trackLine = newLine;
            this.seek(second);
            this.resumeTrack();
        }
    }
}

