/*
 * Decompiled with CFR 0.152.
 */
package org.muplayer.audio.formats.io;

import java.io.IOException;
import java.io.InputStream;
import org.bytebuffer.ByteBuffer;
import org.muplayer.audio.formats.io.AudioDataOutputStream;

public class AudioDataInputStream
extends InputStream {
    protected ByteBuffer byteBuffer;
    protected long readed;
    protected boolean isClosed;

    public AudioDataInputStream() {
        this(new ByteBuffer());
    }

    public AudioDataInputStream(ByteBuffer byteBuffer) {
        this.byteBuffer = byteBuffer;
        this.readed = 0L;
        this.isClosed = false;
    }

    public AudioDataInputStream(AudioDataOutputStream outputStream) {
        this(outputStream.getByteBuffer());
    }

    public synchronized ByteBuffer getByteBuffer() {
        return this.byteBuffer;
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    @Override
    public synchronized int read(byte[] b, int off, int len) throws IOException {
        if (this.isClosed) {
            return -1;
        }
        int available = this.available();
        if (available == 0) {
            return -1;
        }
        if (available < len) {
            len = available;
        }
        for (int i = 0; i < len; ++i) {
            b[i + off] = (byte)this.read();
        }
        this.readed += (long)len;
        return len;
    }

    @Override
    public synchronized long skip(long n) throws IOException {
        if (this.isClosed) {
            return 0L;
        }
        this.readed += n;
        return this.readed;
    }

    @Override
    public synchronized int available() throws IOException {
        return (int)((long)this.byteBuffer.size() - this.readed);
    }

    @Override
    public synchronized void close() throws IOException {
        this.isClosed = true;
    }

    @Override
    public synchronized void mark(int readlimit) {
        System.out.println("Mark: " + readlimit);
        if (!this.isClosed) {
            this.readed = readlimit;
        }
    }

    @Override
    public synchronized void reset() throws IOException {
        this.mark(0);
    }

    @Override
    public boolean markSupported() {
        return true;
    }

    @Override
    public synchronized int read() throws IOException {
        return this.isClosed ? -1 : (int)this.byteBuffer.get((int)this.readed++);
    }
}

