/*
 * Decompiled with CFR 0.152.
 */
package org.muplayer.audio.formats;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.UnsupportedAudioFileException;
import javazoom.spi.mpeg.sampled.file.MpegAudioFileReader;
import org.jaudiotagger.audio.exceptions.InvalidAudioFrameException;
import org.jaudiotagger.audio.mp3.MP3AudioHeader;
import org.muplayer.audio.Track;
import org.muplayer.audio.codec.DecodeManager;
import org.muplayer.system.AudioUtil;
import org.orangelogger.sys.Logger;

public class MP3Track
extends Track {
    private volatile MP3AudioHeader audioHeader;
    private volatile long audioStartByte;
    private volatile long audioSize;
    private volatile long frameCount;
    private volatile long frameSize;
    private volatile double frameDurationInSec;

    public MP3Track(File ftrack) throws IOException, UnsupportedAudioFileException, LineUnavailableException, InvalidAudioFrameException {
        super(ftrack);
        this.audioHeader = new MP3AudioHeader(ftrack);
        this.audioStartByte = this.audioHeader.getMp3StartByte();
        this.audioSize = this.dataSource.length() - this.audioStartByte;
        this.frameCount = this.audioHeader.getNumberOfFrames();
        this.frameSize = this.audioSize / this.frameCount;
        this.frameDurationInSec = this.audioHeader.getPreciseTrackLength() / (double)this.frameCount;
        System.out.println("AudioHeader: FrameSize: " + this.frameSize);
        System.out.println("AudioHeader: FrameCount: " + this.frameCount);
        System.out.println("AudioHeader: AudioSize: " + this.frameSize * this.frameCount);
        System.out.println("AudioHeader: FrameDuration: " + this.frameDurationInSec);
        System.out.println("AudioHeader: FrameDurationXframeCount: " + this.frameDurationInSec * (double)this.frameCount);
        System.out.println("AudioHeader: StartByte: " + this.audioStartByte);
        System.out.println("AudioHeader: Mp3StartByte: " + this.audioHeader.getMp3StartByte());
        System.out.println("AudioHeader: TrackLenght: " + this.audioHeader.getTrackLength());
        System.out.println("AudioHeader: PreciseTrackLenght: " + this.audioHeader.getPreciseTrackLength());
        System.out.println("AudioHeader: AudioDataLenght: " + this.audioHeader.getTrackLengthAsString());
        System.out.println("AudioHeader: LenghtAsString: " + this.audioHeader.getTrackLengthAsString());
        System.out.println("AudioInputStream: FrameLenght: " + this.trackStream.getFrameLength());
        System.out.println("AudioInputStream: FrameSize: " + this.trackStream.getFormat().getFrameSize());
        System.out.println("File: AudioSize: " + this.audioSize);
        System.out.println("----------------------------------------");
    }

    public MP3Track(String trackPath) throws UnsupportedAudioFileException, IOException, LineUnavailableException, InvalidAudioFrameException {
        this(new File(trackPath));
    }

    public MP3Track(InputStream inputStream) throws UnsupportedAudioFileException, IOException, LineUnavailableException {
        super(inputStream);
    }

    @Override
    protected void loadAudioStream() throws IOException, UnsupportedAudioFileException {
        this.audioReader = new MpegAudioFileReader();
        AudioInputStream soundAis = AudioUtil.instanceStream(this.audioReader, this.source);
        AudioFormat baseFormat = soundAis.getFormat();
        if (this.trackStream != null) {
            this.trackStream.close();
        }
        this.trackStream = DecodeManager.decodeToPcm(baseFormat, soundAis);
    }

    private long getBytesToSeek(double sec) {
        double frameNeeded = sec / this.frameDurationInSec;
        long toSkip = Math.round(frameNeeded * (double)this.frameSize);
        System.out.println("ToSkip: " + toSkip);
        return toSkip;
    }

    @Override
    public void seek(double seconds) throws IOException {
        if (seconds == 0.0) {
            return;
        }
        this.secsSeeked += seconds;
        long bytesToSeek = this.getBytesToSeek(seconds);
        long skip = -2L;
        try {
            skip = this.trackStream.skip(bytesToSeek);
            System.out.println("Skipped: " + skip + "/BytesToSkip: " + bytesToSeek);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            Logger.getLogger(this, e.getClass().getSimpleName(), (Object)e.getMessage()).error();
        }
    }
}

