/*
 * Decompiled with CFR 0.152.
 */
package sun.rmi.rmic.iiop;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.HashSet;
import sun.rmi.rmic.IndentingWriter;
import sun.rmi.rmic.Main;
import sun.rmi.rmic.iiop.BatchEnvironment;
import sun.rmi.rmic.iiop.CompoundType;
import sun.rmi.rmic.iiop.Constants;
import sun.rmi.rmic.iiop.ContextStack;
import sun.rmi.rmic.iiop.IDLNames;
import sun.rmi.rmic.iiop.Type;
import sun.rmi.rmic.iiop.Util;
import sun.tools.java.ClassDefinition;
import sun.tools.java.ClassFile;
import sun.tools.java.ClassPath;
import sun.tools.java.Identifier;

public abstract class Generator
implements sun.rmi.rmic.Generator,
Constants {
    protected boolean alwaysGenerate = false;
    protected BatchEnvironment env = null;
    protected ContextStack contextStack = null;
    private boolean trace = false;
    protected boolean idl = false;

    public boolean parseArgs(String[] stringArray, Main main) {
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i] == null) continue;
            if (stringArray[i].equalsIgnoreCase("-always") || stringArray[i].equalsIgnoreCase("-alwaysGenerate")) {
                this.alwaysGenerate = true;
                stringArray[i] = null;
                continue;
            }
            if (!stringArray[i].equalsIgnoreCase("-xtrace")) continue;
            this.trace = true;
            stringArray[i] = null;
        }
        return true;
    }

    protected abstract boolean parseNonConforming(ContextStack var1);

    protected abstract CompoundType getTopType(ClassDefinition var1, ContextStack var2);

    protected abstract OutputType[] getOutputTypesFor(CompoundType var1, HashSet var2);

    protected abstract String getFileNameExtensionFor(OutputType var1);

    protected abstract void writeOutputFor(OutputType var1, HashSet var2, IndentingWriter var3) throws IOException;

    protected abstract boolean requireNewInstance();

    public boolean requiresGeneration(File file, Type type) {
        boolean bl = this.alwaysGenerate;
        if (!bl) {
            String string;
            ClassPath classPath = this.env.getClassPath();
            ClassFile classFile = classPath.getFile((string = type.getQualifiedName().replace('.', File.separatorChar)) + ".source");
            if (classFile == null) {
                classFile = classPath.getFile(string + ".class");
            }
            if (classFile != null) {
                long l;
                long l2 = classFile.lastModified();
                String string2 = IDLNames.replace(file.getName(), ".java", ".class");
                String string3 = file.getParent();
                File file2 = new File(string3, string2);
                bl = file2.exists() ? (l = file2.lastModified()) < l2 : true;
            } else {
                bl = true;
            }
        }
        return bl;
    }

    protected Generator newInstance() {
        Generator generator = null;
        try {
            generator = (Generator)this.getClass().newInstance();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return generator;
    }

    protected Generator() {
    }

    public void generate(sun.rmi.rmic.BatchEnvironment batchEnvironment, ClassDefinition classDefinition, File file) {
        this.env = (BatchEnvironment)batchEnvironment;
        this.contextStack = new ContextStack(this.env);
        this.contextStack.setTrace(this.trace);
        this.env.setParseNonConforming(this.parseNonConforming(this.contextStack));
        CompoundType compoundType = this.getTopType(classDefinition, this.contextStack);
        if (compoundType != null) {
            Generator generator = this;
            if (this.requireNewInstance()) {
                generator = this.newInstance();
            }
            generator.generateOutputFiles(compoundType, this.env, file);
        }
    }

    protected void generateOutputFiles(CompoundType compoundType, BatchEnvironment batchEnvironment, File file) {
        HashSet hashSet = batchEnvironment.alreadyChecked;
        OutputType[] outputTypeArray = this.getOutputTypesFor(compoundType, hashSet);
        for (int i = 0; i < outputTypeArray.length; ++i) {
            OutputType outputType = outputTypeArray[i];
            String string = outputType.getName();
            File file2 = this.getFileFor(outputType, file);
            boolean bl = false;
            if (this.requiresGeneration(file2, outputType.getType())) {
                if (file2.getName().endsWith(".java") && (bl = this.compileJavaSourceFile(outputType))) {
                    batchEnvironment.addGeneratedFile(file2);
                }
                try {
                    IndentingWriter indentingWriter = new IndentingWriter(new OutputStreamWriter(new FileOutputStream(file2)), 4, Integer.MAX_VALUE);
                    long l = 0L;
                    if (batchEnvironment.verbose()) {
                        l = System.currentTimeMillis();
                    }
                    this.writeOutputFor(outputTypeArray[i], hashSet, indentingWriter);
                    indentingWriter.close();
                    if (batchEnvironment.verbose()) {
                        long l2 = System.currentTimeMillis() - l;
                        batchEnvironment.output(Main.getText("rmic.generated", file2.getPath(), Long.toString(l2)));
                    }
                    if (!bl) continue;
                    batchEnvironment.parseFile(new ClassFile(file2));
                    continue;
                }
                catch (IOException iOException) {
                    batchEnvironment.error(0L, "cant.write", file2.toString());
                    return;
                }
            }
            if (!batchEnvironment.verbose()) continue;
            batchEnvironment.output(Main.getText("rmic.previously.generated", file2.getPath()));
        }
    }

    protected File getFileFor(OutputType outputType, File file) {
        Identifier identifier = this.getOutputId(outputType);
        File file2 = null;
        file2 = this.idl ? Util.getOutputDirectoryForIDL(identifier, file, this.env) : Util.getOutputDirectoryForStub(identifier, file, this.env);
        String string = outputType.getName() + this.getFileNameExtensionFor(outputType);
        return new File(file2, string);
    }

    protected Identifier getOutputId(OutputType outputType) {
        return outputType.getType().getIdentifier();
    }

    protected boolean compileJavaSourceFile(OutputType outputType) {
        return true;
    }

    public class OutputType {
        private String name;
        private Type type;

        public OutputType(String string, Type type) {
            this.name = string;
            this.type = type;
        }

        public String getName() {
            return this.name;
        }

        public Type getType() {
            return this.type;
        }
    }
}

