/*
 * Decompiled with CFR 0.152.
 */
package org.muplayer.audio.formats;

import java.io.File;
import java.io.IOException;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.UnsupportedAudioFileException;
import javazoom.spi.mpeg.sampled.file.MpegAudioFileReader;
import org.jaudiotagger.audio.exceptions.InvalidAudioFrameException;
import org.jaudiotagger.audio.mp3.MP3AudioHeader;
import org.muplayer.audio.Track;
import org.muplayer.audio.codec.DecodeManager;
import org.orangelogger.sys.Logger;

public class MP3Track
extends Track {
    private volatile MP3AudioHeader audioHeader;
    private volatile long audioStartByte;
    private volatile long audioSize;
    private volatile long frameCount;
    private volatile long frameSize;
    private volatile double frameDurationInSec;

    public MP3Track(File ftrack) throws IOException, UnsupportedAudioFileException, LineUnavailableException, InvalidAudioFrameException {
        super(ftrack);
        this.audioHeader = new MP3AudioHeader(ftrack);
        this.audioStartByte = this.audioHeader.getMp3StartByte();
        this.audioSize = this.dataSource.length() - this.audioStartByte;
        this.frameCount = this.audioHeader.getNumberOfFrames();
        this.frameSize = this.audioSize / this.frameCount;
        this.frameDurationInSec = this.audioHeader.getPreciseTrackLength() / (double)this.frameCount;
    }

    public MP3Track(String trackPath) throws UnsupportedAudioFileException, IOException, LineUnavailableException, InvalidAudioFrameException {
        this(new File(trackPath));
    }

    @Override
    protected void loadAudioStream() throws IOException, UnsupportedAudioFileException {
        this.audioReader = new MpegAudioFileReader();
        AudioInputStream soundAis = this.audioReader.getAudioInputStream(this.dataSource);
        AudioFormat baseFormat = soundAis.getFormat();
        if (this.trackStream != null) {
            this.trackStream.close();
        }
        this.trackStream = DecodeManager.decodeToPcm(baseFormat, soundAis);
    }

    private long getBytesToSeek(double sec) {
        double frameNeeded = sec / this.frameDurationInSec;
        return (long)(frameNeeded * (double)this.frameSize);
    }

    @Override
    public void seek(double seconds) throws IOException {
        if (seconds == 0.0) {
            return;
        }
        this.secsSeeked += seconds;
        long bytesToSeek = this.getBytesToSeek(seconds);
        long skip = -2L;
        try {
            skip = this.trackStream.skip(bytesToSeek);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            Logger.getLogger(this, e.getClass().getSimpleName(), (Object)e.getMessage()).error();
            System.out.println("Skipped: " + skip + "/BytesToSkip: " + bytesToSeek);
        }
    }
}

