/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jaad.aac;

public enum ChannelConfiguration {
    CHANNEL_CONFIG_UNSUPPORTED(-1, "invalid"),
    CHANNEL_CONFIG_NONE(0, "No channel"),
    CHANNEL_CONFIG_MONO(1, "Mono"),
    CHANNEL_CONFIG_STEREO(2, "Stereo"),
    CHANNEL_CONFIG_STEREO_PLUS_CENTER(3, "Stereo+Center"),
    CHANNEL_CONFIG_STEREO_PLUS_CENTER_PLUS_REAR_MONO(4, "Stereo+Center+Rear"),
    CHANNEL_CONFIG_FIVE(5, "Five channels"),
    CHANNEL_CONFIG_FIVE_PLUS_ONE(6, "Five channels+LF"),
    CHANNEL_CONFIG_SEVEN_PLUS_ONE(8, "Seven channels+LF");

    private final int chCount;
    private final String descr;

    public static ChannelConfiguration forInt(int i) {
        ChannelConfiguration c;
        switch (i) {
            case 0: {
                c = CHANNEL_CONFIG_NONE;
                break;
            }
            case 1: {
                c = CHANNEL_CONFIG_MONO;
                break;
            }
            case 2: {
                c = CHANNEL_CONFIG_STEREO;
                break;
            }
            case 3: {
                c = CHANNEL_CONFIG_STEREO_PLUS_CENTER;
                break;
            }
            case 4: {
                c = CHANNEL_CONFIG_STEREO_PLUS_CENTER_PLUS_REAR_MONO;
                break;
            }
            case 5: {
                c = CHANNEL_CONFIG_FIVE;
                break;
            }
            case 6: {
                c = CHANNEL_CONFIG_FIVE_PLUS_ONE;
                break;
            }
            case 7: 
            case 8: {
                c = CHANNEL_CONFIG_SEVEN_PLUS_ONE;
                break;
            }
            default: {
                c = CHANNEL_CONFIG_UNSUPPORTED;
            }
        }
        return c;
    }

    private ChannelConfiguration(int chCount, String descr) {
        this.chCount = chCount;
        this.descr = descr;
    }

    public int getChannelCount() {
        return this.chCount;
    }

    public String getDescription() {
        return this.descr;
    }

    public String toString() {
        return this.descr;
    }
}

