/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.tag.asf;

import org.jaudiotagger.audio.asf.data.AsfHeader;
import org.jaudiotagger.audio.asf.data.MetadataDescriptor;
import org.jaudiotagger.audio.asf.util.Utils;
import org.jaudiotagger.tag.TagTextField;
import org.jaudiotagger.tag.asf.AsfFieldKey;
import org.jaudiotagger.tag.asf.AsfTagField;

public class AsfTagTextField
extends AsfTagField
implements TagTextField {
    public AsfTagTextField(AsfFieldKey field, String value) {
        super(field);
        this.toWrap.setString(value);
    }

    public AsfTagTextField(MetadataDescriptor source) {
        super(source);
        if (source.getType() == 1) {
            throw new IllegalArgumentException("Cannot interpret binary as string.");
        }
    }

    public AsfTagTextField(String fieldKey, String value) {
        super(fieldKey);
        this.toWrap.setString(value);
    }

    public String getContent() {
        return this.getDescriptor().getString();
    }

    public String getEncoding() {
        return AsfHeader.ASF_CHARSET.name();
    }

    public boolean isEmpty() {
        return Utils.isBlank(this.getContent());
    }

    public void setContent(String content) {
        this.getDescriptor().setString(content);
    }

    public void setEncoding(String encoding) {
        if (!AsfHeader.ASF_CHARSET.name().equals(encoding)) {
            throw new IllegalArgumentException("Only UTF-16LE is possible with ASF.");
        }
    }
}

