/*
 * Decompiled with CFR 0.152.
 */
package sun.rmi.rmic.newrmic.jrmp;

import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.MethodDoc;
import com.sun.javadoc.Parameter;
import com.sun.javadoc.Type;

final class Util {
    private Util() {
        throw new AssertionError();
    }

    static String binaryNameOf(ClassDoc classDoc) {
        String string = classDoc.name().replace('.', '$');
        String string2 = classDoc.containingPackage().name();
        return string2.equals("") ? string : string2 + "." + string;
    }

    static String methodDescriptorOf(MethodDoc methodDoc) {
        String string = "(";
        Parameter[] parameterArray = methodDoc.parameters();
        for (int i = 0; i < parameterArray.length; ++i) {
            string = string + Util.typeDescriptorOf(parameterArray[i].type());
        }
        string = string + ")" + Util.typeDescriptorOf(methodDoc.returnType());
        return string;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static String typeDescriptorOf(Type type) {
        String string;
        ClassDoc classDoc = type.asClassDoc();
        if (classDoc == null) {
            String string2 = type.typeName();
            if (string2.equals("boolean")) {
                string = "Z";
            } else if (string2.equals("byte")) {
                string = "B";
            } else if (string2.equals("char")) {
                string = "C";
            } else if (string2.equals("short")) {
                string = "S";
            } else if (string2.equals("int")) {
                string = "I";
            } else if (string2.equals("long")) {
                string = "J";
            } else if (string2.equals("float")) {
                string = "F";
            } else if (string2.equals("double")) {
                string = "D";
            } else {
                if (!string2.equals("void")) throw new AssertionError((Object)("unrecognized primitive type: " + string2));
                string = "V";
            }
        } else {
            string = "L" + Util.binaryNameOf(classDoc).replace('.', '/') + ";";
        }
        int n = type.dimension().length() / 2;
        for (int i = 0; i < n; ++i) {
            string = "[" + string;
        }
        return string;
    }

    static String getFriendlyUnqualifiedSignature(MethodDoc methodDoc) {
        String string = methodDoc.name() + "(";
        Parameter[] parameterArray = methodDoc.parameters();
        for (int i = 0; i < parameterArray.length; ++i) {
            if (i > 0) {
                string = string + ", ";
            }
            Type type = parameterArray[i].type();
            string = string + type.typeName() + type.dimension();
        }
        string = string + ")";
        return string;
    }

    static boolean isVoid(Type type) {
        return type.asClassDoc() == null && type.typeName().equals("void");
    }
}

