/*
 * Decompiled with CFR 0.152.
 */
package org.muplayer.main;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.StandardOpenOption;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import java.util.Scanner;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.UnsupportedAudioFileException;
import org.muplayer.audio.Player;
import org.muplayer.audio.Track;
import org.muplayer.audio.model.SeekOption;
import org.muplayer.main.CommandInterpreter;
import org.muplayer.main.ConsoleOrder;
import org.muplayer.system.SysInfo;
import org.orangelogger.sys.Logger;
import org.orangelogger.sys.SystemUtil;

public class ConsolePlayer
extends Thread {
    protected volatile Player player;
    protected volatile CommandInterpreter interpreter;
    protected volatile File playerFolder;
    protected volatile Scanner scanner;
    protected boolean on;
    protected static final String LINEHEADER = "[MuPlayer]> ";

    public ConsolePlayer(File rootFolder) throws FileNotFoundException {
        this.player = new Player(rootFolder);
        this.initInterpreter();
        this.playerFolder = rootFolder;
        this.scanner = new Scanner(System.in);
        this.on = false;
        this.setName("ConsolePlayer");
    }

    public ConsolePlayer(String folder) throws FileNotFoundException {
        this(new File(folder));
    }

    private void execSysCommand(String cmd) {
        Process process = null;
        try {
            process = Runtime.getRuntime().exec(cmd);
            process.waitFor();
            if (process.exitValue() == 0) {
                this.printStreamOut(process.getInputStream());
            } else {
                this.printStreamOut(process.getErrorStream());
            }
        }
        catch (IOException | InterruptedException e) {
            Logger.getLogger(this, (Object)e.getMessage()).error();
        }
    }

    protected void initInterpreter() {
        this.interpreter = cmd -> {
            String cmdOrder;
            switch (cmdOrder = cmd.getOrder()) {
                case "st": {
                    if (this.player == null) {
                        this.player = new Player(this.playerFolder);
                    }
                    if (this.player.isAlive() && cmd.hasOptions()) {
                        File musicFolder = new File(cmd.getOptionAt(0));
                        if (musicFolder.exists()) {
                            Player newPlayer = new Player(musicFolder);
                            this.player.shutdown();
                            newPlayer.start();
                            this.player = newPlayer;
                            break;
                        }
                        Logger.getLogger(this, (Object)"Folder not exists").rawError();
                        break;
                    }
                    if (this.player.isAlive()) break;
                    this.player.start();
                    break;
                }
                case "ist": {
                    if (this.player == null) break;
                    Logger.getLogger(this, (Object)(this.player.isPlaying() ? "Is playing" : "Is not playing")).rawWarning();
                    break;
                }
                case "pl": {
                    if (this.player == null) break;
                    if (cmd.hasOptions()) {
                        Number playIndex = cmd.getOptionAsNumber(0);
                        if (playIndex == null || playIndex.intValue() <= 0 || playIndex.intValue() > this.player.getSongsCount()) break;
                        this.player.play(playIndex.intValue() - 1);
                        break;
                    }
                    this.player.play();
                    break;
                }
                case "ps": {
                    if (this.player == null) break;
                    this.player.pause();
                    break;
                }
                case "s": {
                    if (this.player == null) break;
                    this.player.stopTrack();
                    break;
                }
                case "r": {
                    if (this.player == null) break;
                    this.player.resumeTrack();
                    break;
                }
                case "n": {
                    if (this.player == null) break;
                    if (cmd.hasOptions()) {
                        Number jumps = cmd.getOptionAsNumber(0);
                        if (jumps == null) {
                            Logger.getLogger(this, (Object)"Jump value incorrect").rawError();
                            break;
                        }
                        this.player.jumpTrack(jumps.intValue(), SeekOption.NEXT);
                        break;
                    }
                    this.player.playNext();
                    break;
                }
                case "p": {
                    if (this.player == null) break;
                    if (cmd.hasOptions()) {
                        Number jumps = cmd.getOptionAsNumber(0);
                        if (jumps == null) {
                            Logger.getLogger(this, (Object)"Jump value incorrect").rawError();
                            break;
                        }
                        this.player.jumpTrack(jumps.intValue(), SeekOption.PREV);
                        break;
                    }
                    this.player.playPrevious();
                    break;
                }
                case "m": {
                    if (this.player == null) break;
                    this.player.mute();
                    break;
                }
                case "um": {
                    if (this.player == null) break;
                    this.player.unmute();
                    break;
                }
                case "l": {
                    if (this.player == null) break;
                    this.player.printTracks();
                    break;
                }
                case "list": {
                    if (this.player == null) break;
                    this.player.printTracks();
                    break;
                }
                case "lc": {
                    if (this.player == null) break;
                    this.player.printFolderTracks();
                    break;
                }
                case "lf": {
                    if (this.player == null) break;
                    this.player.printFolders();
                    break;
                }
                case "gv": {
                    if (this.player == null) break;
                    Logger.getLogger(this, (Object)("Player Volume(0-100): " + this.player.getGain())).rawWarning();
                    break;
                }
                case "v": {
                    if (this.player == null || !cmd.hasOptions()) break;
                    Number volume = cmd.getOptionAsNumber(0);
                    if (volume == null) {
                        Logger.getLogger(this, (Object)"Volume value incorrect").rawError();
                        break;
                    }
                    this.player.setGain(volume.floatValue());
                    Logger.getLogger(this, (Object)"Volume value changed").rawWarning();
                    break;
                }
                case "gsv": {
                    if (this.player == null) break;
                    Logger.getLogger(this, (Object)("Player Volume(0-100): " + this.player.getSystemVolume())).rawWarning();
                    break;
                }
                case "sv": {
                    if (this.player == null || !cmd.hasOptions()) break;
                    Number volume = cmd.getOptionAsNumber(0);
                    if (volume == null) {
                        Logger.getLogger(this, (Object)"Volume value incorrect").rawError();
                        break;
                    }
                    this.player.setSystemVolume(volume.floatValue());
                    Logger.getLogger(this, (Object)"Volume value changed").rawWarning();
                    break;
                }
                case "sh": {
                    if (this.player == null) break;
                    this.player.shutdown();
                    this.player = null;
                    break;
                }
                case "exit": {
                    if (this.player != null) {
                        this.player.shutdown();
                        this.player = null;
                    }
                    this.on = false;
                    break;
                }
                case "quit": {
                    if (this.player != null) {
                        this.player.shutdown();
                        this.player = null;
                    }
                    this.on = false;
                    break;
                }
                case "k": {
                    if (this.player == null || !cmd.hasOptions()) break;
                    Number seekSec = cmd.getOptionAsNumber(0);
                    if (seekSec == null) {
                        Logger.getLogger(this, (Object)"Seek value incorrect").rawError();
                        break;
                    }
                    this.player.seek(seekSec.doubleValue());
                    Logger.getLogger(this, (Object)"Seeked").rawWarning();
                    break;
                }
                case "skf": {
                    if (this.player == null) break;
                    if (cmd.hasOptions()) {
                        String optionParam = cmd.getOptionAt(0);
                        SeekOption option = optionParam.equals("next") ? SeekOption.NEXT : (optionParam.equals("prev") ? SeekOption.PREV : null);
                        Number jumps = cmd.getOptionAsNumber(1);
                        if (cmd.getOptionsCount() > 1 && jumps == null) {
                            Logger.getLogger(this, (Object)"Seek value incorrect").rawError();
                            break;
                        }
                        if (jumps == null && option == null) {
                            Logger.getLogger(this, (Object)"Option value incorrect").rawError();
                            break;
                        }
                        if (jumps == null) {
                            this.player.seekFolder(option);
                            break;
                        }
                        if (jumps.intValue() < 0) {
                            Logger.getLogger(this, (Object)"Jumps value incorrect").rawError();
                            break;
                        }
                        this.player.seekFolder(option, jumps.intValue());
                        Logger.getLogger(this, (Object)"Seeked").rawWarning();
                        break;
                    }
                    this.player.seekFolder(SeekOption.NEXT);
                    break;
                }
                case "u": {
                    if (this.player == null) break;
                    this.player.reloadTracks();
                    break;
                }
                case "g": {
                    if (this.player == null || !cmd.hasOptions()) break;
                    Number gotoSec = cmd.getOptionAsNumber(0);
                    if (gotoSec == null) {
                        Logger.getLogger(this, (Object)"Go to value incorrect").rawError();
                        break;
                    }
                    this.player.gotoSecond(gotoSec.doubleValue());
                    break;
                }
                case "c": {
                    System.out.println("in soundcount option");
                    int count = this.player.getSongsCount();
                    System.out.println("SoundCount: " + count);
                    if (this.player == null) break;
                    Logger.getLogger(this, (Object)count).info();
                    break;
                }
                case "d": {
                    if (this.player == null) break;
                    Logger.getLogger(this, (Object)this.player.getCurrent().getFormattedDuration()).info();
                    break;
                }
                case "cover": {
                    Track current = this.player.getCurrent();
                    if (current == null) {
                        Logger.getLogger(this, (Object)"Current track unavailable").rawError();
                        break;
                    }
                    if (!current.hasCover()) {
                        Logger.getLogger(this, (Object)"Current song don't have cover").rawError();
                        break;
                    }
                    if (cmd.hasOptions()) {
                        File folderPath = new File(cmd.getOptionAt(0));
                        if (!folderPath.exists()) {
                            folderPath = this.player.getRootFolder();
                        }
                        File fileCover = new File(folderPath, "cover-" + current.getTitle() + ".png");
                        fileCover.createNewFile();
                        Files.write(fileCover.toPath(), current.getCoverData(), StandardOpenOption.WRITE);
                        Logger.getLogger(this, (Object)("Created cover with name " + fileCover.getName())).rawWarning();
                        break;
                    }
                    Logger.getLogger(this, (Object)"Cover path not defined").rawError();
                    break;
                }
                case "info": {
                    Track current = this.player.getCurrent();
                    if (current == null) {
                        Logger.getLogger(this, (Object)"Current track unavailable").rawError();
                        break;
                    }
                    Logger.getLogger(this, (Object)current.getSongInfo()).rawWarning();
                    break;
                }
                case "prog": {
                    Track current = this.player.getCurrent();
                    if (current == null) {
                        Logger.getLogger(this, (Object)"Current track unavailable").rawError();
                        break;
                    }
                    if (cmd.hasOptions()) {
                        if (!cmd.getOptionAt(0).equals("h")) break;
                        Logger.getLogger(this, (Object)current.getFormattedProgress()).rawWarning();
                        break;
                    }
                    Logger.getLogger(this, (Object)current.getProgress()).rawWarning();
                    break;
                }
                case "clear": {
                    this.clearConsole();
                    break;
                }
                case "cls": {
                    this.clearConsole();
                    break;
                }
                case "format": {
                    Track current = this.player.getCurrent();
                    if (current == null) {
                        Logger.getLogger(this, (Object)"Current track unavailable").rawError();
                        break;
                    }
                    String className = current.getClass().getSimpleName();
                    Logger.getLogger(this, (Object)className.substring(0, className.length() - 5).toLowerCase()).rawWarning();
                    break;
                }
                case "title": {
                    Track current = this.player.getCurrent();
                    if (current == null) {
                        Logger.getLogger(this, (Object)"Current track unavailable").rawError();
                        break;
                    }
                    Logger.getLogger(this, (Object)current.getTitle()).rawWarning();
                    break;
                }
                case "name": {
                    Track current = this.player.getCurrent();
                    if (current == null) {
                        Logger.getLogger(this, (Object)"Current track unavailable").rawError();
                        break;
                    }
                    Logger.getLogger(this, (Object)current.getDataSource().getName()).rawWarning();
                    break;
                }
                case "h": {
                    this.printHelp();
                    break;
                }
                case "help": {
                    this.printHelp();
                    break;
                }
                case "system": {
                    if (!cmd.hasOptions()) break;
                    this.execSysCommand(cmd.getOptionAt(0));
                    break;
                }
                case "sys": {
                    if (!cmd.hasOptions()) break;
                    this.execSysCommand(cmd.getOptionAt(0));
                    break;
                }
                default: {
                    Logger.getLogger(this, (Object)"Comando desconocido, inserte el comando \"h\" o \"help\"\npara desplegar el men\u00fa de ayuda.").rawWarning();
                }
            }
        };
    }

    protected void printStreamOut(InputStream cmdStream) throws IOException {
        int read;
        FileOutputStream stdout = SystemUtil.getStdout();
        while ((read = cmdStream.read()) != -1) {
            stdout.write(read);
        }
    }

    protected void clearConsole() throws IOException {
        Process process = SysInfo.ISUNIX ? Runtime.getRuntime().exec("clear") : Runtime.getRuntime().exec("cls");
        try {
            process.waitFor();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        if (process.exitValue() == 0) {
            this.printStreamOut(process.getInputStream());
        } else {
            this.printStreamOut(process.getErrorStream());
        }
    }

    protected void printHelp() {
        Map<String, String> helpMap = ConsoleOrder.HELP_MAP;
        Iterator<Map.Entry<String, String>> it = helpMap.entrySet().iterator();
        StringBuilder sbHelp = new StringBuilder();
        int count = 1;
        while (it.hasNext()) {
            Map.Entry<String, String> entry = it.next();
            sbHelp.append(count).append(") ").append(entry.getKey()).append(": ").append(entry.getValue()).append('\n');
            ++count;
        }
        Logger.getLogger(this, (Object)"---------").rawWarning();
        Logger.getLogger(this, (Object)"Help Info").rawWarning();
        Logger.getLogger(this, (Object)"---------").rawWarning();
        Logger.getLogger(this, (Object)sbHelp.toString()).rawWarning();
    }

    protected void printHeader() {
        FileOutputStream stdout = SystemUtil.getStdout();
        try {
            stdout.write(Logger.getLogger(this, (Object)LINEHEADER).getColoredMsg("\u001b[32m").getBytes());
            stdout.flush();
        }
        catch (IOException e) {
            Logger.getLogger(this, e.getClass().getSimpleName(), (Object)e.getMessage()).error();
        }
    }

    public void execCommand(String strCmd) {
        try {
            this.interpreter.interprate(strCmd);
        }
        catch (IOException | LineUnavailableException | UnsupportedAudioFileException e) {
            Logger.getLogger(this, e.getClass().getSimpleName(), (Object)e.getMessage()).error();
        }
    }

    @Override
    public void run() {
        Logger.getLogger(this, (Object)"MuPlayer started...").rawInfo();
        this.on = true;
        String CMD_DIVISOR = " && ";
        while (this.on) {
            this.printHeader();
            String cmd = this.scanner.nextLine().trim();
            if (cmd.contains(" && ")) {
                Arrays.stream(cmd.split(" && ")).forEach(this::execCommand);
                continue;
            }
            this.execCommand(cmd);
        }
    }

    public static void main(String[] args) {
        try {
            if (args.length == 0) {
                new ConsolePlayer("/home/martin/Escritorio/M\u00fasica").start();
            } else {
                new ConsolePlayer(args[0]).start();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

