/*
 * Decompiled with CFR 0.152.
 */
package org.muplayer.audio.formats.io;

import java.io.File;
import java.io.IOException;
import net.sourceforge.jaad.aac.AACException;
import net.sourceforge.jaad.aac.Decoder;
import net.sourceforge.jaad.aac.SampleBuffer;
import net.sourceforge.jaad.mp4.api.AudioTrack;
import net.sourceforge.jaad.mp4.api.Frame;
import org.muplayer.audio.formats.io.AudioDataOutputStream;

public class TM4AReader
extends Thread {
    private File inputFile;
    private AudioDataOutputStream outputStream;
    private AudioTrack audioTrack;
    private Decoder dec;
    private SampleBuffer buff;
    private Frame frame;

    public TM4AReader(File inputFile, AudioDataOutputStream outputStream, AudioTrack audioTrack) throws AACException {
        this.inputFile = inputFile;
        this.outputStream = outputStream;
        this.audioTrack = audioTrack;
        this.dec = new Decoder(audioTrack.getDecoderSpecificInfo());
        this.buff = new SampleBuffer();
        this.setName("TM4AReader: " + inputFile.getName());
        this.setPriority(10);
    }

    private byte[] getNextDecodedFrame() throws IOException {
        this.frame = this.audioTrack.readNextFrame();
        this.dec.decodeFrame(this.frame.getData(), this.buff);
        return this.buff.getData();
    }

    @Override
    public void run() {
        while (this.audioTrack.hasMoreFrames()) {
            try {
                this.outputStream.write(this.getNextDecodedFrame());
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        System.out.println(this.getName() + " finished!");
    }
}

