/*
 * Decompiled with CFR 0.152.
 */
package org.muplayer.audio;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.SourceDataLine;
import javax.sound.sampled.UnsupportedAudioFileException;
import org.aucom.sound.Speaker;
import org.muplayer.audio.Track;
import org.muplayer.audio.info.AudioTag;
import org.muplayer.audio.info.SongData;
import org.muplayer.audio.interfaces.PlayerControls;
import org.muplayer.audio.interfaces.PlayerListener;
import org.muplayer.audio.model.SeekOption;
import org.muplayer.audio.model.TrackInfo;
import org.muplayer.audio.util.PlayerInfo;
import org.muplayer.system.AudioUtil;
import org.muplayer.system.LineUtil;
import org.muplayer.thread.PlayerHandler;
import org.muplayer.thread.ThreadManager;

public class Player
extends Thread
implements PlayerControls {
    private volatile File rootFolder;
    private volatile Track current;
    private volatile ArrayList<String> listSoundPaths;
    private volatile ArrayList<String> listFolderPaths;
    private volatile ArrayList<PlayerListener> listListeners;
    private volatile int trackIndex;
    private volatile float currentVolume;
    private volatile boolean on;
    public static final float DEFAULT_VOLUME = AudioUtil.convertLineRangeToVolRange(40.4275f);

    public Player() {
        try {
            this.instancePlayer(null);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
    }

    public Player(File rootFolder) throws FileNotFoundException {
        this.instancePlayer(rootFolder);
    }

    private void instancePlayer(File rootFolder) throws FileNotFoundException {
        this.rootFolder = rootFolder;
        this.listSoundPaths = new ArrayList();
        this.listFolderPaths = new ArrayList();
        this.listListeners = new ArrayList();
        this.currentVolume = DEFAULT_VOLUME;
        this.on = false;
        if (rootFolder != null) {
            if (!rootFolder.exists()) {
                throw new FileNotFoundException();
            }
            this.loadTracks(rootFolder);
            this.sortTracks();
            this.setName("ThreadPlayer " + this.getId());
        }
        this.trackIndex = -1;
        this.disableLogging();
    }

    public Player(String folderPath) throws FileNotFoundException {
        this(new File(folderPath));
    }

    private void disableLogging() {
        Logger.getLogger("org.jaudiotagger").setLevel(Level.OFF);
    }

    private void loadTracks(File folder) {
        File[] fldFiles = folder.listFiles();
        if (fldFiles != null) {
            boolean hasTracks = false;
            for (int i = 0; i < fldFiles.length; ++i) {
                File f = fldFiles[i];
                if (f.isDirectory()) {
                    this.loadTracks(f);
                    continue;
                }
                if (!Track.isValidTrack(f.getPath())) continue;
                System.out.println("Track Valid: " + f.getName());
                this.listSoundPaths.add(f.getPath());
                hasTracks = true;
            }
            if (hasTracks) {
                try {
                    this.listFolderPaths.add(folder.getCanonicalPath());
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        System.out.println("Carpetas analizadas");
        System.out.println("FoldersCount: " + this.listFolderPaths.size());
        System.out.println("SoundCount: " + this.getSongsCount());
    }

    private void loadTracks(List<File> listFiles) {
        listFiles.stream().forEach(f -> {
            if (f.isDirectory()) {
                this.loadTracks((File)f);
            } else {
                this.listSoundPaths.add(f.getPath());
            }
        });
    }

    private void sortTracks() {
        this.listSoundPaths.sort(Comparator.naturalOrder());
        this.listFolderPaths.sort(Comparator.naturalOrder());
    }

    private int getFolderIndex() {
        String currentParent;
        String string = currentParent = this.current != null ? this.current.getDataSource().getParent() : null;
        if (currentParent != null) {
            for (int i = 0; i < this.listFolderPaths.size(); ++i) {
                if (!this.listFolderPaths.get(i).equals(currentParent)) continue;
                return i;
            }
        }
        return -1;
    }

    private Track getTrackBy(int currentIndex, SeekOption param) {
        Track next = null;
        if (param == SeekOption.NEXT) {
            currentIndex = currentIndex == this.getSongsCount() - 1 || currentIndex < 0 ? 0 : ++currentIndex;
            for (int i = currentIndex; i < this.listSoundPaths.size(); ++i) {
                next = Track.getTrack(this.listSoundPaths.get(i));
                if (next == null || !next.isValidTrack()) continue;
                this.trackIndex = i;
                break;
            }
            if (next != null) {
                next.setGain(this.currentVolume);
            }
            return next;
        }
        currentIndex = currentIndex == 0 ? this.getSongsCount() - 1 : --currentIndex;
        for (int i = currentIndex; i >= 0; --i) {
            next = Track.getTrack(this.listSoundPaths.get(i));
            if (next == null) continue;
            this.trackIndex = i;
            break;
        }
        if (next != null) {
            next.setGain(this.currentVolume);
        }
        return next;
    }

    private void getNextTrack(SeekOption param) {
        this.current = this.getTrackBy(this.trackIndex, param);
    }

    private String getThreadName() {
        String trackName = this.current.getDataSource().getName();
        int strLimit = trackName.length() < 10 ? trackName.length() : 10;
        return new StringBuilder().append("ThreadTrack: ").append(trackName, 0, strLimit).toString();
    }

    private void startThreadTrack() {
        this.current.setName(this.getThreadName());
        this.current.setGain(this.currentVolume);
        this.current.start();
    }

    private void loadListenerMethod(String methodName, Track track) {
        if (this.listListeners.isEmpty()) {
            return;
        }
        int listenerSize = this.listListeners.size();
        switch (methodName) {
            case "onSongChange": {
                for (int i = 0; i < listenerSize; ++i) {
                    this.listListeners.get(i).onSongChange(track);
                }
                break;
            }
            case "onPlayed": {
                for (int i = 0; i < listenerSize; ++i) {
                    this.listListeners.get(i).onPlayed(track);
                }
                break;
            }
            case "onResumed": {
                for (int i = 0; i < listenerSize; ++i) {
                    this.listListeners.get(i).onResumed(track);
                }
                break;
            }
            case "onPaused": {
                for (int i = 0; i < listenerSize; ++i) {
                    this.listListeners.get(i).onPaused(track);
                }
                break;
            }
            case "onStarted": {
                for (int i = 0; i < listenerSize; ++i) {
                    this.listListeners.get(i).onStarted();
                }
                break;
            }
            case "onStopped": {
                for (int i = 0; i < listenerSize; ++i) {
                    this.listListeners.get(i).onStopped(track);
                }
                break;
            }
            case "onSeeked": {
                for (int i = 0; i < listenerSize; ++i) {
                    this.listListeners.get(i).onSeeked(track);
                }
                break;
            }
            case "onShutdown": {
                for (int i = 0; i < listenerSize; ++i) {
                    this.listListeners.get(i).onShutdown();
                }
                break;
            }
        }
    }

    private synchronized void freezePlayer() {
        ThreadManager.freezeThread(this);
    }

    private void shutdownCurrent() {
        if (this.current != null) {
            this.current.kill();
        }
    }

    private void waitForSongs() {
        while (this.on && this.getSongsCount() == 0) {
        }
    }

    private Track findFirstIn(String folderPath) {
        File parentFile = new File(folderPath);
        ArrayList<File> listSounds = this.getListSounds();
        File fileTrack = null;
        for (int i = 0; i < listSounds.size() && !(fileTrack = listSounds.get(i)).getParentFile().equals(parentFile); ++i) {
        }
        if (fileTrack == null) {
            return null;
        }
        return fileTrack == null ? null : (Track.isValidTrack(fileTrack) ? Track.getTrack(fileTrack) : null);
    }

    private void startPlaying() {
        this.waitForSongs();
        this.playNext();
    }

    private void waitForFinish() {
        if (this.current != null) {
            while (this.current.isAlive()) {
            }
        }
    }

    private void playFolderSongs(String fldPath) {
        for (int i = 0; i < this.listSoundPaths.size(); ++i) {
            if (!new File(this.listSoundPaths.get(i)).getParent().equals(fldPath)) continue;
            this.play(i);
            break;
        }
    }

    public synchronized boolean hasSounds() {
        return !this.listSoundPaths.isEmpty();
    }

    public boolean existsFolder(String folderPath) {
        return this.listFolderPaths.parallelStream().anyMatch(fp -> fp.equals(folderPath));
    }

    public boolean existsFolder(File folder) {
        return this.existsFolder(folder.getPath());
    }

    public boolean existsParent(String childPath) {
        return this.existsParent(new File(childPath));
    }

    public boolean existsParent(File child) {
        return this.existsFolder(child.getParent());
    }

    public byte getCurrentTrackState() {
        return this.current == null ? (byte)7 : this.current.getTrackState();
    }

    public String getCurrentTrackStateToString() {
        return this.current == null ? "Unknown" : this.current.getStateToString();
    }

    public int getFoldersCount() {
        return this.listFolderPaths.size();
    }

    public File getRootFolder() {
        return this.rootFolder;
    }

    public ArrayList<String> getListFolderPaths() {
        return this.listFolderPaths;
    }

    public synchronized ArrayList<PlayerListener> getListListeners() {
        return this.listListeners;
    }

    public synchronized void analyzeFiles() {
        AbstractList listAnalyzed = this.listSoundPaths.getClass().isInstance(LinkedList.class) ? new LinkedList() : new ArrayList();
        this.listSoundPaths.stream().forEach(fsound -> {
            if (Track.isValidTrack(fsound)) {
                listAnalyzed.add(fsound);
            }
        });
        this.listSoundPaths.clear();
        this.listSoundPaths.addAll(listAnalyzed);
        this.listSoundPaths.sort(Comparator.naturalOrder());
        int folderSize = this.listFolderPaths.size();
        for (int i = 0; i < folderSize; ++i) {
            int finalI = i;
            if (this.listSoundPaths.parallelStream().anyMatch(sp -> new File((String)sp).getParent().equals(this.listFolderPaths.get(finalI)))) continue;
            this.listFolderPaths.remove(i);
            --folderSize;
        }
    }

    public synchronized void jumpTrack(int jumps, SeekOption option) {
        if (option == SeekOption.NEXT) {
            this.trackIndex += jumps;
            if (this.trackIndex >= this.listSoundPaths.size()) {
                this.trackIndex = 0;
            }
        } else {
            this.trackIndex -= jumps;
            if (this.trackIndex < 0) {
                this.trackIndex = this.listSoundPaths.size() - 1;
            }
        }
        this.play(this.trackIndex);
    }

    public synchronized ArrayList<String> getListSoundPaths() {
        return this.listSoundPaths;
    }

    public synchronized ArrayList<File> getListSounds() {
        ArrayList listFiles = this.listSoundPaths.stream().map(File::new).collect(Collectors.toCollection(ArrayList::new));
        return listFiles;
    }

    public synchronized ArrayList<AudioTag> getTrackTags() {
        ArrayList<AudioTag> listTags = new ArrayList<AudioTag>();
        ArrayList<TrackInfo> listInfos = this.getTracksInfo();
        for (int i = 0; i < listInfos.size(); ++i) {
            try {
                AudioTag tag = new AudioTag(this.listSoundPaths.get(i));
                if (!tag.isValidFile()) continue;
                listTags.add(tag);
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return listTags;
    }

    public synchronized ArrayList<TrackInfo> getTracksInfo() {
        ArrayList<TrackInfo> listInfo = new ArrayList<TrackInfo>();
        for (int i = 0; i < this.listSoundPaths.size(); ++i) {
            try {
                AudioTag tag = new AudioTag(this.listSoundPaths.get(i));
                if (!tag.isValidFile()) continue;
                listInfo.add(new SongData(tag));
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return listInfo;
    }

    public synchronized void addPlayerListener(PlayerListener listener) {
        this.listListeners.add(listener);
    }

    public synchronized ArrayList<PlayerListener> getListeners() {
        return this.listListeners;
    }

    public synchronized void removePlayerListener(PlayerListener reference) {
        for (int i = 0; i < this.listListeners.size(); ++i) {
            if (!this.listListeners.get(i).equals(reference)) continue;
            this.listListeners.remove(i);
        }
    }

    public synchronized void removeAllListeners() {
        this.listListeners.clear();
    }

    public void reloadTracks() {
        this.listSoundPaths.clear();
        if (this.rootFolder != null) {
            boolean foldersOut = this.listFolderPaths.parallelStream().anyMatch(path -> !new File((String)path).getParent().contains(this.rootFolder.getPath()));
            ArrayList<String> listCopyFolders = new ArrayList<String>(this.listFolderPaths);
            this.listFolderPaths.clear();
            this.loadTracks(this.rootFolder);
            if (foldersOut) {
                String rootPath = this.rootFolder.getPath();
                listCopyFolders.parallelStream().filter(fp -> !new File((String)fp).getParent().contains(rootPath)).forEach(path -> this.loadTracks(new File((String)path)));
            }
            this.loadTracks(this.rootFolder);
            this.sortTracks();
        }
    }

    public PlayerInfo getInfo() {
        return new PlayerInfo(this);
    }

    public synchronized Track getCurrent() {
        return this.current;
    }

    public synchronized Speaker getTrackSpeaker() {
        return this.current.getTrackLine();
    }

    public synchronized SourceDataLine getTrackLine() {
        return this.current == null ? null : (this.current.getTrackLine() == null ? null : this.current.getTrackLine().getDriver());
    }

    @Override
    public synchronized boolean isPlaying() {
        return this.current != null && this.current.isPlaying();
    }

    @Override
    public synchronized boolean isPaused() {
        return this.current != null && this.current.isPaused();
    }

    @Override
    public synchronized boolean isStopped() {
        return this.current != null && this.current.isStopped();
    }

    @Override
    public synchronized boolean isFinished() {
        return this.current != null && this.current.isFinished();
    }

    @Override
    public synchronized boolean isMute() {
        return this.current == null || this.current.isMute();
    }

    @Override
    public synchronized void open(File sound) {
        if (!Track.isValidTrack(sound)) {
            return;
        }
        this.listSoundPaths.clear();
        this.listFolderPaths.clear();
        this.listSoundPaths.add(sound.getPath());
        this.listFolderPaths.add(sound.getParent());
        if (this.isPlaying()) {
            this.current.finish();
        } else if (this.isAlive()) {
            this.current = Track.getTrack(sound);
            this.startThreadTrack();
        } else {
            this.start();
        }
    }

    @Override
    public synchronized void open(List<File> listSounds) {
        if (!listSounds.parallelStream().anyMatch(fileSound -> Track.isValidTrack(fileSound))) {
            return;
        }
        this.listSoundPaths.clear();
        this.listFolderPaths.clear();
        this.loadTracks(listSounds);
        this.sortTracks();
    }

    @Override
    public synchronized void addMusic(List<File> listSounds) {
        if (!listSounds.isEmpty()) {
            Consumer<File> consumer = sound -> {
                if (sound.isDirectory()) {
                    this.loadTracks((File)sound);
                } else if (Track.isValidTrack(sound)) {
                    this.listSoundPaths.add(sound.getPath());
                }
            };
            listSounds.stream().forEach(consumer);
        }
    }

    @Override
    public synchronized void addMusic(File musicFolder) {
        if (musicFolder.isDirectory()) {
            if (this.rootFolder == null) {
                this.rootFolder = musicFolder;
            }
            boolean validSort = !this.hasSounds();
            this.loadTracks(musicFolder);
            if (validSort) {
                this.sortTracks();
            }
        } else if (Track.isValidTrack(musicFolder)) {
            this.listSoundPaths.add(musicFolder.getPath());
            String parentPath = musicFolder.getParent();
            if (!this.listFolderPaths.parallelStream().anyMatch(sp -> parentPath.equals(sp))) {
                this.listFolderPaths.add(parentPath);
            }
        }
    }

    public synchronized void printTracks() {
        org.orangelogger.sys.Logger.getLogger(this, (Object)"------------------------------").rawInfo();
        if (this.rootFolder == null) {
            org.orangelogger.sys.Logger.getLogger(this, (Object)"Music in folder").rawInfo();
        } else {
            org.orangelogger.sys.Logger.getLogger(this, (Object)("Music in folder " + this.rootFolder.getName())).rawInfo();
        }
        org.orangelogger.sys.Logger.getLogger(this, (Object)"------------------------------").rawInfo();
        if (this.rootFolder != null) {
            for (int i = 0; i < this.getSongsCount(); ++i) {
                File fileTrack = new File(this.listSoundPaths.get(i));
                if (this.current != null && fileTrack.getPath().equals(this.current.getDataSource().getPath())) {
                    org.orangelogger.sys.Logger.getLogger(this, (Object)("Track " + (i + 1) + ": " + fileTrack.getName())).rawWarning();
                    continue;
                }
                org.orangelogger.sys.Logger.getLogger(this, (Object)("Track " + (i + 1) + ": " + fileTrack.getName())).rawInfo();
            }
            org.orangelogger.sys.Logger.getLogger(this, (Object)"------------------------------").rawInfo();
        }
    }

    public synchronized void printFolderTracks() {
        File parentFolder = this.current == null ? null : this.current.getDataSource().getParentFile();
        org.orangelogger.sys.Logger.getLogger(this, (Object)"------------------------------").rawInfo();
        if (parentFolder == null) {
            org.orangelogger.sys.Logger.getLogger(this, (Object)"Music in current folder").rawInfo();
        } else {
            org.orangelogger.sys.Logger.getLogger(this, (Object)("Music in folder " + parentFolder.getName())).rawInfo();
        }
        org.orangelogger.sys.Logger.getLogger(this, (Object)"------------------------------").rawInfo();
        if (parentFolder != null) {
            File currentFile = this.current.getDataSource();
            for (int i = 0; i < this.getSongsCount(); ++i) {
                File fileTrack = new File(this.listSoundPaths.get(i));
                if (!fileTrack.getParentFile().equals(parentFolder)) continue;
                if (fileTrack.getPath().equals(currentFile.getPath())) {
                    org.orangelogger.sys.Logger.getLogger(this, (Object)("Track " + (i + 1) + ": " + fileTrack.getName())).rawWarning();
                    continue;
                }
                org.orangelogger.sys.Logger.getLogger(this, (Object)("Track " + (i + 1) + ": " + fileTrack.getName())).rawInfo();
            }
            org.orangelogger.sys.Logger.getLogger(this, (Object)"------------------------------").rawInfo();
        }
    }

    public synchronized void printFolders() {
        org.orangelogger.sys.Logger.getLogger(this, (Object)"------------------------------").rawInfo();
        if (this.rootFolder == null) {
            org.orangelogger.sys.Logger.getLogger(this, (Object)"Folders").rawInfo();
        } else {
            org.orangelogger.sys.Logger.getLogger(this, (Object)("Folders in " + this.rootFolder.getName())).rawInfo();
        }
        org.orangelogger.sys.Logger.getLogger(this, (Object)"------------------------------").rawInfo();
        for (int i = 0; i < this.getFoldersCount(); ++i) {
            org.orangelogger.sys.Logger.getLogger(this, (Object)("Folder " + (i + 1) + ": " + new File(this.listFolderPaths.get(i)).getName())).rawInfo();
        }
        org.orangelogger.sys.Logger.getLogger(this, (Object)"------------------------------").rawInfo();
    }

    public synchronized int getSongsCount() {
        return this.listSoundPaths.size();
    }

    public synchronized void seekFolder(SeekOption param) {
        this.seekFolder(param, 1);
    }

    public synchronized void seekFolder(SeekOption option, int jumps) {
        int folderIndex = this.getFolderIndex();
        if (folderIndex != -1) {
            int newFolderIndex;
            String parentToFind = option == SeekOption.NEXT ? ((newFolderIndex = folderIndex + jumps) >= this.getFoldersCount() ? this.listFolderPaths.get(0) : this.listFolderPaths.get(newFolderIndex)) : ((newFolderIndex = folderIndex - jumps) < 0 ? this.listFolderPaths.get(this.listFolderPaths.size() - 1) : this.listFolderPaths.get(newFolderIndex));
            Track next = this.findFirstIn(parentToFind);
            if (next != null) {
                try {
                    this.trackIndex = this.listSoundPaths.indexOf(next.getDataSource().getCanonicalPath());
                    if (this.current != null) {
                        this.current.kill();
                    }
                    this.current = next;
                    this.startThreadTrack();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    @Override
    public synchronized void play() {
        if (!this.isAlive()) {
            this.start();
        } else if (this.current != null) {
            this.current.play();
            this.loadListenerMethod("onPlayed", this.current);
        }
    }

    public void play(int index) {
        if (index < 0 || index >= this.getSongsCount()) {
            return;
        }
        if (this.current != null) {
            this.current.kill();
            String soundPath = this.listSoundPaths.get(index);
            Track track = Track.getTrack(soundPath);
            if (track != null) {
                this.current = track;
                this.startThreadTrack();
                this.trackIndex = index;
            }
        }
    }

    @Override
    public synchronized void play(File track) {
        System.out.println("xd");
        int indexOf = this.listSoundPaths.indexOf(track.getPath());
        if (indexOf == -1) {
            if (Track.isValidTrack(track)) {
                this.listSoundPaths.add(track.getPath());
                if (!this.existsFolder(track.getParent())) {
                    this.listFolderPaths.add(track.getParent());
                }
            }
        } else {
            this.trackIndex = indexOf;
            if (this.current != null) {
                this.current.kill();
            }
            this.current = Track.getTrack(track);
            this.startThreadTrack();
        }
    }

    @Override
    public synchronized void play(String trackName) {
        int indexOf = -1;
        File song = null;
        for (int i = 0; i < this.listSoundPaths.size(); ++i) {
            song = new File(this.listSoundPaths.get(i));
            if (song.getName().equals(trackName)) {
                indexOf = i;
                break;
            }
            song = null;
        }
        if (indexOf != -1) {
            this.trackIndex = indexOf;
            if (this.current != null) {
                this.current.kill();
            }
            this.current = Track.getTrack(song);
            this.startThreadTrack();
        }
    }

    @Override
    public synchronized void pause() {
        if (this.current != null) {
            this.current.pause();
            this.loadListenerMethod("onPaused", this.current);
        }
    }

    @Override
    public synchronized void resumeTrack() {
        if (this.current != null) {
            this.current.resumeTrack();
            this.loadListenerMethod("onResumed", this.current);
        }
    }

    @Override
    public synchronized void stopTrack() throws UnsupportedAudioFileException, IOException, LineUnavailableException {
        if (this.current != null) {
            this.current.stopTrack();
            this.loadListenerMethod("onStopped", this.current);
        }
    }

    @Override
    public synchronized void finish() {
        this.shutdown();
    }

    @Override
    public synchronized void seek(double seconds) {
        if (this.current != null) {
            try {
                this.current.seek(seconds);
                this.loadListenerMethod("onSeeked", this.current);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public synchronized void gotoSecond(double second) {
        if (this.current != null) {
            try {
                this.current.gotoSecond(second);
            }
            catch (IOException | LineUnavailableException | UnsupportedAudioFileException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public synchronized float getGain() {
        return this.current == null ? this.currentVolume : this.current.getGain();
    }

    @Override
    public synchronized void setGain(float volume) {
        this.currentVolume = volume;
        if (this.current != null) {
            this.current.setGain(volume);
        }
    }

    @Override
    public float getSystemVolume() {
        return LineUtil.getFormattedMasterVolume();
    }

    @Override
    public void setSystemVolume(float volume) {
        LineUtil.setFormattedMasterVolume(volume);
    }

    @Override
    public synchronized void mute() {
        this.currentVolume = 0.0f;
        if (this.current != null) {
            this.current.mute();
        }
    }

    @Override
    public synchronized void unmute() {
        if (this.current != null) {
            this.current.unmute();
            this.currentVolume = this.current.getGain();
        } else {
            this.currentVolume = DEFAULT_VOLUME;
        }
    }

    @Override
    public double getProgress() {
        return this.current == null ? 0.0 : this.current.getProgress();
    }

    public String getFormattedProgress() {
        return this.current == null ? "00:00" : this.current.getFormattedProgress();
    }

    @Override
    public synchronized void playNext() {
        if (this.current != null) {
            this.current.kill();
        }
        this.getNextTrack(SeekOption.NEXT);
        this.waitForFinish();
        this.startThreadTrack();
        this.loadListenerMethod("onSongChange", this.current);
    }

    @Override
    public synchronized void playPrevious() {
        if (this.current != null) {
            this.current.kill();
        }
        this.getNextTrack(SeekOption.PREV);
        this.waitForFinish();
        this.startThreadTrack();
        this.loadListenerMethod("onSongChange", this.current);
    }

    public void playFolder(String path) {
        int fldIndex;
        if (this.current != null) {
            this.current.kill();
        }
        if ((fldIndex = this.listFolderPaths.indexOf(path)) != -1) {
            this.playFolderSongs(path);
        }
    }

    public void playFolder(int index) {
        if (index > -1 && index > this.listFolderPaths.size()) {
            this.playFolderSongs(this.listFolderPaths.get(index));
        }
    }

    @Override
    public synchronized void shutdown() {
        this.on = false;
        this.shutdownCurrent();
        this.interrupt();
        this.loadListenerMethod("onShutdown", null);
    }

    @Override
    public synchronized void run() {
        PlayerHandler.setInstance(this);
        this.loadListenerMethod("onStarted", null);
        this.on = true;
        this.startPlaying();
        this.freezePlayer();
    }
}

