/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jaad.mp4.od;

import java.io.IOException;
import net.sourceforge.jaad.mp4.MP4InputStream;
import net.sourceforge.jaad.mp4.od.Descriptor;

public class ESDescriptor
extends Descriptor {
    private int esID;
    private int streamPriority;
    private int dependingOnES_ID;
    private boolean streamDependency;
    private boolean urlPresent;
    private boolean ocrPresent;
    private String url;

    @Override
    void decode(MP4InputStream in) throws IOException {
        this.esID = (int)in.readBytes(2);
        int flags = in.read();
        this.streamDependency = (flags >> 7 & 1) == 1;
        this.urlPresent = (flags >> 6 & 1) == 1;
        this.streamPriority = flags & 0x1F;
        this.dependingOnES_ID = this.streamDependency ? (int)in.readBytes(2) : -1;
        if (this.urlPresent) {
            int len = in.read();
            this.url = in.readString(len);
        }
        this.readChildren(in);
    }

    public int getES_ID() {
        return this.esID;
    }

    public boolean hasStreamDependency() {
        return this.streamDependency;
    }

    public int getDependingOnES_ID() {
        return this.dependingOnES_ID;
    }

    public boolean isURLPresent() {
        return this.urlPresent;
    }

    public String getURL() {
        return this.url;
    }

    public int getStreamPriority() {
        return this.streamPriority;
    }
}

