/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.sound;

import com.sun.media.sound.AudioFloatConverter;
import com.sun.media.sound.AudioFloatInputStream;
import com.sun.media.sound.SoftAudioBuffer;
import com.sun.media.sound.SoftMixingDataLine;
import com.sun.media.sound.SoftMixingMixer;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.Clip;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.LineEvent;
import javax.sound.sampled.LineUnavailableException;

public final class SoftMixingClip
extends SoftMixingDataLine
implements Clip {
    private AudioFormat format;
    private int framesize;
    private byte[] data;
    private final InputStream datastream = new InputStream(){

        @Override
        public int read() throws IOException {
            byte[] b = new byte[1];
            int ret = this.read(b);
            if (ret < 0) {
                return ret;
            }
            return b[0] & 0xFF;
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            if (SoftMixingClip.this._loopcount != 0) {
                int bloopend = SoftMixingClip.this._loopend * SoftMixingClip.this.framesize;
                int bloopstart = SoftMixingClip.this._loopstart * SoftMixingClip.this.framesize;
                int pos = SoftMixingClip.this._frameposition * SoftMixingClip.this.framesize;
                if (pos + len >= bloopend && pos < bloopend) {
                    int left;
                    int offend = off + len;
                    int o = off;
                    while (off != offend) {
                        if (pos == bloopend) {
                            if (SoftMixingClip.this._loopcount == 0) break;
                            pos = bloopstart;
                            if (SoftMixingClip.this._loopcount != -1) {
                                SoftMixingClip.this._loopcount--;
                            }
                        }
                        if ((len = offend - off) > (left = bloopend - pos)) {
                            len = left;
                        }
                        System.arraycopy(SoftMixingClip.this.data, pos, b, off, len);
                        off += len;
                    }
                    if (SoftMixingClip.this._loopcount == 0) {
                        len = offend - off;
                        left = bloopend - pos;
                        if (len > left) {
                            len = left;
                        }
                        System.arraycopy(SoftMixingClip.this.data, pos, b, off, len);
                        off += len;
                    }
                    SoftMixingClip.this._frameposition = pos / SoftMixingClip.this.framesize;
                    return o - off;
                }
            }
            int pos = SoftMixingClip.this._frameposition * SoftMixingClip.this.framesize;
            int left = SoftMixingClip.this.bufferSize - pos;
            if (left == 0) {
                return -1;
            }
            if (len > left) {
                len = left;
            }
            System.arraycopy(SoftMixingClip.this.data, pos, b, off, len);
            SoftMixingClip.this._frameposition += len / SoftMixingClip.this.framesize;
            return len;
        }
    };
    private int offset;
    private int bufferSize;
    private float[] readbuffer;
    private boolean open = false;
    private AudioFormat outputformat;
    private int out_nrofchannels;
    private int in_nrofchannels;
    private int frameposition = 0;
    private boolean frameposition_sg = false;
    private boolean active_sg = false;
    private int loopstart = 0;
    private int loopend = -1;
    private boolean active = false;
    private int loopcount = 0;
    private boolean _active = false;
    private int _frameposition = 0;
    private boolean loop_sg = false;
    private int _loopcount = 0;
    private int _loopstart = 0;
    private int _loopend = -1;
    private float _rightgain;
    private float _leftgain;
    private float _eff1gain;
    private float _eff2gain;
    private AudioFloatInputStream afis;

    SoftMixingClip(SoftMixingMixer mixer, DataLine.Info info) {
        super(mixer, info);
    }

    @Override
    protected void processControlLogic() {
        this._rightgain = this.rightgain;
        this._leftgain = this.leftgain;
        this._eff1gain = this.eff1gain;
        this._eff2gain = this.eff2gain;
        if (this.active_sg) {
            this._active = this.active;
            this.active_sg = false;
        } else {
            this.active = this._active;
        }
        if (this.frameposition_sg) {
            this._frameposition = this.frameposition;
            this.frameposition_sg = false;
            this.afis = null;
        } else {
            this.frameposition = this._frameposition;
        }
        if (this.loop_sg) {
            this._loopcount = this.loopcount;
            this._loopstart = this.loopstart;
            this._loopend = this.loopend;
        }
        if (this.afis == null) {
            this.afis = AudioFloatInputStream.getInputStream(new AudioInputStream(this.datastream, this.format, -1L));
            if ((double)Math.abs(this.format.getSampleRate() - this.outputformat.getSampleRate()) > 1.0E-6) {
                this.afis = new SoftMixingDataLine.AudioFloatInputStreamResampler(this.afis, this.outputformat);
            }
        }
    }

    @Override
    protected void processAudioLogic(SoftAudioBuffer[] buffers) {
        if (this._active) {
            int ix;
            int i;
            float[] left = buffers[0].array();
            float[] right = buffers[1].array();
            int bufferlen = buffers[0].getSize();
            int readlen = bufferlen * this.in_nrofchannels;
            if (this.readbuffer == null || this.readbuffer.length < readlen) {
                this.readbuffer = new float[readlen];
            }
            int ret = 0;
            try {
                ret = this.afis.read(this.readbuffer);
                if (ret == -1) {
                    this._active = false;
                    return;
                }
                if (ret != this.in_nrofchannels) {
                    Arrays.fill(this.readbuffer, ret, readlen, 0.0f);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            int in_c = this.in_nrofchannels;
            int i2 = 0;
            int ix2 = 0;
            while (i2 < bufferlen) {
                int n = i2++;
                left[n] = left[n] + this.readbuffer[ix2] * this._leftgain;
                ix2 += in_c;
            }
            if (this.out_nrofchannels != 1) {
                if (this.in_nrofchannels == 1) {
                    i2 = 0;
                    ix2 = 0;
                    while (i2 < bufferlen) {
                        int n = i2++;
                        right[n] = right[n] + this.readbuffer[ix2] * this._rightgain;
                        ix2 += in_c;
                    }
                } else {
                    i2 = 0;
                    ix2 = 1;
                    while (i2 < bufferlen) {
                        int n = i2++;
                        right[n] = right[n] + this.readbuffer[ix2] * this._rightgain;
                        ix2 += in_c;
                    }
                }
            }
            if ((double)this._eff1gain > 2.0E-4) {
                float[] eff1 = buffers[2].array();
                i = 0;
                ix = 0;
                while (i < bufferlen) {
                    int n = i++;
                    eff1[n] = eff1[n] + this.readbuffer[ix] * this._eff1gain;
                    ix += in_c;
                }
                if (this.in_nrofchannels == 2) {
                    i = 0;
                    ix = 1;
                    while (i < bufferlen) {
                        int n = i++;
                        eff1[n] = eff1[n] + this.readbuffer[ix] * this._eff1gain;
                        ix += in_c;
                    }
                }
            }
            if ((double)this._eff2gain > 2.0E-4) {
                float[] eff2 = buffers[3].array();
                i = 0;
                ix = 0;
                while (i < bufferlen) {
                    int n = i++;
                    eff2[n] = eff2[n] + this.readbuffer[ix] * this._eff2gain;
                    ix += in_c;
                }
                if (this.in_nrofchannels == 2) {
                    i = 0;
                    ix = 1;
                    while (i < bufferlen) {
                        int n = i++;
                        eff2[n] = eff2[n] + this.readbuffer[ix] * this._eff2gain;
                        ix += in_c;
                    }
                }
            }
        }
    }

    @Override
    public int getFrameLength() {
        return this.bufferSize / this.format.getFrameSize();
    }

    @Override
    public long getMicrosecondLength() {
        return (long)((double)this.getFrameLength() * (1000000.0 / (double)this.getFormat().getSampleRate()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void loop(int count) {
        LineEvent event = null;
        Object object = this.control_mutex;
        synchronized (object) {
            if (this.isOpen()) {
                if (this.active) {
                    return;
                }
                this.active = true;
                this.active_sg = true;
                this.loopcount = count;
                event = new LineEvent(this, LineEvent.Type.START, this.getLongFramePosition());
            }
        }
        if (event != null) {
            this.sendEvent(event);
        }
    }

    @Override
    public void open(AudioInputStream stream) throws LineUnavailableException, IOException {
        if (this.isOpen()) {
            throw new IllegalStateException("Clip is already open with format " + this.getFormat() + " and frame lengh of " + this.getFrameLength());
        }
        if (AudioFloatConverter.getConverter(stream.getFormat()) == null) {
            throw new IllegalArgumentException("Invalid format : " + stream.getFormat().toString());
        }
        if (stream.getFrameLength() != -1L) {
            int len;
            int ret;
            byte[] data = new byte[(int)stream.getFrameLength() * stream.getFormat().getFrameSize()];
            int readsize = 512 * stream.getFormat().getFrameSize();
            for (len = 0; len != data.length; len += ret) {
                if (readsize > data.length - len) {
                    readsize = data.length - len;
                }
                if ((ret = stream.read(data, len, readsize)) == -1) break;
                if (ret != 0) continue;
                Thread.yield();
            }
            this.open(stream.getFormat(), data, 0, len);
        } else {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            byte[] b = new byte[512 * stream.getFormat().getFrameSize()];
            int r = 0;
            while ((r = stream.read(b)) != -1) {
                if (r == 0) {
                    Thread.yield();
                }
                baos.write(b, 0, r);
            }
            this.open(stream.getFormat(), baos.toByteArray(), 0, baos.size());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void open(AudioFormat format, byte[] data, int offset, int bufferSize) throws LineUnavailableException {
        Object object = this.control_mutex;
        synchronized (object) {
            if (this.isOpen()) {
                throw new IllegalStateException("Clip is already open with format " + this.getFormat() + " and frame lengh of " + this.getFrameLength());
            }
            if (AudioFloatConverter.getConverter(format) == null) {
                throw new IllegalArgumentException("Invalid format : " + format.toString());
            }
            if (bufferSize % format.getFrameSize() != 0) {
                throw new IllegalArgumentException("Buffer size does not represent an integral number of sample frames!");
            }
            if (data != null) {
                this.data = Arrays.copyOf(data, data.length);
            }
            this.offset = offset;
            this.bufferSize = bufferSize;
            this.format = format;
            this.framesize = format.getFrameSize();
            this.loopstart = 0;
            this.loopend = -1;
            this.loop_sg = true;
            if (!this.mixer.isOpen()) {
                this.mixer.open();
                this.mixer.implicitOpen = true;
            }
            this.outputformat = this.mixer.getFormat();
            this.out_nrofchannels = this.outputformat.getChannels();
            this.in_nrofchannels = format.getChannels();
            this.open = true;
            this.mixer.getMainMixer().openLine(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setFramePosition(int frames) {
        Object object = this.control_mutex;
        synchronized (object) {
            this.frameposition_sg = true;
            this.frameposition = frames;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setLoopPoints(int start, int end) {
        Object object = this.control_mutex;
        synchronized (object) {
            if (end != -1) {
                if (end < start) {
                    throw new IllegalArgumentException("Invalid loop points : " + start + " - " + end);
                }
                if (end * this.framesize > this.bufferSize) {
                    throw new IllegalArgumentException("Invalid loop points : " + start + " - " + end);
                }
            }
            if (start * this.framesize > this.bufferSize) {
                throw new IllegalArgumentException("Invalid loop points : " + start + " - " + end);
            }
            if (0 < start) {
                throw new IllegalArgumentException("Invalid loop points : " + start + " - " + end);
            }
            this.loopstart = start;
            this.loopend = end;
            this.loop_sg = true;
        }
    }

    @Override
    public void setMicrosecondPosition(long microseconds) {
        this.setFramePosition((int)((double)microseconds * ((double)this.getFormat().getSampleRate() / 1000000.0)));
    }

    @Override
    public int available() {
        return 0;
    }

    @Override
    public void drain() {
    }

    @Override
    public void flush() {
    }

    @Override
    public int getBufferSize() {
        return this.bufferSize;
    }

    @Override
    public AudioFormat getFormat() {
        return this.format;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getFramePosition() {
        Object object = this.control_mutex;
        synchronized (object) {
            return this.frameposition;
        }
    }

    @Override
    public float getLevel() {
        return -1.0f;
    }

    public long getLongFramePosition() {
        return this.getFramePosition();
    }

    @Override
    public long getMicrosecondPosition() {
        return (long)((double)this.getFramePosition() * (1000000.0 / (double)this.getFormat().getSampleRate()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isActive() {
        Object object = this.control_mutex;
        synchronized (object) {
            return this.active;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isRunning() {
        Object object = this.control_mutex;
        synchronized (object) {
            return this.active;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start() {
        LineEvent event = null;
        Object object = this.control_mutex;
        synchronized (object) {
            if (this.isOpen()) {
                if (this.active) {
                    return;
                }
                this.active = true;
                this.active_sg = true;
                this.loopcount = 0;
                event = new LineEvent(this, LineEvent.Type.START, this.getLongFramePosition());
            }
        }
        if (event != null) {
            this.sendEvent(event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() {
        LineEvent event = null;
        Object object = this.control_mutex;
        synchronized (object) {
            if (this.isOpen()) {
                if (!this.active) {
                    return;
                }
                this.active = false;
                this.active_sg = true;
                event = new LineEvent(this, LineEvent.Type.STOP, this.getLongFramePosition());
            }
        }
        if (event != null) {
            this.sendEvent(event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        LineEvent event = null;
        Object object = this.control_mutex;
        synchronized (object) {
            if (!this.isOpen()) {
                return;
            }
            this.stop();
            event = new LineEvent(this, LineEvent.Type.CLOSE, this.getLongFramePosition());
            this.open = false;
            this.mixer.getMainMixer().closeLine(this);
        }
        if (event != null) {
            this.sendEvent(event);
        }
    }

    @Override
    public boolean isOpen() {
        return this.open;
    }

    @Override
    public void open() throws LineUnavailableException {
        if (this.data == null) {
            throw new IllegalArgumentException("Illegal call to open() in interface Clip");
        }
        this.open(this.format, this.data, this.offset, this.bufferSize);
    }
}

