/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.sound;

import com.sun.media.sound.AbstractMidiDevice;
import com.sun.media.sound.AutoConnectSequencer;
import com.sun.media.sound.EventDispatcher;
import com.sun.media.sound.FastShortMessage;
import com.sun.media.sound.JSSecurityManager;
import com.sun.media.sound.MidiUtils;
import com.sun.media.sound.ReferenceCountingDevice;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import javax.sound.midi.ControllerEventListener;
import javax.sound.midi.InvalidMidiDataException;
import javax.sound.midi.MetaEventListener;
import javax.sound.midi.MetaMessage;
import javax.sound.midi.MidiDevice;
import javax.sound.midi.MidiEvent;
import javax.sound.midi.MidiMessage;
import javax.sound.midi.MidiSystem;
import javax.sound.midi.MidiUnavailableException;
import javax.sound.midi.Receiver;
import javax.sound.midi.Sequence;
import javax.sound.midi.Sequencer;
import javax.sound.midi.ShortMessage;
import javax.sound.midi.Synthesizer;
import javax.sound.midi.Track;
import javax.sound.midi.Transmitter;

final class RealTimeSequencer
extends AbstractMidiDevice
implements Sequencer,
AutoConnectSequencer {
    private static final boolean DEBUG_PUMP = false;
    private static final boolean DEBUG_PUMP_ALL = false;
    private static final Map<ThreadGroup, EventDispatcher> dispatchers = new WeakHashMap<ThreadGroup, EventDispatcher>();
    static final RealTimeSequencerInfo info = new RealTimeSequencerInfo();
    private static final Sequencer.SyncMode[] masterSyncModes = new Sequencer.SyncMode[]{Sequencer.SyncMode.INTERNAL_CLOCK};
    private static final Sequencer.SyncMode[] slaveSyncModes = new Sequencer.SyncMode[]{Sequencer.SyncMode.NO_SYNC};
    private static final Sequencer.SyncMode masterSyncMode = Sequencer.SyncMode.INTERNAL_CLOCK;
    private static final Sequencer.SyncMode slaveSyncMode = Sequencer.SyncMode.NO_SYNC;
    private Sequence sequence = null;
    private double cacheTempoMPQ = -1.0;
    private float cacheTempoFactor = -1.0f;
    private boolean[] trackMuted = null;
    private boolean[] trackSolo = null;
    private final MidiUtils.TempoCache tempoCache = new MidiUtils.TempoCache();
    private boolean running = false;
    private PlayThread playThread;
    private boolean recording = false;
    private final List recordingTracks = new ArrayList();
    private long loopStart = 0L;
    private long loopEnd = -1L;
    private int loopCount = 0;
    private final ArrayList metaEventListeners = new ArrayList();
    private final ArrayList controllerEventListeners = new ArrayList();
    private boolean autoConnect = false;
    private boolean doAutoConnectAtNextOpen = false;
    Receiver autoConnectedReceiver = null;

    RealTimeSequencer() throws MidiUnavailableException {
        super(info);
    }

    @Override
    public synchronized void setSequence(Sequence sequence) throws InvalidMidiDataException {
        if (sequence != this.sequence) {
            if (this.sequence != null && sequence == null) {
                this.setCaches();
                this.stop();
                this.trackMuted = null;
                this.trackSolo = null;
                this.loopStart = 0L;
                this.loopEnd = -1L;
                this.loopCount = 0;
                if (this.getDataPump() != null) {
                    this.getDataPump().setTickPos(0L);
                    this.getDataPump().resetLoopCount();
                }
            }
            if (this.playThread != null) {
                this.playThread.setSequence(sequence);
            }
            this.sequence = sequence;
            if (sequence != null) {
                this.tempoCache.refresh(sequence);
                this.setTickPosition(0L);
                this.propagateCaches();
            }
        } else if (sequence != null) {
            this.tempoCache.refresh(sequence);
            if (this.playThread != null) {
                this.playThread.setSequence(sequence);
            }
        }
    }

    @Override
    public synchronized void setSequence(InputStream stream) throws IOException, InvalidMidiDataException {
        if (stream == null) {
            this.setSequence((Sequence)null);
            return;
        }
        Sequence seq = MidiSystem.getSequence(stream);
        this.setSequence(seq);
    }

    @Override
    public Sequence getSequence() {
        return this.sequence;
    }

    @Override
    public synchronized void start() {
        if (!this.isOpen()) {
            throw new IllegalStateException("sequencer not open");
        }
        if (this.sequence == null) {
            throw new IllegalStateException("sequence not set");
        }
        if (this.running) {
            return;
        }
        this.implStart();
    }

    @Override
    public synchronized void stop() {
        if (!this.isOpen()) {
            throw new IllegalStateException("sequencer not open");
        }
        this.stopRecording();
        if (!this.running) {
            return;
        }
        this.implStop();
    }

    @Override
    public boolean isRunning() {
        return this.running;
    }

    @Override
    public void startRecording() {
        if (!this.isOpen()) {
            throw new IllegalStateException("Sequencer not open");
        }
        this.start();
        this.recording = true;
    }

    @Override
    public void stopRecording() {
        if (!this.isOpen()) {
            throw new IllegalStateException("Sequencer not open");
        }
        this.recording = false;
    }

    @Override
    public boolean isRecording() {
        return this.recording;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void recordEnable(Track track, int channel) {
        if (!this.findTrack(track)) {
            throw new IllegalArgumentException("Track does not exist in the current sequence");
        }
        List list = this.recordingTracks;
        synchronized (list) {
            RecordingTrack rc = RecordingTrack.get(this.recordingTracks, track);
            if (rc != null) {
                rc.channel = channel;
            } else {
                this.recordingTracks.add(new RecordingTrack(track, channel));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void recordDisable(Track track) {
        List list = this.recordingTracks;
        synchronized (list) {
            RecordingTrack rc = RecordingTrack.get(this.recordingTracks, track);
            if (rc != null) {
                this.recordingTracks.remove(rc);
            }
        }
    }

    private boolean findTrack(Track track) {
        boolean found = false;
        if (this.sequence != null) {
            Track[] tracks = this.sequence.getTracks();
            for (int i = 0; i < tracks.length; ++i) {
                if (track != tracks[i]) continue;
                found = true;
                break;
            }
        }
        return found;
    }

    @Override
    public float getTempoInBPM() {
        return (float)MidiUtils.convertTempo(this.getTempoInMPQ());
    }

    @Override
    public void setTempoInBPM(float bpm) {
        if (bpm <= 0.0f) {
            bpm = 1.0f;
        }
        this.setTempoInMPQ((float)MidiUtils.convertTempo(bpm));
    }

    @Override
    public float getTempoInMPQ() {
        if (this.needCaching()) {
            if (this.cacheTempoMPQ != -1.0) {
                return (float)this.cacheTempoMPQ;
            }
            if (this.sequence != null) {
                return this.tempoCache.getTempoMPQAt(this.getTickPosition());
            }
            return 500000.0f;
        }
        return this.getDataPump().getTempoMPQ();
    }

    @Override
    public void setTempoInMPQ(float mpq) {
        if (mpq <= 0.0f) {
            mpq = 1.0f;
        }
        if (this.needCaching()) {
            this.cacheTempoMPQ = mpq;
        } else {
            this.getDataPump().setTempoMPQ(mpq);
            this.cacheTempoMPQ = -1.0;
        }
    }

    @Override
    public void setTempoFactor(float factor) {
        if (factor <= 0.0f) {
            return;
        }
        if (this.needCaching()) {
            this.cacheTempoFactor = factor;
        } else {
            this.getDataPump().setTempoFactor(factor);
            this.cacheTempoFactor = -1.0f;
        }
    }

    @Override
    public float getTempoFactor() {
        if (this.needCaching()) {
            if (this.cacheTempoFactor != -1.0f) {
                return this.cacheTempoFactor;
            }
            return 1.0f;
        }
        return this.getDataPump().getTempoFactor();
    }

    @Override
    public long getTickLength() {
        if (this.sequence == null) {
            return 0L;
        }
        return this.sequence.getTickLength();
    }

    @Override
    public synchronized long getTickPosition() {
        if (this.getDataPump() == null || this.sequence == null) {
            return 0L;
        }
        return this.getDataPump().getTickPos();
    }

    @Override
    public synchronized void setTickPosition(long tick) {
        if (tick < 0L) {
            return;
        }
        if (this.getDataPump() == null) {
            if (tick != 0L) {
                // empty if block
            }
        } else if (this.sequence == null) {
            if (tick != 0L) {
                // empty if block
            }
        } else {
            this.getDataPump().setTickPos(tick);
        }
    }

    @Override
    public long getMicrosecondLength() {
        if (this.sequence == null) {
            return 0L;
        }
        return this.sequence.getMicrosecondLength();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getMicrosecondPosition() {
        if (this.getDataPump() == null || this.sequence == null) {
            return 0L;
        }
        MidiUtils.TempoCache tempoCache = this.tempoCache;
        synchronized (tempoCache) {
            return MidiUtils.tick2microsecond(this.sequence, this.getDataPump().getTickPos(), this.tempoCache);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setMicrosecondPosition(long microseconds) {
        if (microseconds < 0L) {
            return;
        }
        if (this.getDataPump() == null) {
            if (microseconds != 0L) {
                // empty if block
            }
        } else if (this.sequence == null) {
            if (microseconds != 0L) {
                // empty if block
            }
        } else {
            MidiUtils.TempoCache tempoCache = this.tempoCache;
            synchronized (tempoCache) {
                this.setTickPosition(MidiUtils.microsecond2tick(this.sequence, microseconds, this.tempoCache));
            }
        }
    }

    @Override
    public void setMasterSyncMode(Sequencer.SyncMode sync) {
    }

    @Override
    public Sequencer.SyncMode getMasterSyncMode() {
        return masterSyncMode;
    }

    @Override
    public Sequencer.SyncMode[] getMasterSyncModes() {
        Sequencer.SyncMode[] returnedModes = new Sequencer.SyncMode[masterSyncModes.length];
        System.arraycopy(masterSyncModes, 0, returnedModes, 0, masterSyncModes.length);
        return returnedModes;
    }

    @Override
    public void setSlaveSyncMode(Sequencer.SyncMode sync) {
    }

    @Override
    public Sequencer.SyncMode getSlaveSyncMode() {
        return slaveSyncMode;
    }

    @Override
    public Sequencer.SyncMode[] getSlaveSyncModes() {
        Sequencer.SyncMode[] returnedModes = new Sequencer.SyncMode[slaveSyncModes.length];
        System.arraycopy(slaveSyncModes, 0, returnedModes, 0, slaveSyncModes.length);
        return returnedModes;
    }

    int getTrackCount() {
        Sequence seq = this.getSequence();
        if (seq != null) {
            return this.sequence.getTracks().length;
        }
        return 0;
    }

    @Override
    public synchronized void setTrackMute(int track, boolean mute) {
        int trackCount = this.getTrackCount();
        if (track < 0 || track >= this.getTrackCount()) {
            return;
        }
        this.trackMuted = RealTimeSequencer.ensureBoolArraySize(this.trackMuted, trackCount);
        this.trackMuted[track] = mute;
        if (this.getDataPump() != null) {
            this.getDataPump().muteSoloChanged();
        }
    }

    @Override
    public synchronized boolean getTrackMute(int track) {
        if (track < 0 || track >= this.getTrackCount()) {
            return false;
        }
        if (this.trackMuted == null || this.trackMuted.length <= track) {
            return false;
        }
        return this.trackMuted[track];
    }

    @Override
    public synchronized void setTrackSolo(int track, boolean solo) {
        int trackCount = this.getTrackCount();
        if (track < 0 || track >= this.getTrackCount()) {
            return;
        }
        this.trackSolo = RealTimeSequencer.ensureBoolArraySize(this.trackSolo, trackCount);
        this.trackSolo[track] = solo;
        if (this.getDataPump() != null) {
            this.getDataPump().muteSoloChanged();
        }
    }

    @Override
    public synchronized boolean getTrackSolo(int track) {
        if (track < 0 || track >= this.getTrackCount()) {
            return false;
        }
        if (this.trackSolo == null || this.trackSolo.length <= track) {
            return false;
        }
        return this.trackSolo[track];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean addMetaEventListener(MetaEventListener listener) {
        ArrayList arrayList = this.metaEventListeners;
        synchronized (arrayList) {
            if (!this.metaEventListeners.contains(listener)) {
                this.metaEventListeners.add(listener);
            }
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeMetaEventListener(MetaEventListener listener) {
        ArrayList arrayList = this.metaEventListeners;
        synchronized (arrayList) {
            int index = this.metaEventListeners.indexOf(listener);
            if (index >= 0) {
                this.metaEventListeners.remove(index);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int[] addControllerEventListener(ControllerEventListener listener, int[] controllers) {
        ArrayList arrayList = this.controllerEventListeners;
        synchronized (arrayList) {
            ControllerListElement cve = null;
            boolean flag = false;
            for (int i = 0; i < this.controllerEventListeners.size(); ++i) {
                cve = (ControllerListElement)this.controllerEventListeners.get(i);
                if (!cve.listener.equals(listener)) continue;
                cve.addControllers(controllers);
                flag = true;
                break;
            }
            if (!flag) {
                cve = new ControllerListElement(listener, controllers);
                this.controllerEventListeners.add(cve);
            }
            return cve.getControllers();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int[] removeControllerEventListener(ControllerEventListener listener, int[] controllers) {
        ArrayList arrayList = this.controllerEventListeners;
        synchronized (arrayList) {
            ControllerListElement cve = null;
            boolean flag = false;
            for (int i = 0; i < this.controllerEventListeners.size(); ++i) {
                cve = (ControllerListElement)this.controllerEventListeners.get(i);
                if (!cve.listener.equals(listener)) continue;
                cve.removeControllers(controllers);
                flag = true;
                break;
            }
            if (!flag) {
                return new int[0];
            }
            if (controllers == null) {
                int index = this.controllerEventListeners.indexOf(cve);
                if (index >= 0) {
                    this.controllerEventListeners.remove(index);
                }
                return new int[0];
            }
            return cve.getControllers();
        }
    }

    @Override
    public void setLoopStartPoint(long tick) {
        if (tick > this.getTickLength() || this.loopEnd != -1L && tick > this.loopEnd || tick < 0L) {
            throw new IllegalArgumentException("invalid loop start point: " + tick);
        }
        this.loopStart = tick;
    }

    @Override
    public long getLoopStartPoint() {
        return this.loopStart;
    }

    @Override
    public void setLoopEndPoint(long tick) {
        if (tick > this.getTickLength() || this.loopStart > tick && tick != -1L || tick < -1L) {
            throw new IllegalArgumentException("invalid loop end point: " + tick);
        }
        this.loopEnd = tick;
    }

    @Override
    public long getLoopEndPoint() {
        return this.loopEnd;
    }

    @Override
    public void setLoopCount(int count) {
        if (count != -1 && count < 0) {
            throw new IllegalArgumentException("illegal value for loop count: " + count);
        }
        this.loopCount = count;
        if (this.getDataPump() != null) {
            this.getDataPump().resetLoopCount();
        }
    }

    @Override
    public int getLoopCount() {
        return this.loopCount;
    }

    @Override
    protected void implOpen() throws MidiUnavailableException {
        this.playThread = new PlayThread();
        if (this.sequence != null) {
            this.playThread.setSequence(this.sequence);
        }
        this.propagateCaches();
        if (this.doAutoConnectAtNextOpen) {
            this.doAutoConnect();
        }
    }

    private void doAutoConnect() {
        Receiver rec;
        block13: {
            rec = null;
            try {
                Synthesizer synth = MidiSystem.getSynthesizer();
                if (synth instanceof ReferenceCountingDevice) {
                    rec = ((ReferenceCountingDevice)((Object)synth)).getReceiverReferenceCounting();
                    break block13;
                }
                synth.open();
                try {
                    rec = synth.getReceiver();
                }
                finally {
                    if (rec == null) {
                        synth.close();
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (rec == null) {
            try {
                rec = MidiSystem.getReceiver();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (rec != null) {
            this.autoConnectedReceiver = rec;
            try {
                this.getTransmitter().setReceiver(rec);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private synchronized void propagateCaches() {
        if (this.sequence != null && this.isOpen()) {
            if (this.cacheTempoFactor != -1.0f) {
                this.setTempoFactor(this.cacheTempoFactor);
            }
            if (this.cacheTempoMPQ == -1.0) {
                this.setTempoInMPQ(new MidiUtils.TempoCache(this.sequence).getTempoMPQAt(this.getTickPosition()));
            } else {
                this.setTempoInMPQ((float)this.cacheTempoMPQ);
            }
        }
    }

    private synchronized void setCaches() {
        this.cacheTempoFactor = this.getTempoFactor();
        this.cacheTempoMPQ = this.getTempoInMPQ();
    }

    @Override
    protected synchronized void implClose() {
        if (this.playThread != null) {
            this.playThread.close();
            this.playThread = null;
        }
        super.implClose();
        this.sequence = null;
        this.running = false;
        this.cacheTempoMPQ = -1.0;
        this.cacheTempoFactor = -1.0f;
        this.trackMuted = null;
        this.trackSolo = null;
        this.loopStart = 0L;
        this.loopEnd = -1L;
        this.loopCount = 0;
        this.doAutoConnectAtNextOpen = this.autoConnect;
        if (this.autoConnectedReceiver != null) {
            try {
                this.autoConnectedReceiver.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.autoConnectedReceiver = null;
        }
    }

    void implStart() {
        if (this.playThread == null) {
            return;
        }
        this.tempoCache.refresh(this.sequence);
        if (!this.running) {
            this.running = true;
            this.playThread.start();
        }
    }

    void implStop() {
        if (this.playThread == null) {
            return;
        }
        this.recording = false;
        if (this.running) {
            this.running = false;
            this.playThread.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static EventDispatcher getEventDispatcher() {
        ThreadGroup tg = Thread.currentThread().getThreadGroup();
        Map<ThreadGroup, EventDispatcher> map = dispatchers;
        synchronized (map) {
            EventDispatcher eventDispatcher = dispatchers.get(tg);
            if (eventDispatcher == null) {
                eventDispatcher = new EventDispatcher();
                dispatchers.put(tg, eventDispatcher);
                eventDispatcher.start();
            }
            return eventDispatcher;
        }
    }

    void sendMetaEvents(MidiMessage message) {
        if (this.metaEventListeners.size() == 0) {
            return;
        }
        RealTimeSequencer.getEventDispatcher().sendAudioEvents(message, this.metaEventListeners);
    }

    void sendControllerEvents(MidiMessage message) {
        int size = this.controllerEventListeners.size();
        if (size == 0) {
            return;
        }
        if (!(message instanceof ShortMessage)) {
            return;
        }
        ShortMessage msg = (ShortMessage)message;
        int controller = msg.getData1();
        ArrayList<ControllerEventListener> sendToListeners = new ArrayList<ControllerEventListener>();
        block0: for (int i = 0; i < size; ++i) {
            ControllerListElement cve = (ControllerListElement)this.controllerEventListeners.get(i);
            for (int j = 0; j < cve.controllers.length; ++j) {
                if (cve.controllers[j] != controller) continue;
                sendToListeners.add(cve.listener);
                continue block0;
            }
        }
        RealTimeSequencer.getEventDispatcher().sendAudioEvents(message, sendToListeners);
    }

    private boolean needCaching() {
        return !this.isOpen() || this.sequence == null || this.playThread == null;
    }

    private DataPump getDataPump() {
        if (this.playThread != null) {
            return this.playThread.getDataPump();
        }
        return null;
    }

    private MidiUtils.TempoCache getTempoCache() {
        return this.tempoCache;
    }

    private static boolean[] ensureBoolArraySize(boolean[] array, int desiredSize) {
        if (array == null) {
            return new boolean[desiredSize];
        }
        if (array.length < desiredSize) {
            boolean[] newArray = new boolean[desiredSize];
            System.arraycopy(array, 0, newArray, 0, array.length);
            return newArray;
        }
        return array;
    }

    @Override
    protected boolean hasReceivers() {
        return true;
    }

    @Override
    protected Receiver createReceiver() throws MidiUnavailableException {
        return new SequencerReceiver();
    }

    @Override
    protected boolean hasTransmitters() {
        return true;
    }

    @Override
    protected Transmitter createTransmitter() throws MidiUnavailableException {
        return new SequencerTransmitter();
    }

    @Override
    public void setAutoConnect(Receiver autoConnectedReceiver) {
        this.autoConnect = autoConnectedReceiver != null;
        this.autoConnectedReceiver = autoConnectedReceiver;
    }

    private class DataPump {
        private float currTempo;
        private float tempoFactor;
        private float inverseTempoFactor;
        private long ignoreTempoEventAt;
        private int resolution;
        private float divisionType;
        private long checkPointMillis;
        private long checkPointTick;
        private int[] noteOnCache;
        private Track[] tracks;
        private boolean[] trackDisabled;
        private int[] trackReadPos;
        private long lastTick;
        private boolean needReindex = false;
        private int currLoopCounter = 0;

        DataPump() {
            this.init();
        }

        synchronized void init() {
            this.ignoreTempoEventAt = -1L;
            this.tempoFactor = 1.0f;
            this.inverseTempoFactor = 1.0f;
            this.noteOnCache = new int[128];
            this.tracks = null;
            this.trackDisabled = null;
        }

        synchronized void setTickPos(long tickPos) {
            long oldLastTick = tickPos;
            this.lastTick = tickPos;
            if (RealTimeSequencer.this.running) {
                this.notesOff(false);
            }
            if (RealTimeSequencer.this.running || tickPos > 0L) {
                this.chaseEvents(oldLastTick, tickPos);
            } else {
                this.needReindex = true;
            }
            if (!this.hasCachedTempo()) {
                this.setTempoMPQ(RealTimeSequencer.this.getTempoCache().getTempoMPQAt(this.lastTick, this.currTempo));
                this.ignoreTempoEventAt = -1L;
            }
            this.checkPointMillis = 0L;
        }

        long getTickPos() {
            return this.lastTick;
        }

        boolean hasCachedTempo() {
            if (this.ignoreTempoEventAt != this.lastTick) {
                this.ignoreTempoEventAt = -1L;
            }
            return this.ignoreTempoEventAt >= 0L;
        }

        synchronized void setTempoMPQ(float tempoMPQ) {
            if (tempoMPQ > 0.0f && tempoMPQ != this.currTempo) {
                this.ignoreTempoEventAt = this.lastTick;
                this.currTempo = tempoMPQ;
                this.checkPointMillis = 0L;
            }
        }

        float getTempoMPQ() {
            return this.currTempo;
        }

        synchronized void setTempoFactor(float factor) {
            if (factor > 0.0f && factor != this.tempoFactor) {
                this.tempoFactor = factor;
                this.inverseTempoFactor = 1.0f / factor;
                this.checkPointMillis = 0L;
            }
        }

        float getTempoFactor() {
            return this.tempoFactor;
        }

        synchronized void muteSoloChanged() {
            boolean[] newDisabled = this.makeDisabledArray();
            if (RealTimeSequencer.this.running) {
                this.applyDisabledTracks(this.trackDisabled, newDisabled);
            }
            this.trackDisabled = newDisabled;
        }

        synchronized void setSequence(Sequence seq) {
            if (seq == null) {
                this.init();
                return;
            }
            this.tracks = seq.getTracks();
            this.muteSoloChanged();
            this.resolution = seq.getResolution();
            this.divisionType = seq.getDivisionType();
            this.trackReadPos = new int[this.tracks.length];
            this.checkPointMillis = 0L;
            this.needReindex = true;
        }

        synchronized void resetLoopCount() {
            this.currLoopCounter = RealTimeSequencer.this.loopCount;
        }

        void clearNoteOnCache() {
            for (int i = 0; i < 128; ++i) {
                this.noteOnCache[i] = 0;
            }
        }

        void notesOff(boolean doControllers) {
            int done = 0;
            for (int ch = 0; ch < 16; ++ch) {
                int channelMask = 1 << ch;
                for (int i = 0; i < 128; ++i) {
                    if ((this.noteOnCache[i] & channelMask) == 0) continue;
                    int n = i;
                    this.noteOnCache[n] = this.noteOnCache[n] ^ channelMask;
                    RealTimeSequencer.this.getTransmitterList().sendMessage(0x90 | ch | i << 8, -1L);
                    ++done;
                }
                RealTimeSequencer.this.getTransmitterList().sendMessage(0xB0 | ch | 0x7B00, -1L);
                RealTimeSequencer.this.getTransmitterList().sendMessage(0xB0 | ch | 0x4000, -1L);
                if (!doControllers) continue;
                RealTimeSequencer.this.getTransmitterList().sendMessage(0xB0 | ch | 0x7900, -1L);
                ++done;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean[] makeDisabledArray() {
            int i;
            boolean[] solo;
            boolean[] mute;
            if (this.tracks == null) {
                return null;
            }
            boolean[] newTrackDisabled = new boolean[this.tracks.length];
            RealTimeSequencer realTimeSequencer = RealTimeSequencer.this;
            synchronized (realTimeSequencer) {
                mute = RealTimeSequencer.this.trackMuted;
                solo = RealTimeSequencer.this.trackSolo;
            }
            boolean hasSolo = false;
            if (solo != null) {
                for (i = 0; i < solo.length; ++i) {
                    if (!solo[i]) continue;
                    hasSolo = true;
                    break;
                }
            }
            if (hasSolo) {
                for (i = 0; i < newTrackDisabled.length; ++i) {
                    newTrackDisabled[i] = i >= solo.length || !solo[i];
                }
            } else {
                for (i = 0; i < newTrackDisabled.length; ++i) {
                    newTrackDisabled[i] = mute != null && i < mute.length && mute[i];
                }
            }
            return newTrackDisabled;
        }

        private void sendNoteOffIfOn(Track track, long endTick) {
            int size = track.size();
            int done = 0;
            try {
                MidiEvent event;
                for (int i = 0; i < size && (event = track.get(i)).getTick() <= endTick; ++i) {
                    int bit;
                    MidiMessage msg = event.getMessage();
                    int status = msg.getStatus();
                    int len = msg.getLength();
                    if (len != 3 || (status & 0xF0) != 144) continue;
                    int note = -1;
                    if (msg instanceof ShortMessage) {
                        ShortMessage smsg = (ShortMessage)msg;
                        if (smsg.getData2() > 0) {
                            note = smsg.getData1();
                        }
                    } else {
                        byte[] data = msg.getMessage();
                        if ((data[2] & 0x7F) > 0) {
                            note = data[1] & 0x7F;
                        }
                    }
                    if (note < 0 || (this.noteOnCache[note] & (bit = 1 << (status & 0xF))) == 0) continue;
                    RealTimeSequencer.this.getTransmitterList().sendMessage(status | note << 8, -1L);
                    int n = note;
                    this.noteOnCache[n] = this.noteOnCache[n] & (0xFFFF ^ bit);
                    ++done;
                }
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                // empty catch block
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void applyDisabledTracks(boolean[] oldDisabled, boolean[] newDisabled) {
            byte[][] tempArray = null;
            RealTimeSequencer realTimeSequencer = RealTimeSequencer.this;
            synchronized (realTimeSequencer) {
                for (int i = 0; i < newDisabled.length; ++i) {
                    if ((oldDisabled == null || i >= oldDisabled.length || !oldDisabled[i]) && newDisabled[i]) {
                        if (this.tracks.length <= i) continue;
                        this.sendNoteOffIfOn(this.tracks[i], this.lastTick);
                        continue;
                    }
                    if (oldDisabled == null || i >= oldDisabled.length || !oldDisabled[i] || newDisabled[i]) continue;
                    if (tempArray == null) {
                        tempArray = new byte[128][16];
                    }
                    this.chaseTrackEvents(i, 0L, this.lastTick, true, tempArray);
                }
            }
        }

        private void chaseTrackEvents(int trackNum, long startTick, long endTick, boolean doReindex, byte[][] tempArray) {
            if (startTick > endTick) {
                startTick = 0L;
            }
            byte[] progs = new byte[16];
            for (int ch = 0; ch < 16; ++ch) {
                progs[ch] = -1;
                for (int co = 0; co < 128; ++co) {
                    tempArray[co][ch] = -1;
                }
            }
            Track track = this.tracks[trackNum];
            int size = track.size();
            try {
                for (int i = 0; i < size; ++i) {
                    byte[] data;
                    ShortMessage smsg;
                    MidiEvent event = track.get(i);
                    if (event.getTick() >= endTick) {
                        if (doReindex && trackNum < this.trackReadPos.length) {
                            this.trackReadPos[trackNum] = i > 0 ? i - 1 : 0;
                        }
                        break;
                    }
                    MidiMessage msg = event.getMessage();
                    int status = msg.getStatus();
                    int len = msg.getLength();
                    if (len == 3 && (status & 0xF0) == 176) {
                        if (msg instanceof ShortMessage) {
                            smsg = (ShortMessage)msg;
                            tempArray[smsg.getData1() & 0x7F][status & 0xF] = (byte)smsg.getData2();
                        } else {
                            data = msg.getMessage();
                            tempArray[data[1] & 0x7F][status & 0xF] = data[2];
                        }
                    }
                    if (len != 2 || (status & 0xF0) != 192) continue;
                    if (msg instanceof ShortMessage) {
                        smsg = (ShortMessage)msg;
                        progs[status & 0xF] = (byte)smsg.getData1();
                        continue;
                    }
                    data = msg.getMessage();
                    progs[status & 0xF] = data[1];
                }
            }
            catch (ArrayIndexOutOfBoundsException i) {
                // empty catch block
            }
            int numControllersSent = 0;
            for (int ch = 0; ch < 16; ++ch) {
                for (int co = 0; co < 128; ++co) {
                    byte controllerValue = tempArray[co][ch];
                    if (controllerValue < 0) continue;
                    int packedMsg = 0xB0 | ch | co << 8 | controllerValue << 16;
                    RealTimeSequencer.this.getTransmitterList().sendMessage(packedMsg, -1L);
                    ++numControllersSent;
                }
                if (progs[ch] >= 0) {
                    RealTimeSequencer.this.getTransmitterList().sendMessage(0xC0 | ch | progs[ch] << 8, -1L);
                }
                if (progs[ch] < 0 && startTick != 0L && endTick != 0L) continue;
                RealTimeSequencer.this.getTransmitterList().sendMessage(0xE0 | ch | 0x400000, -1L);
                RealTimeSequencer.this.getTransmitterList().sendMessage(0xB0 | ch | 0x4000, -1L);
            }
        }

        synchronized void chaseEvents(long startTick, long endTick) {
            byte[][] tempArray = new byte[128][16];
            for (int t = 0; t < this.tracks.length; ++t) {
                if (this.trackDisabled != null && this.trackDisabled.length > t && this.trackDisabled[t]) continue;
                this.chaseTrackEvents(t, startTick, endTick, true, tempArray);
            }
        }

        private long getCurrentTimeMillis() {
            return System.nanoTime() / 1000000L;
        }

        private long millis2tick(long millis) {
            if (this.divisionType != 0.0f) {
                double dTick = (double)millis * (double)this.tempoFactor * (double)this.divisionType * (double)this.resolution / 1000.0;
                return (long)dTick;
            }
            return MidiUtils.microsec2ticks(millis * 1000L, this.currTempo * this.inverseTempoFactor, this.resolution);
        }

        private long tick2millis(long tick) {
            if (this.divisionType != 0.0f) {
                double dMillis = (double)tick * 1000.0 / ((double)this.tempoFactor * (double)this.divisionType * (double)this.resolution);
                return (long)dMillis;
            }
            return MidiUtils.ticks2microsec(tick, this.currTempo * this.inverseTempoFactor, this.resolution) / 1000L;
        }

        private void ReindexTrack(int trackNum, long tick) {
            if (trackNum < this.trackReadPos.length && trackNum < this.tracks.length) {
                this.trackReadPos[trackNum] = MidiUtils.tick2index(this.tracks[trackNum], tick);
            }
        }

        private boolean dispatchMessage(int trackNum, MidiEvent event) {
            boolean changesPending = false;
            MidiMessage message = event.getMessage();
            int msgStatus = message.getStatus();
            int msgLen = message.getLength();
            if (msgStatus == 255 && msgLen >= 2) {
                int newTempo;
                if (trackNum == 0 && (newTempo = MidiUtils.getTempoMPQ(message)) > 0) {
                    if (event.getTick() != this.ignoreTempoEventAt) {
                        this.setTempoMPQ(newTempo);
                        changesPending = true;
                    }
                    this.ignoreTempoEventAt = -1L;
                }
                RealTimeSequencer.this.sendMetaEvents(message);
            } else {
                RealTimeSequencer.this.getTransmitterList().sendMessage(message, -1L);
                switch (msgStatus & 0xF0) {
                    case 128: {
                        int note;
                        int n = note = ((ShortMessage)message).getData1() & 0x7F;
                        this.noteOnCache[n] = this.noteOnCache[n] & (0xFFFF ^ 1 << (msgStatus & 0xF));
                        break;
                    }
                    case 144: {
                        ShortMessage smsg = (ShortMessage)message;
                        int note = smsg.getData1() & 0x7F;
                        int vel = smsg.getData2() & 0x7F;
                        if (vel > 0) {
                            int n = note;
                            this.noteOnCache[n] = this.noteOnCache[n] | 1 << (msgStatus & 0xF);
                            break;
                        }
                        int n = note;
                        this.noteOnCache[n] = this.noteOnCache[n] & (0xFFFF ^ 1 << (msgStatus & 0xF));
                        break;
                    }
                    case 176: {
                        RealTimeSequencer.this.sendControllerEvents(message);
                    }
                }
            }
            return changesPending;
        }

        synchronized boolean pump() {
            long targetTick = this.lastTick;
            boolean changesPending = false;
            boolean doLoop = false;
            boolean EOM = false;
            long currMillis = this.getCurrentTimeMillis();
            int finishedTracks = 0;
            do {
                int t;
                changesPending = false;
                if (this.needReindex) {
                    if (this.trackReadPos.length < this.tracks.length) {
                        this.trackReadPos = new int[this.tracks.length];
                    }
                    for (t = 0; t < this.tracks.length; ++t) {
                        this.ReindexTrack(t, targetTick);
                    }
                    this.needReindex = false;
                    this.checkPointMillis = 0L;
                }
                if (this.checkPointMillis == 0L) {
                    this.checkPointMillis = currMillis = this.getCurrentTimeMillis();
                    this.checkPointTick = targetTick = this.lastTick;
                } else {
                    targetTick = this.checkPointTick + this.millis2tick(currMillis - this.checkPointMillis);
                    if (RealTimeSequencer.this.loopEnd != -1L && (RealTimeSequencer.this.loopCount > 0 && this.currLoopCounter > 0 || RealTimeSequencer.this.loopCount == -1) && this.lastTick <= RealTimeSequencer.this.loopEnd && targetTick >= RealTimeSequencer.this.loopEnd) {
                        targetTick = RealTimeSequencer.this.loopEnd - 1L;
                        doLoop = true;
                    }
                    this.lastTick = targetTick;
                }
                finishedTracks = 0;
                for (t = 0; t < this.tracks.length; ++t) {
                    block14: {
                        try {
                            MidiEvent currEvent;
                            int readPos;
                            boolean disabled = this.trackDisabled[t];
                            Track thisTrack = this.tracks[t];
                            int size = thisTrack.size();
                            for (readPos = this.trackReadPos[t]; !changesPending && readPos < size && (currEvent = thisTrack.get(readPos)).getTick() <= targetTick; ++readPos) {
                                if (readPos != size - 1 || !MidiUtils.isMetaEndOfTrack(currEvent.getMessage())) continue;
                                readPos = size;
                                break;
                            }
                            if (readPos >= size) {
                                ++finishedTracks;
                            }
                            this.trackReadPos[t] = readPos;
                        }
                        catch (Exception e) {
                            if (!(e instanceof ArrayIndexOutOfBoundsException)) break block14;
                            this.needReindex = true;
                            changesPending = true;
                        }
                    }
                    if (changesPending) break;
                }
                boolean bl = EOM = finishedTracks == this.tracks.length;
                if (!doLoop && ((RealTimeSequencer.this.loopCount <= 0 || this.currLoopCounter <= 0) && RealTimeSequencer.this.loopCount != -1 || changesPending || RealTimeSequencer.this.loopEnd != -1L || !EOM)) continue;
                long oldCheckPointMillis = this.checkPointMillis;
                long loopEndTick = RealTimeSequencer.this.loopEnd;
                if (loopEndTick == -1L) {
                    loopEndTick = this.lastTick;
                }
                if (RealTimeSequencer.this.loopCount != -1) {
                    --this.currLoopCounter;
                }
                this.setTickPos(RealTimeSequencer.this.loopStart);
                this.checkPointMillis = oldCheckPointMillis + this.tick2millis(loopEndTick - this.checkPointTick);
                this.checkPointTick = RealTimeSequencer.this.loopStart;
                this.needReindex = false;
                changesPending = false;
                doLoop = false;
                EOM = false;
            } while (changesPending);
            return EOM;
        }
    }

    final class PlayThread
    implements Runnable {
        private Thread thread;
        private final Object lock = new Object();
        boolean interrupted = false;
        boolean isPumping = false;
        private final DataPump dataPump = new DataPump();

        PlayThread() {
            int priority = 8;
            this.thread = JSSecurityManager.createThread(this, "Java Sound Sequencer", false, priority, true);
        }

        DataPump getDataPump() {
            return this.dataPump;
        }

        synchronized void setSequence(Sequence seq) {
            this.dataPump.setSequence(seq);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        synchronized void start() {
            RealTimeSequencer.this.running = true;
            if (!this.dataPump.hasCachedTempo()) {
                long tickPos = RealTimeSequencer.this.getTickPosition();
                this.dataPump.setTempoMPQ(RealTimeSequencer.this.tempoCache.getTempoMPQAt(tickPos));
            }
            this.dataPump.checkPointMillis = 0L;
            this.dataPump.clearNoteOnCache();
            this.dataPump.needReindex = true;
            this.dataPump.resetLoopCount();
            Object object = this.lock;
            synchronized (object) {
                this.lock.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        synchronized void stop() {
            this.playThreadImplStop();
            long t = System.nanoTime() / 1000000L;
            while (this.isPumping) {
                Object object = this.lock;
                synchronized (object) {
                    try {
                        this.lock.wait(2000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                if (System.nanoTime() / 1000000L - t <= 1900L) continue;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void playThreadImplStop() {
            RealTimeSequencer.this.running = false;
            Object object = this.lock;
            synchronized (object) {
                this.lock.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void close() {
            Thread oldThread = null;
            Object object = this;
            synchronized (object) {
                this.interrupted = true;
                oldThread = this.thread;
                this.thread = null;
            }
            if (oldThread != null) {
                object = this.lock;
                synchronized (object) {
                    this.lock.notifyAll();
                }
            }
            if (oldThread != null) {
                try {
                    oldThread.join(2000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (!this.interrupted) {
                boolean EOM = false;
                boolean wasRunning = RealTimeSequencer.this.running;
                boolean bl = this.isPumping = !this.interrupted && RealTimeSequencer.this.running;
                while (!EOM && !this.interrupted && RealTimeSequencer.this.running) {
                    EOM = this.dataPump.pump();
                    try {
                        Thread.sleep(1L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
                this.playThreadImplStop();
                if (wasRunning) {
                    this.dataPump.notesOff(true);
                }
                if (EOM) {
                    this.dataPump.setTickPos(RealTimeSequencer.this.sequence.getTickLength());
                    MetaMessage message = new MetaMessage();
                    try {
                        message.setMessage(47, new byte[0], 0);
                    }
                    catch (InvalidMidiDataException invalidMidiDataException) {
                        // empty catch block
                    }
                    RealTimeSequencer.this.sendMetaEvents(message);
                }
                Object object = this.lock;
                synchronized (object) {
                    this.isPumping = false;
                    this.lock.notifyAll();
                    while (!RealTimeSequencer.this.running && !this.interrupted) {
                        try {
                            this.lock.wait();
                        }
                        catch (Exception exception) {}
                    }
                }
            }
        }
    }

    static class RecordingTrack {
        private final Track track;
        private int channel;

        RecordingTrack(Track track, int channel) {
            this.track = track;
            this.channel = channel;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        static RecordingTrack get(List recordingTracks, Track track) {
            List list = recordingTracks;
            synchronized (list) {
                int size = recordingTracks.size();
                for (int i = 0; i < size; ++i) {
                    RecordingTrack current = (RecordingTrack)recordingTracks.get(i);
                    if (current.track != track) continue;
                    return current;
                }
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        static Track get(List recordingTracks, int channel) {
            List list = recordingTracks;
            synchronized (list) {
                int size = recordingTracks.size();
                for (int i = 0; i < size; ++i) {
                    RecordingTrack current = (RecordingTrack)recordingTracks.get(i);
                    if (current.channel != channel && current.channel != -1) continue;
                    return current.track;
                }
            }
            return null;
        }
    }

    private class ControllerListElement {
        int[] controllers;
        final ControllerEventListener listener;

        private ControllerListElement(ControllerEventListener listener, int[] controllers) {
            this.listener = listener;
            if (controllers == null) {
                controllers = new int[128];
                for (int i = 0; i < 128; ++i) {
                    controllers[i] = i;
                }
            }
            this.controllers = controllers;
        }

        private void addControllers(int[] c) {
            int i;
            if (c == null) {
                this.controllers = new int[128];
                for (int i2 = 0; i2 < 128; ++i2) {
                    this.controllers[i2] = i2;
                }
                return;
            }
            int[] temp = new int[this.controllers.length + c.length];
            for (i = 0; i < this.controllers.length; ++i) {
                temp[i] = this.controllers[i];
            }
            int elements = this.controllers.length;
            for (i = 0; i < c.length; ++i) {
                boolean flag = false;
                for (int j = 0; j < this.controllers.length; ++j) {
                    if (c[i] != this.controllers[j]) continue;
                    flag = true;
                    break;
                }
                if (flag) continue;
                temp[elements++] = c[i];
            }
            int[] newc = new int[elements];
            for (int i3 = 0; i3 < elements; ++i3) {
                newc[i3] = temp[i3];
            }
            this.controllers = newc;
        }

        private void removeControllers(int[] c) {
            if (c == null) {
                this.controllers = new int[0];
            } else {
                int[] temp = new int[this.controllers.length];
                int elements = 0;
                for (int i = 0; i < this.controllers.length; ++i) {
                    boolean flag = false;
                    for (int j = 0; j < c.length; ++j) {
                        if (this.controllers[i] != c[j]) continue;
                        flag = true;
                        break;
                    }
                    if (flag) continue;
                    temp[elements++] = this.controllers[i];
                }
                int[] newc = new int[elements];
                for (int i = 0; i < elements; ++i) {
                    newc[i] = temp[i];
                }
                this.controllers = newc;
            }
        }

        private int[] getControllers() {
            if (this.controllers == null) {
                return null;
            }
            int[] c = new int[this.controllers.length];
            for (int i = 0; i < this.controllers.length; ++i) {
                c[i] = this.controllers[i];
            }
            return c;
        }
    }

    private static class RealTimeSequencerInfo
    extends MidiDevice.Info {
        private static final String name = "Real Time Sequencer";
        private static final String vendor = "Oracle Corporation";
        private static final String description = "Software sequencer";
        private static final String version = "Version 1.0";

        private RealTimeSequencerInfo() {
            super(name, vendor, description, version);
        }
    }

    final class SequencerReceiver
    extends AbstractMidiDevice.AbstractReceiver {
        SequencerReceiver() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        void implSend(MidiMessage message, long timeStamp) {
            if (RealTimeSequencer.this.recording) {
                long tickPos = 0L;
                if (timeStamp < 0L) {
                    tickPos = RealTimeSequencer.this.getTickPosition();
                } else {
                    MidiUtils.TempoCache tempoCache = RealTimeSequencer.this.tempoCache;
                    synchronized (tempoCache) {
                        tickPos = MidiUtils.microsecond2tick(RealTimeSequencer.this.sequence, timeStamp, RealTimeSequencer.this.tempoCache);
                    }
                }
                Track track = null;
                if (message.getLength() > 1) {
                    if (message instanceof ShortMessage) {
                        ShortMessage sm = (ShortMessage)message;
                        if ((sm.getStatus() & 0xF0) != 240) {
                            track = RecordingTrack.get(RealTimeSequencer.this.recordingTracks, sm.getChannel());
                        }
                    } else {
                        track = RecordingTrack.get(RealTimeSequencer.this.recordingTracks, -1);
                    }
                    if (track != null) {
                        message = message instanceof ShortMessage ? new FastShortMessage((ShortMessage)message) : (MidiMessage)message.clone();
                        MidiEvent me = new MidiEvent(message, tickPos);
                        track.add(me);
                    }
                }
            }
        }
    }

    private class SequencerTransmitter
    extends AbstractMidiDevice.BasicTransmitter {
        private SequencerTransmitter() {
        }
    }
}

