/*
 * Decompiled with CFR 0.152.
 */
package org.muplayer.audio.formats;

import java.io.File;
import java.io.IOException;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.UnsupportedAudioFileException;
import org.jaudiotagger.audio.exceptions.InvalidAudioFrameException;
import org.jaudiotagger.audio.mp3.MP3AudioHeader;
import org.jflac.sound.spi.FlacAudioFileReader;
import org.jflac.sound.spi.FlacFormatConversionProvider;
import org.muplayer.audio.Track;

public class FlacTrack
extends Track {
    public FlacTrack(File ftrack) throws LineUnavailableException, IOException, UnsupportedAudioFileException {
        super(ftrack);
        MP3AudioHeader audioHeader = null;
        try {
            audioHeader = new MP3AudioHeader(this.dataSource);
        }
        catch (InvalidAudioFrameException e) {
            e.printStackTrace();
        }
    }

    public FlacTrack(String trackPath) throws LineUnavailableException, IOException, UnsupportedAudioFileException {
        this(new File(trackPath));
    }

    @Override
    public boolean isValidTrack() {
        return true;
    }

    @Override
    protected void loadAudioStream() {
        try {
            this.audioReader = new FlacAudioFileReader();
            AudioInputStream flacAis = this.audioReader.getAudioInputStream(this.dataSource);
            AudioFormat format = flacAis.getFormat();
            AudioFormat decodedFormat = new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, format.getSampleRate(), format.getSampleSizeInBits(), format.getChannels(), format.getChannels() * 2, format.getSampleRate(), format.isBigEndian());
            this.trackStream = new FlacFormatConversionProvider().getAudioInputStream(decodedFormat, flacAis);
        }
        catch (IOException | UnsupportedAudioFileException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void seek(double seconds) throws IOException {
        if (seconds == 0.0) {
            return;
        }
        this.secsSeeked += seconds;
        AudioFormat audioFormat = this.getAudioFormat();
        float frameRate = audioFormat.getFrameRate();
        int frameSize = audioFormat.getFrameSize();
        double framesToSeek = (double)frameRate * seconds;
        long seek = Math.round(framesToSeek * (double)frameSize);
        this.trackStream.read(new byte[(int)seek]);
    }
}

