/*
 * Decompiled with CFR 0.152.
 */
package org.muplayer.main;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.StandardOpenOption;
import java.util.Iterator;
import java.util.Map;
import java.util.Scanner;
import java.util.Set;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.UnsupportedAudioFileException;
import org.muplayer.audio.Player;
import org.muplayer.audio.SeekOption;
import org.muplayer.audio.Track;
import org.muplayer.main.CommandInterpreter;
import org.muplayer.main.ConsoleOrder;
import org.muplayer.system.SystemConsole;
import org.orangelogger.sys.Logger;
import org.orangelogger.sys.SystemUtil;

public class ConsolePlayer
extends Thread {
    protected volatile Player player;
    protected volatile CommandInterpreter interpreter;
    protected volatile File playerFolder;
    protected volatile Scanner scanner;
    protected boolean on;
    protected static final String LINEHEADER = "[MuPlayer]> ";

    public ConsolePlayer(File rootFolder) throws FileNotFoundException {
        this.player = new Player(rootFolder);
        this.initInterpreter();
        this.playerFolder = rootFolder;
        this.scanner = new Scanner(System.in);
        this.on = false;
        this.setName("ConsolePlayer");
    }

    public ConsolePlayer(String folder) throws FileNotFoundException {
        this(new File(folder));
    }

    protected void initInterpreter() {
        this.interpreter = cmd -> {
            String cmdOrder;
            switch (cmdOrder = cmd.getOrder()) {
                case "st": {
                    if (this.player == null) {
                        this.player = new Player(this.playerFolder);
                    }
                    if (this.player.isAlive() && cmd.hasOptions()) {
                        File musicFolder = new File(cmd.getOptionAt(0));
                        if (musicFolder.exists()) {
                            Player newPlayer = new Player(musicFolder);
                            this.player.shutdown();
                            newPlayer.start();
                            this.player = newPlayer;
                            break;
                        }
                        Logger.getLogger(this, (Object)"Folder not exists").rawError();
                        break;
                    }
                    if (this.player.isAlive()) break;
                    this.player.start();
                    break;
                }
                case "ist": {
                    if (this.player == null) break;
                    Logger.getLogger(this, (Object)(this.player.isPlaying() ? "Is playing" : "Is not playing")).rawWarning();
                    break;
                }
                case "pl": {
                    if (this.player == null) break;
                    if (cmd.hasOptions()) {
                        Number playIndex = cmd.getOptionAsNumber(0);
                        if (playIndex == null || playIndex.intValue() <= 0 || playIndex.intValue() > this.player.getSongsCount()) break;
                        this.player.play(playIndex.intValue() - 1);
                        break;
                    }
                    this.player.play();
                    break;
                }
                case "ps": {
                    if (this.player == null) break;
                    this.player.pause();
                    break;
                }
                case "s": {
                    if (this.player == null) break;
                    this.player.stopTrack();
                    break;
                }
                case "r": {
                    if (this.player == null) break;
                    this.player.resumeTrack();
                    break;
                }
                case "n": {
                    if (this.player == null) break;
                    if (cmd.hasOptions()) {
                        Number jumps = cmd.getOptionAsNumber(0);
                        if (jumps == null) {
                            Logger.getLogger(this, (Object)"Jump value incorrect").rawError();
                            break;
                        }
                        this.player.jumpTrack(jumps.intValue(), SeekOption.NEXT);
                        break;
                    }
                    this.player.playNext();
                    break;
                }
                case "p": {
                    if (this.player == null) break;
                    if (cmd.hasOptions()) {
                        Number jumps = cmd.getOptionAsNumber(0);
                        if (jumps == null) {
                            Logger.getLogger(this, (Object)"Jump value incorrect").rawError();
                            break;
                        }
                        this.player.jumpTrack(jumps.intValue(), SeekOption.PREV);
                        break;
                    }
                    this.player.playPrevious();
                    break;
                }
                case "m": {
                    if (this.player == null) break;
                    this.player.mute();
                    break;
                }
                case "um": {
                    if (this.player == null) break;
                    this.player.unmute();
                    break;
                }
                case "l": {
                    if (this.player == null) break;
                    this.player.printTracks();
                    break;
                }
                case "list": {
                    if (this.player == null) break;
                    this.player.printTracks();
                    break;
                }
                case "lc": {
                    if (this.player == null) break;
                    this.player.printFolderTracks();
                    break;
                }
                case "lf": {
                    if (this.player == null) break;
                    this.player.printFolders();
                    break;
                }
                case "gv": {
                    if (this.player == null) break;
                    Logger.getLogger(this, (Object)("Player Volume(0-100): " + this.player.getGain())).rawWarning();
                    break;
                }
                case "v": {
                    if (this.player == null || !cmd.hasOptions()) break;
                    Number volume = cmd.getOptionAsNumber(0);
                    if (volume == null) {
                        Logger.getLogger(this, (Object)"Volume value incorrect").rawError();
                        break;
                    }
                    this.player.setGain(volume.floatValue());
                    Logger.getLogger(this, (Object)"Volume value changed").rawWarning();
                    break;
                }
                case "sh": {
                    if (this.player == null) break;
                    this.player.shutdown();
                    this.player = null;
                    break;
                }
                case "exit": {
                    if (this.player != null) {
                        this.player.shutdown();
                        this.player = null;
                    }
                    this.on = false;
                    break;
                }
                case "quit": {
                    if (this.player != null) {
                        this.player.shutdown();
                        this.player = null;
                    }
                    this.on = false;
                    break;
                }
                case "k": {
                    if (this.player == null || !cmd.hasOptions()) break;
                    Number seekSec = cmd.getOptionAsNumber(0);
                    if (seekSec == null) {
                        Logger.getLogger(this, (Object)"Seek value incorrect").rawError();
                        break;
                    }
                    this.player.seek(seekSec.doubleValue());
                    Logger.getLogger(this, (Object)"Seeked").rawWarning();
                    break;
                }
                case "skf": {
                    if (this.player == null) break;
                    if (cmd.hasOptions()) {
                        String optionParam = cmd.getOptionAt(0);
                        SeekOption option = optionParam.equals("next") ? SeekOption.NEXT : (optionParam.equals("prev") ? SeekOption.PREV : null);
                        Number jumps = cmd.getOptionAsNumber(1);
                        if (cmd.getOptionsCount() > 1 && jumps == null) {
                            Logger.getLogger(this, (Object)"Seek value incorrect").rawError();
                            break;
                        }
                        if (jumps == null && option == null) {
                            Logger.getLogger(this, (Object)"Option value incorrect").rawError();
                            break;
                        }
                        if (jumps == null) {
                            this.player.seekFolder(option);
                            break;
                        }
                        if (jumps.intValue() < 0) {
                            Logger.getLogger(this, (Object)"Jumps value incorrect").rawError();
                            break;
                        }
                        this.player.seekFolder(option, jumps.intValue());
                        Logger.getLogger(this, (Object)"Seeked").rawWarning();
                        break;
                    }
                    this.player.seekFolder(SeekOption.NEXT);
                    break;
                }
                case "u": {
                    if (this.player == null) break;
                    this.player.reloadTracks();
                    break;
                }
                case "plf": {
                    if (this.player == null || !cmd.hasOptions()) break;
                    Number fldIndex = cmd.getOptionAsNumber(0);
                    if (fldIndex == null) {
                        Logger.getLogger(this, (Object)"Play index value incorrect").rawError();
                        break;
                    }
                    this.player.playFolder(fldIndex.intValue() - 1);
                    break;
                }
                case "g": {
                    if (this.player == null || !cmd.hasOptions()) break;
                    Number gotoSec = cmd.getOptionAsNumber(0);
                    if (gotoSec == null) {
                        Logger.getLogger(this, (Object)"Go to value incorrect").rawError();
                        break;
                    }
                    this.player.seek(gotoSec.doubleValue());
                    Logger.getLogger(this, (Object)"Right Goto command").rawWarning();
                    break;
                }
                case "c": {
                    if (this.player == null) break;
                    Logger.getLogger(this, (Object)this.player.getSongsCount()).rawWarning();
                    break;
                }
                case "d": {
                    if (this.player == null) break;
                    Logger.getLogger(this, (Object)this.player.getCurrent().getFormattedDuration()).rawWarning();
                    break;
                }
                case "cover": {
                    Track current = this.player.getCurrent();
                    if (current == null) {
                        Logger.getLogger(this, (Object)"Current track unavailable").rawError();
                        break;
                    }
                    if (!current.hasCover()) {
                        Logger.getLogger(this, (Object)"Current song don't have cover").rawError();
                        break;
                    }
                    if (cmd.hasOptions()) {
                        File folderPath = new File(cmd.getOptionAt(0));
                        if (!folderPath.exists()) {
                            folderPath = this.player.getRootFolder();
                        }
                        File fileCover = new File(folderPath, "cover-" + current.getTitle() + ".png");
                        fileCover.createNewFile();
                        Files.write(fileCover.toPath(), current.getCoverData(), StandardOpenOption.WRITE);
                        Logger.getLogger(this, (Object)("Created cover with name " + fileCover.getName())).rawWarning();
                        break;
                    }
                    Logger.getLogger(this, (Object)"Cover path not defined").rawError();
                    break;
                }
                case "info": {
                    Track current = this.player.getCurrent();
                    if (current == null) {
                        Logger.getLogger(this, (Object)"Current track unavailable").rawError();
                        break;
                    }
                    Logger.getLogger(this, (Object)current.getSongInfo()).rawWarning();
                    break;
                }
                case "prog": {
                    Track current = this.player.getCurrent();
                    if (current == null) {
                        Logger.getLogger(this, (Object)"Current track unavailable").rawError();
                        break;
                    }
                    if (cmd.hasOptions() && cmd.getOptionAt(0).equals("h")) {
                        Logger.getLogger(this, (Object)current.getFormattedProgress()).rawWarning();
                        break;
                    }
                    Logger.getLogger(this, (Object)current.getProgress()).rawWarning();
                    break;
                }
                case "clear": {
                    this.clearConsole();
                    break;
                }
                case "cls": {
                    this.clearConsole();
                    break;
                }
                case "format": {
                    Track current = this.player.getCurrent();
                    if (current == null) {
                        Logger.getLogger(this, (Object)"Current track unavailable").rawError();
                        break;
                    }
                    String className = current.getClass().getSimpleName();
                    Logger.getLogger(this, (Object)className.substring(0, className.length() - 5).toLowerCase()).rawWarning();
                    break;
                }
                case "h": {
                    this.printHelp();
                    break;
                }
                case "system": {
                    if (!cmd.hasOptions()) break;
                    SystemConsole.exec(cmd.getOptionsAsString());
                    break;
                }
                case "sys": {
                    if (!cmd.hasOptions()) break;
                    SystemConsole.exec(cmd.getOptionsAsString());
                    break;
                }
                default: {
                    Logger.getLogger(this, (Object)"Comando desconocido, inserte el comando \"h\" o \"help\"\npara desplegar el men\u00fa de ayuda.").rawWarning();
                }
            }
        };
    }

    protected void clearConsole() throws IOException {
        SystemConsole.exec("clear");
    }

    protected int getMaxOrderLenght() {
        Set<String> keys = ConsoleOrder.HELP_MAP.keySet();
        int max = 0;
        Iterator it = keys.iterator();
        while (it.hasNext()) {
            int keyLen = ((String)it.next()).length();
            if (keyLen <= max) continue;
            max = keyLen;
        }
        return max;
    }

    protected String getSpacer(int ordersCount, int maxLen, int orderId, int orderLen) {
        StringBuilder sbSpacer = new StringBuilder();
        int spacerLen = maxLen - orderLen;
        for (int i = 0; i < spacerLen; ++i) {
            sbSpacer.append(' ');
        }
        int ordersCountDigit = String.valueOf(ordersCount).length();
        int orderIdDigits = String.valueOf(orderId).length();
        int xtraSpaces = ordersCountDigit - orderIdDigits;
        for (int i = 0; i < xtraSpaces; ++i) {
            sbSpacer.append(' ');
        }
        return sbSpacer.toString();
    }

    protected void printHelpTitle(int maxLine) {
        int i;
        String helpMsg = "MuPlayer Help Men\u00fa";
        int msgLen = helpMsg.length();
        int lateralLen = (maxLine - msgLen) / 2;
        StringBuilder sbTitle = new StringBuilder();
        StringBuilder sbBorder = new StringBuilder();
        StringBuilder sbLateral = new StringBuilder();
        for (i = 0; i < maxLine; ++i) {
            sbBorder.append('-');
        }
        sbBorder.append('\n');
        for (i = 0; i < lateralLen; ++i) {
            sbLateral.append(' ');
        }
        String border = sbBorder.toString();
        String lateral = sbLateral.toString();
        sbTitle.append(border).append(lateral).append(helpMsg).append(lateral).append('\n').append(border);
        Logger.getLogger(this, (Object)sbTitle.toString()).rawWarning();
    }

    protected void printHelp() {
        Map<String, String> helpMap = ConsoleOrder.HELP_MAP;
        Iterator<Map.Entry<String, String>> it = helpMap.entrySet().iterator();
        int maxLen = this.getMaxOrderLenght();
        int orderCount = ConsoleOrder.HELP_MAP.size();
        StringBuilder sbHelp = new StringBuilder();
        StringBuilder sbLine = new StringBuilder();
        int count = 1;
        int maxLine = 0;
        while (it.hasNext()) {
            Map.Entry<String, String> entry = it.next();
            sbLine.append(count).append(") ").append(entry.getKey()).append(this.getSpacer(orderCount, maxLen, count, entry.getKey().length())).append(": ").append(entry.getValue());
            sbHelp.append(sbLine.toString()).append('\n');
            int lineLenght = sbLine.length();
            if (lineLenght > maxLen) {
                maxLine = lineLenght;
            }
            sbLine.delete(0, lineLenght);
            ++count;
        }
        System.out.println("MaxLine: " + maxLine);
        this.printHelpTitle(maxLine);
        Logger.getLogger(this, (Object)sbHelp.toString()).rawWarning();
    }

    protected void printHeader() {
        FileOutputStream stdout = SystemUtil.getStdout();
        try {
            stdout.write(Logger.getLogger(this, (Object)LINEHEADER).getColoredMsg("\u001b[32m").getBytes());
            stdout.flush();
        }
        catch (IOException e) {
            Logger.getLogger(this, e.getClass().getSimpleName(), (Object)e.getMessage()).error();
        }
    }

    public void execCommand(String strCmd) {
        try {
            this.interpreter.interprate(strCmd);
        }
        catch (IOException | LineUnavailableException | UnsupportedAudioFileException e) {
            Logger.getLogger(this, e.getClass().getSimpleName(), (Object)e.getMessage()).error();
        }
    }

    @Override
    public void run() {
        Logger.getLogger(this, (Object)"MuPlayer started...").rawInfo();
        this.on = true;
        while (this.on) {
            this.printHeader();
            String cmd = this.scanner.nextLine().trim();
            this.execCommand(cmd);
        }
    }

    public static void main(String[] args) {
        try {
            if (args.length == 0) {
                new ConsolePlayer("/home/martin/Escritorio/M\u00fasica").start();
            } else {
                new ConsolePlayer(args[0]).start();
            }
        }
        catch (Exception e) {
            Logger.getLogger(ConsolePlayer.class, e.getClass().getSimpleName(), (Object)e.getMessage()).error();
        }
    }
}

