/*
 * Decompiled with CFR 0.152.
 */
package org.orangeplayer.common.util;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;

public class SysUtil {
    private static final String ENCODING = "UTF-8";

    public static boolean isNumber(Object obj) {
        return SysUtil.isNumber(obj.toString());
    }

    public static boolean isNumber(String str) {
        try {
            Integer.parseInt(str);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    public static String format(boolean encode, String param) {
        return SysUtil.formatParams(encode, param)[0];
    }

    public static String[] formatParams(boolean encode, String ... params) {
        int length = params.length;
        String[] transformedParams = new String[length];
        if (encode) {
            for (int i = 0; i < length; ++i) {
                try {
                    transformedParams[i] = URLEncoder.encode(params[i], ENCODING);
                    continue;
                }
                catch (UnsupportedEncodingException e) {
                    e.printStackTrace();
                }
            }
        } else {
            for (int i = 0; i < length; ++i) {
                try {
                    transformedParams[i] = URLDecoder.decode(params[i], ENCODING);
                    continue;
                }
                catch (UnsupportedEncodingException e) {
                    e.printStackTrace();
                }
            }
        }
        return transformedParams;
    }

    public static String[] encodeParams(String ... params) {
        return SysUtil.formatParams(true, params);
    }

    public static String[] decodeParams(String ... params) {
        return SysUtil.formatParams(false, params);
    }

    public static String formatParametersAsString(String ... parameters) {
        String[] formatted = SysUtil.encodeParams(parameters);
        if (formatted == null) {
            return null;
        }
        StringBuilder sbParams = new StringBuilder();
        sbParams.append(formatted[0]);
        for (int i = 1; i < formatted.length; ++i) {
            sbParams.append('/').append(formatted[i]);
        }
        return sbParams.toString();
    }
}

