(def jetty-10-version "10.0.26")

(defproject org.openvoxproject/trapperkeeper-webserver-jetty10 "1.1.0"
  :description "A jetty10-based webserver implementation for use with the org.openvoxproject/trapperkeeper service framework."
  :url "https://github.com/openvoxproject/trapperkeeper-webserver-jetty10"
  :license {:name "Apache License, Version 2.0"
            :url "http://www.apache.org/licenses/LICENSE-2.0"}

  :min-lein-version "2.9.1"

  :parent-project {:coords [org.openvoxproject/clj-parent "7.6.3"]
                   :inherit [:managed-dependencies]}

  ;; Abort when version ranges or version conflicts are detected in
  ;; dependencies. Also supports :warn to simply emit warnings.
  ;; requires lein 2.2.0+.
  :pedantic? :abort
  :dependencies [[org.clojure/clojure]
                 [org.clojure/java.jmx]
                 [org.clojure/tools.logging]

                 [org.flatland/ordered "1.5.9"]

                 [javax.servlet/javax.servlet-api "4.0.1"]
                 ;; Jetty Webserver
                 [org.eclipse.jetty/jetty-server ~jetty-10-version]
                 [org.eclipse.jetty/jetty-servlet ~jetty-10-version]
                 [org.eclipse.jetty/jetty-servlets ~jetty-10-version]
                 [org.eclipse.jetty/jetty-webapp ~jetty-10-version]
                 [org.eclipse.jetty/jetty-proxy ~jetty-10-version]
                 [org.eclipse.jetty/jetty-jmx ~jetty-10-version]
                 [org.eclipse.jetty.websocket/websocket-jetty-server ~jetty-10-version]
                 ;; used in pcp-client
                 [org.eclipse.jetty.websocket/websocket-jetty-client ~jetty-10-version]
                 [org.eclipse.jetty.websocket/websocket-jetty-api ~jetty-10-version]


                 [prismatic/schema]
                 [ring/ring-servlet]
                 [ring/ring-codec]
                 [ch.qos.logback/logback-access]
                 [ch.qos.logback/logback-core]
                 [ch.qos.logback/logback-classic]

                 [org.openvoxproject/ssl-utils]
                 [org.openvoxproject/kitchensink]
                 [org.openvoxproject/trapperkeeper]
                 [org.openvoxproject/i18n]
                 [org.openvoxproject/trapperkeeper-filesystem-watcher]

                 [org.slf4j/jul-to-slf4j]]

  :source-paths  ["src"]
  :java-source-paths  ["java"]

  :plugins [[lein-parent "0.3.9"]
            [org.openvoxproject/i18n "1.0.2"]]

  :deploy-repositories [["releases" {:url "https://clojars.org/repo"
                                     :username :env/CLOJARS_USERNAME
                                     :password :env/CLOJARS_PASSWORD
                                     :sign-releases false}]]

  ;; By declaring a classifier here and a corresponding profile below we'll get an additional jar
  ;; during `lein jar` that has all the code in the test/ directory. Downstream projects can then
  ;; depend on this test jar using a :classifier in their :dependencies to reuse the test utility
  ;; code that we have.
  :classifiers [["test" :testutils]]

  :test-paths ["test/clj"]

  :profiles {:shared {:source-paths ["examples/multiserver_app/src"
                                     "examples/ring_app/src"
                                     "examples/servlet_app/src/clj"
                                     "examples/war_app/src"
                                     "examples/webrouting_app/src"]
                      :java-source-paths ["examples/servlet_app/src/java"
                                          "test/java"]
                      :resource-paths ["dev-resources"]
                      :dependencies [[org.openvoxproject/http-client]
                                     [org.openvoxproject/kitchensink nil :classifier "test"]
                                     [org.openvoxproject/trapperkeeper nil :classifier "test"]
                                     [org.clojure/tools.namespace]
                                     [compojure]
                                     [ring/ring-core]
                                     [hato "0.9.0"]]}
             :dev-only {:dependencies [[org.bouncycastle/bcpkix-jdk18on]]
                        :jvm-opts ["-Djava.util.logging.config.file=dev-resources/logging.properties"]}
             :dev [:shared :dev-only]
             :fips-only {:dependencies [[org.bouncycastle/bcpkix-fips]
                                        [org.bouncycastle/bc-fips]
                                        [org.bouncycastle/bctls-fips]]
                         ;; this only ensures that we run with the proper profiles
                         ;; during testing. This JVM opt will be set in the puppet module
                         ;; that sets up the JVM classpaths during installation.
                         :jvm-opts ~(let [version (System/getProperty "java.version")
                                          [major minor _] (clojure.string/split version #"\.")
                                          unsupported-ex (ex-info "Unsupported major Java version. Expects 17 or 21"
                                                                  {:major major
                                                                   :minor minor})]
                                      (condp = (java.lang.Integer/parseInt major)
                                        17 ["-Djava.security.properties==dev-resources/jdk17-fips-security"]
                                        21 ["-Djava.security.properties==dev-resources/jdk21-fips-security"]
                                        (throw unsupported-ex)))}
             :fips [:shared :fips-only]

             ;; per https://github.com/technomancy/leiningen/issues/1907
             ;; the provided profile is necessary for lein jar / lein install
             :provided {:dependencies [[org.bouncycastle/bcpkix-jdk18on]]
                        :resource-paths ["dev-resources"]}

             :testutils {:source-paths ^:replace ["test/clj"]
                         :java-source-paths ^:replace ["test/java"]}}

  :main puppetlabs.trapperkeeper.main)
