/*
 * Decompiled with CFR 0.152.
 */
package com.puppetlabs.http.client.metrics;

import com.codahale.metrics.MetricFilter;
import com.codahale.metrics.MetricRegistry;
import com.puppetlabs.http.client.impl.metrics.CategoryClientTimerMetricFilter;
import com.puppetlabs.http.client.impl.metrics.MetricIdClientTimerFilter;
import com.puppetlabs.http.client.impl.metrics.TimerMetricData;
import com.puppetlabs.http.client.impl.metrics.UrlAndMethodClientTimerFilter;
import com.puppetlabs.http.client.impl.metrics.UrlClientTimerFilter;
import com.puppetlabs.http.client.metrics.ClientMetricDataContainer;
import com.puppetlabs.http.client.metrics.ClientTimerContainer;
import com.puppetlabs.http.client.metrics.MetricIdClientMetricData;
import com.puppetlabs.http.client.metrics.MetricIdClientTimer;
import com.puppetlabs.http.client.metrics.UrlAndMethodClientMetricData;
import com.puppetlabs.http.client.metrics.UrlAndMethodClientTimer;
import com.puppetlabs.http.client.metrics.UrlClientMetricData;
import com.puppetlabs.http.client.metrics.UrlClientTimer;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Metrics {
    public static final String PUPPETLABS_NAMESPACE_PREFIX = "puppetlabs";
    public static final String HTTP_CLIENT_NAMESPACE_PREFIX = "http-client.experimental";
    public static final String DEFAULT_NAMESPACE_PREFIX = "puppetlabs.http-client.experimental";
    public static final String NAMESPACE_URL = "with-url";
    public static final String NAMESPACE_URL_AND_METHOD = "with-url-and-method";
    public static final String NAMESPACE_METRIC_ID = "with-metric-id";
    public static final String NAMESPACE_FULL_RESPONSE = "full-response";
    private static final Logger LOGGER = LoggerFactory.getLogger(Metrics.class);

    public static String buildMetricNamespace(String string, String string2) {
        if (string != null) {
            if (string2 != null) {
                LOGGER.warn("Metric prefix and server id both set. Using metric prefix '" + string + "' for metric namespace.");
            }
            return string + ".http-client.experimental";
        }
        if (string2 != null) {
            return "puppetlabs." + string2 + ".http-client.experimental";
        }
        return DEFAULT_NAMESPACE_PREFIX;
    }

    public static String urlToMetricUrl(String string) throws URISyntaxException {
        URI uRI = new URI(string);
        URI uRI2 = new URI(uRI.getScheme(), null, uRI.getHost(), uRI.getPort(), uRI.getPath(), null, null);
        return uRI2.toString();
    }

    private static List<UrlClientTimer> getUrlClientTimerArray(MetricRegistry metricRegistry, MetricFilter metricFilter) {
        ArrayList<UrlClientTimer> arrayList = new ArrayList<UrlClientTimer>();
        for (Map.Entry entry : metricRegistry.getTimers(metricFilter).entrySet()) {
            UrlClientTimer urlClientTimer = (UrlClientTimer)((Object)entry.getValue());
            arrayList.add(urlClientTimer);
        }
        return arrayList;
    }

    private static List<UrlAndMethodClientTimer> getUrlAndMethodClientTimerArray(MetricRegistry metricRegistry, MetricFilter metricFilter) {
        ArrayList<UrlAndMethodClientTimer> arrayList = new ArrayList<UrlAndMethodClientTimer>();
        for (Map.Entry entry : metricRegistry.getTimers(metricFilter).entrySet()) {
            UrlAndMethodClientTimer urlAndMethodClientTimer = (UrlAndMethodClientTimer)((Object)entry.getValue());
            arrayList.add(urlAndMethodClientTimer);
        }
        return arrayList;
    }

    private static List<MetricIdClientTimer> getMetricIdClientTimerArray(MetricRegistry metricRegistry, MetricFilter metricFilter) {
        ArrayList<MetricIdClientTimer> arrayList = new ArrayList<MetricIdClientTimer>();
        for (Map.Entry entry : metricRegistry.getTimers(metricFilter).entrySet()) {
            MetricIdClientTimer metricIdClientTimer = (MetricIdClientTimer)((Object)entry.getValue());
            arrayList.add(metricIdClientTimer);
        }
        return arrayList;
    }

    public static ClientTimerContainer getClientMetrics(MetricRegistry metricRegistry) {
        if (metricRegistry != null) {
            return new ClientTimerContainer(Metrics.getUrlClientTimerArray(metricRegistry, new CategoryClientTimerMetricFilter(MetricCategory.URL)), Metrics.getUrlAndMethodClientTimerArray(metricRegistry, new CategoryClientTimerMetricFilter(MetricCategory.URL_AND_METHOD)), Metrics.getMetricIdClientTimerArray(metricRegistry, new CategoryClientTimerMetricFilter(MetricCategory.METRIC_ID)));
        }
        throw new IllegalArgumentException("Metric registry must not be null");
    }

    public static List<UrlClientTimer> getClientMetricsByUrl(MetricRegistry metricRegistry, String string) {
        if (metricRegistry != null) {
            return Metrics.getUrlClientTimerArray(metricRegistry, new UrlClientTimerFilter(string));
        }
        throw new IllegalArgumentException("Metric registry must not be null");
    }

    public static List<UrlAndMethodClientTimer> getClientMetricsByUrlAndMethod(MetricRegistry metricRegistry, String string, String string2) {
        if (metricRegistry != null) {
            return Metrics.getUrlAndMethodClientTimerArray(metricRegistry, new UrlAndMethodClientTimerFilter(string, string2));
        }
        throw new IllegalArgumentException("Metric registry must not be null");
    }

    public static List<MetricIdClientTimer> getClientMetricsByMetricId(MetricRegistry metricRegistry, String[] stringArray) {
        if (metricRegistry != null) {
            if (stringArray.length == 0) {
                return Metrics.getMetricIdClientTimerArray(metricRegistry, new CategoryClientTimerMetricFilter(MetricCategory.METRIC_ID));
            }
            return Metrics.getMetricIdClientTimerArray(metricRegistry, new MetricIdClientTimerFilter(new ArrayList<String>(Arrays.asList(stringArray))));
        }
        throw new IllegalArgumentException("Metric registry must not be null");
    }

    private static List<UrlClientMetricData> computeUrlClientMetricsData(List<UrlClientTimer> list) {
        if (list != null) {
            ArrayList<UrlClientMetricData> arrayList = new ArrayList<UrlClientMetricData>();
            for (UrlClientTimer urlClientTimer : list) {
                TimerMetricData timerMetricData = TimerMetricData.fromTimer(urlClientTimer);
                String string = urlClientTimer.getUrl();
                arrayList.add(new UrlClientMetricData(timerMetricData, string));
            }
            return arrayList;
        }
        return null;
    }

    private static List<UrlAndMethodClientMetricData> computeUrlAndMethodClientMetricsData(List<UrlAndMethodClientTimer> list) {
        if (list != null) {
            ArrayList<UrlAndMethodClientMetricData> arrayList = new ArrayList<UrlAndMethodClientMetricData>();
            for (UrlAndMethodClientTimer urlAndMethodClientTimer : list) {
                TimerMetricData timerMetricData = TimerMetricData.fromTimer(urlAndMethodClientTimer);
                String string = urlAndMethodClientTimer.getUrl();
                String string2 = urlAndMethodClientTimer.getMethod();
                arrayList.add(new UrlAndMethodClientMetricData(timerMetricData, string, string2));
            }
            return arrayList;
        }
        return null;
    }

    private static List<MetricIdClientMetricData> computeMetricIdClientMetricsData(List<MetricIdClientTimer> list) {
        if (list != null) {
            ArrayList<MetricIdClientMetricData> arrayList = new ArrayList<MetricIdClientMetricData>();
            for (MetricIdClientTimer metricIdClientTimer : list) {
                TimerMetricData timerMetricData = TimerMetricData.fromTimer(metricIdClientTimer);
                List<String> list2 = metricIdClientTimer.getMetricId();
                arrayList.add(new MetricIdClientMetricData(timerMetricData, list2));
            }
            return arrayList;
        }
        return null;
    }

    public static ClientMetricDataContainer getClientMetricsData(MetricRegistry metricRegistry) {
        if (metricRegistry != null) {
            ClientTimerContainer clientTimerContainer = Metrics.getClientMetrics(metricRegistry);
            return new ClientMetricDataContainer(Metrics.computeUrlClientMetricsData(clientTimerContainer.getUrlTimers()), Metrics.computeUrlAndMethodClientMetricsData(clientTimerContainer.getUrlAndMethodTimers()), Metrics.computeMetricIdClientMetricsData(clientTimerContainer.getMetricIdTimers()));
        }
        throw new IllegalArgumentException("Metric registry must not be null");
    }

    public static List<UrlClientMetricData> getClientMetricsDataByUrl(MetricRegistry metricRegistry, String string) {
        List<UrlClientTimer> list = Metrics.getClientMetricsByUrl(metricRegistry, string);
        return Metrics.computeUrlClientMetricsData(list);
    }

    public static List<UrlAndMethodClientMetricData> getClientMetricsDataByUrlAndMethod(MetricRegistry metricRegistry, String string, String string2) {
        List<UrlAndMethodClientTimer> list = Metrics.getClientMetricsByUrlAndMethod(metricRegistry, string, string2);
        return Metrics.computeUrlAndMethodClientMetricsData(list);
    }

    public static List<MetricIdClientMetricData> getClientMetricsDataByMetricId(MetricRegistry metricRegistry, String[] stringArray) {
        List<MetricIdClientTimer> list = Metrics.getClientMetricsByMetricId(metricRegistry, stringArray);
        return Metrics.computeMetricIdClientMetricsData(list);
    }

    public static enum MetricCategory {
        URL,
        URL_AND_METHOD,
        METRIC_ID;

    }

    public static enum MetricType {
        FULL_RESPONSE;

    }
}

