/*
 * Decompiled with CFR 0.152.
 */
package com.puppetlabs.http.client;

import com.puppetlabs.http.client.ClientOptions;
import com.puppetlabs.http.client.CompressType;
import com.puppetlabs.http.client.HttpMethod;
import com.puppetlabs.http.client.RequestOptions;
import com.puppetlabs.http.client.Response;
import com.puppetlabs.http.client.ResponseBodyType;
import com.puppetlabs.http.client.SimpleRequestOptions;
import com.puppetlabs.http.client.SyncHttpClient;
import com.puppetlabs.http.client.impl.JavaClient;
import com.puppetlabs.http.client.impl.PersistentSyncHttpClient;
import com.puppetlabs.http.client.metrics.Metrics;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import javax.net.ssl.SSLContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Sync {
    private static final Logger LOGGER = LoggerFactory.getLogger(Sync.class);

    private static RequestOptions extractRequestOptions(SimpleRequestOptions simpleRequestOptions) {
        URI uRI = simpleRequestOptions.getUri();
        Map<String, String> map = simpleRequestOptions.getHeaders();
        Object object = simpleRequestOptions.getBody();
        boolean bl = simpleRequestOptions.getDecompressBody();
        ResponseBodyType responseBodyType = simpleRequestOptions.getAs();
        CompressType compressType = simpleRequestOptions.getCompressRequestBody();
        RequestOptions requestOptions = new RequestOptions(uRI, map, object, bl, responseBodyType);
        requestOptions.setCompressRequestBody(compressType);
        return requestOptions;
    }

    private static ClientOptions extractClientOptions(SimpleRequestOptions simpleRequestOptions) {
        SSLContext sSLContext = simpleRequestOptions.getSslContext();
        String string = simpleRequestOptions.getSslCert();
        String string2 = simpleRequestOptions.getSslKey();
        String string3 = simpleRequestOptions.getSslCaCert();
        String[] stringArray = simpleRequestOptions.getSslProtocols();
        String[] stringArray2 = simpleRequestOptions.getSslCipherSuites();
        boolean bl = simpleRequestOptions.getInsecure();
        boolean bl2 = simpleRequestOptions.getForceRedirects();
        boolean bl3 = simpleRequestOptions.getFollowRedirects();
        int n = simpleRequestOptions.getConnectTimeoutMilliseconds();
        int n2 = simpleRequestOptions.getSocketTimeoutMilliseconds();
        return new ClientOptions(sSLContext, string, string2, string3, stringArray, stringArray2, bl, bl2, bl3, n, n2, 1, 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Response request(SimpleRequestOptions simpleRequestOptions, HttpMethod httpMethod) {
        Response response;
        SyncHttpClient syncHttpClient = Sync.createClient(Sync.extractClientOptions(simpleRequestOptions));
        try {
            response = syncHttpClient.request(Sync.extractRequestOptions(simpleRequestOptions), httpMethod);
        }
        finally {
            try {
                syncHttpClient.close();
            }
            catch (IOException iOException) {
                LOGGER.error("Error closing client", (Throwable)iOException);
            }
        }
        return response;
    }

    public static SyncHttpClient createClient(ClientOptions clientOptions) {
        String string = Metrics.buildMetricNamespace(clientOptions.getMetricPrefix(), clientOptions.getServerId());
        return new PersistentSyncHttpClient(JavaClient.createClient(clientOptions), clientOptions.getMetricRegistry(), string, clientOptions.isEnableURLMetrics());
    }

    public static Response get(String string) throws URISyntaxException {
        return Sync.get(new URI(string));
    }

    public static Response get(URI uRI) {
        return Sync.get(new SimpleRequestOptions(uRI));
    }

    public static Response get(SimpleRequestOptions simpleRequestOptions) {
        return Sync.request(simpleRequestOptions, HttpMethod.GET);
    }

    public static Response head(String string) throws URISyntaxException {
        return Sync.head(new URI(string));
    }

    public static Response head(URI uRI) {
        return Sync.head(new SimpleRequestOptions(uRI));
    }

    public static Response head(SimpleRequestOptions simpleRequestOptions) {
        return Sync.request(simpleRequestOptions, HttpMethod.HEAD);
    }

    public static Response post(String string) throws URISyntaxException {
        return Sync.post(new URI(string));
    }

    public static Response post(URI uRI) {
        return Sync.post(new SimpleRequestOptions(uRI));
    }

    public static Response post(SimpleRequestOptions simpleRequestOptions) {
        return Sync.request(simpleRequestOptions, HttpMethod.POST);
    }

    public static Response put(String string) throws URISyntaxException {
        return Sync.put(new URI(string));
    }

    public static Response put(URI uRI) {
        return Sync.put(new SimpleRequestOptions(uRI));
    }

    public static Response put(SimpleRequestOptions simpleRequestOptions) {
        return Sync.request(simpleRequestOptions, HttpMethod.PUT);
    }

    public static Response delete(String string) throws URISyntaxException {
        return Sync.delete(new URI(string));
    }

    public static Response delete(URI uRI) {
        return Sync.delete(new SimpleRequestOptions(uRI));
    }

    public static Response delete(SimpleRequestOptions simpleRequestOptions) {
        return Sync.request(simpleRequestOptions, HttpMethod.DELETE);
    }

    public static Response trace(String string) throws URISyntaxException {
        return Sync.trace(new URI(string));
    }

    public static Response trace(URI uRI) {
        return Sync.trace(new SimpleRequestOptions(uRI));
    }

    public static Response trace(SimpleRequestOptions simpleRequestOptions) {
        return Sync.request(simpleRequestOptions, HttpMethod.TRACE);
    }

    public static Response options(String string) throws URISyntaxException {
        return Sync.options(new URI(string));
    }

    public static Response options(URI uRI) {
        return Sync.options(new SimpleRequestOptions(uRI));
    }

    public static Response options(SimpleRequestOptions simpleRequestOptions) {
        return Sync.request(simpleRequestOptions, HttpMethod.OPTIONS);
    }

    public static Response patch(String string) throws URISyntaxException {
        return Sync.patch(new URI(string));
    }

    public static Response patch(URI uRI) {
        return Sync.patch(new SimpleRequestOptions(uRI));
    }

    public static Response patch(SimpleRequestOptions simpleRequestOptions) {
        return Sync.request(simpleRequestOptions, HttpMethod.PATCH);
    }
}

