/*
 * Decompiled with CFR 0.152.
 */
package com.puppetlabs.http.client.impl.metrics;

import com.puppetlabs.http.client.metrics.ClientTimer;
import java.util.concurrent.TimeUnit;

public class TimerMetricData {
    private final String metricName;
    private final Long meanMillis;
    private final Long count;
    private final Long aggregate;

    public static TimerMetricData fromTimer(ClientTimer clientTimer) {
        Double d = clientTimer.getSnapshot().getMean();
        Long l = clientTimer.getCount();
        Long l2 = TimeUnit.NANOSECONDS.toMillis(d.longValue());
        return new TimerMetricData(clientTimer.getMetricName(), l2, l, l * l2);
    }

    public TimerMetricData(String string, Long l, Long l2, Long l3) {
        this.metricName = string;
        this.meanMillis = l;
        this.count = l2;
        this.aggregate = l3;
    }

    public String getMetricName() {
        return this.metricName;
    }

    public Long getMeanMillis() {
        return this.meanMillis;
    }

    public Long getCount() {
        return this.count;
    }

    public Long getAggregate() {
        return this.aggregate;
    }
}

