/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.query.parser.sparql;

import java.util.LinkedHashSet;
import java.util.Set;
import org.openrdf.query.MalformedQueryException;
import org.openrdf.query.parser.sparql.ASTVisitorBase;
import org.openrdf.query.parser.sparql.ast.ASTCount;
import org.openrdf.query.parser.sparql.ast.ASTQueryContainer;
import org.openrdf.query.parser.sparql.ast.ASTVar;
import org.openrdf.query.parser.sparql.ast.VisitorException;

public class WildcardCountProcessor
extends ASTVisitorBase {
    private static QueryVariableCollector collector;

    public static void process(ASTQueryContainer qc) throws MalformedQueryException {
        try {
            collector = new QueryVariableCollector();
            qc.jjtAccept(collector, null);
            CountVisitor visitor = new CountVisitor();
            qc.jjtAccept(visitor, null);
        }
        catch (VisitorException e) {
            throw new MalformedQueryException(e);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class QueryVariableCollector
    extends ASTVisitorBase {
        private Set<ASTVar> variables = new LinkedHashSet<ASTVar>();

        private QueryVariableCollector() {
        }

        public Set<ASTVar> getVariables() {
            return this.variables;
        }

        @Override
        public Object visit(ASTVar node, Object data) throws VisitorException {
            if (!node.isAnonymous()) {
                this.variables.add(node);
            }
            return super.visit(node, data);
        }
    }

    private static class CountVisitor
    extends ASTVisitorBase {
        private CountVisitor() {
        }

        private void addQueryVars(ASTCount node) throws VisitorException {
            if (node.isWildcard()) {
                for (ASTVar var : collector.getVariables()) {
                    node.jjtAppendChild(var);
                }
                node.setWildcard(false);
            }
        }

        public Object visit(ASTCount node, Object data) throws VisitorException {
            this.addQueryVars(node);
            return super.visit(node, data);
        }
    }
}

