/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.query.parser.sparql;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Map;
import org.openrdf.model.impl.ValueFactoryImpl;
import org.openrdf.query.Dataset;
import org.openrdf.query.MalformedQueryException;
import org.openrdf.query.algebra.TupleExpr;
import org.openrdf.query.parser.ParsedBooleanQuery;
import org.openrdf.query.parser.ParsedGraphQuery;
import org.openrdf.query.parser.ParsedQuery;
import org.openrdf.query.parser.ParsedTupleQuery;
import org.openrdf.query.parser.QueryParser;
import org.openrdf.query.parser.sparql.BaseDeclProcessor;
import org.openrdf.query.parser.sparql.BlankNodeVarProcessor;
import org.openrdf.query.parser.sparql.DatasetDeclProcessor;
import org.openrdf.query.parser.sparql.PrefixDeclProcessor;
import org.openrdf.query.parser.sparql.StringEscapesProcessor;
import org.openrdf.query.parser.sparql.TupleExprBuilder;
import org.openrdf.query.parser.sparql.WildcardProjectionProcessor;
import org.openrdf.query.parser.sparql.ast.ASTAskQuery;
import org.openrdf.query.parser.sparql.ast.ASTConstructQuery;
import org.openrdf.query.parser.sparql.ast.ASTDescribeQuery;
import org.openrdf.query.parser.sparql.ast.ASTQuery;
import org.openrdf.query.parser.sparql.ast.ASTQueryContainer;
import org.openrdf.query.parser.sparql.ast.ASTSelectQuery;
import org.openrdf.query.parser.sparql.ast.ParseException;
import org.openrdf.query.parser.sparql.ast.SyntaxTreeBuilder;
import org.openrdf.query.parser.sparql.ast.TokenMgrError;
import org.openrdf.query.parser.sparql.ast.VisitorException;

public class SPARQLParser
implements QueryParser {
    public ParsedQuery parseQuery(String queryStr, String baseURI) throws MalformedQueryException {
        try {
            ParsedQuery query;
            ASTQueryContainer qc = SyntaxTreeBuilder.parseQuery(queryStr);
            StringEscapesProcessor.process(qc);
            BaseDeclProcessor.process(qc, baseURI);
            Map<String, String> prefixes = PrefixDeclProcessor.process(qc);
            WildcardProjectionProcessor.process(qc);
            BlankNodeVarProcessor.process(qc);
            TupleExpr tupleExpr = this.buildQueryModel(qc);
            ASTQuery queryNode = qc.getQuery();
            if (queryNode instanceof ASTSelectQuery) {
                query = new ParsedTupleQuery(tupleExpr);
            } else if (queryNode instanceof ASTConstructQuery) {
                query = new ParsedGraphQuery(tupleExpr, prefixes);
            } else if (queryNode instanceof ASTAskQuery) {
                query = new ParsedBooleanQuery(tupleExpr);
            } else if (queryNode instanceof ASTDescribeQuery) {
                query = new ParsedGraphQuery(tupleExpr, prefixes);
            } else {
                throw new RuntimeException("Unexpected query type: " + queryNode.getClass());
            }
            Dataset dataset = DatasetDeclProcessor.process(qc);
            if (dataset != null) {
                query.setDataset(dataset);
            }
            return query;
        }
        catch (ParseException e) {
            throw new MalformedQueryException(e.getMessage(), e);
        }
        catch (TokenMgrError e) {
            throw new MalformedQueryException(e.getMessage(), e);
        }
    }

    private TupleExpr buildQueryModel(ASTQueryContainer qc) throws MalformedQueryException {
        TupleExprBuilder tupleExprBuilder = new TupleExprBuilder(new ValueFactoryImpl());
        try {
            return (TupleExpr)qc.jjtAccept(tupleExprBuilder, null);
        }
        catch (VisitorException e) {
            throw new MalformedQueryException(e.getMessage(), e);
        }
    }

    public static void main(String[] args) throws IOException {
        System.out.println("Your SPARQL query:");
        BufferedReader in = new BufferedReader(new InputStreamReader(System.in));
        StringBuilder buf = new StringBuilder();
        String line = null;
        while ((line = in.readLine()) != null) {
            if (line.length() > 0) {
                buf.append(' ').append(line).append('\n');
                continue;
            }
            String queryStr = buf.toString().trim();
            if (queryStr.length() > 0) {
                try {
                    SPARQLParser parser = new SPARQLParser();
                    ParsedQuery parsedQuery = parser.parseQuery(queryStr, null);
                    System.out.println("Parsed query: ");
                    System.out.println(parsedQuery.toString());
                    System.out.println();
                }
                catch (Exception e) {
                    System.err.println(e.getMessage());
                    e.printStackTrace();
                }
            }
            buf.setLength(0);
        }
    }
}

