/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.query.algebra.evaluation.iterator;

import info.aduna.collections.iterators.EmptyIterator;
import info.aduna.iteration.CloseableIteration;
import info.aduna.iteration.DelayedIteration;
import info.aduna.iteration.Iteration;
import info.aduna.iteration.LookAheadIteration;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.TreeMap;
import org.openrdf.query.BindingSet;
import org.openrdf.query.QueryEvaluationException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OrderIterator
extends DelayedIteration<BindingSet, QueryEvaluationException> {
    private final CloseableIteration<BindingSet, QueryEvaluationException> iter;
    private final Comparator<BindingSet> comparator;
    private final long limit;
    private final boolean distinct;

    public OrderIterator(CloseableIteration<BindingSet, QueryEvaluationException> iter, Comparator<BindingSet> comparator) {
        this(iter, comparator, Integer.MAX_VALUE, false);
    }

    public OrderIterator(CloseableIteration<BindingSet, QueryEvaluationException> iter, Comparator<BindingSet> comparator, long limit, boolean distinct) {
        this.iter = iter;
        this.comparator = comparator;
        this.limit = limit;
        this.distinct = distinct;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Iteration<BindingSet, QueryEvaluationException> createIteration() throws QueryEvaluationException {
        TreeMap<BindingSet, LinkedHashSet<BindingSet>> map = new TreeMap<BindingSet, LinkedHashSet<BindingSet>>(this.comparator);
        int size = 0;
        try {
            while (this.iter.hasNext()) {
                BindingSet next = (BindingSet)this.iter.next();
                if ((long)size >= this.limit && this.comparator.compare(next, map.lastKey()) >= 0) continue;
                LinkedHashSet<BindingSet> list = (LinkedHashSet<BindingSet>)map.get(next);
                if (list == null) {
                    list = this.distinct ? new LinkedHashSet() : new LinkedList();
                    map.put(next, list);
                }
                if (list.add(next)) {
                    ++size;
                }
                if ((long)size <= this.limit) continue;
                BindingSet lastKey = map.lastKey();
                Collection lastResults = (Collection)map.get(lastKey);
                assert (!lastResults.isEmpty());
                if (lastResults instanceof LinkedList) {
                    ((LinkedList)lastResults).removeLast();
                } else {
                    Iterator iter = lastResults.iterator();
                    while (iter.hasNext()) {
                        iter.next();
                    }
                    iter.remove();
                }
                --size;
                if (!lastResults.isEmpty()) continue;
                map.remove(lastKey);
            }
        }
        finally {
            this.iter.close();
        }
        final Iterator values = map.values().iterator();
        return new LookAheadIteration<BindingSet, QueryEvaluationException>(){
            private volatile Iterator<BindingSet> iterator = new EmptyIterator<BindingSet>();

            @Override
            protected BindingSet getNextElement() {
                while (!this.iterator.hasNext() && values.hasNext()) {
                    this.iterator = ((Collection)values.next()).iterator();
                }
                if (this.iterator.hasNext()) {
                    return this.iterator.next();
                }
                return null;
            }
        };
    }

    @Override
    public void remove() throws QueryEvaluationException {
        throw new UnsupportedOperationException();
    }

    @Override
    protected void handleClose() throws QueryEvaluationException {
        this.iter.close();
        super.handleClose();
    }
}

