/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.query.algebra;

import info.aduna.collections.iterators.Iterators;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.openrdf.query.algebra.GroupElem;
import org.openrdf.query.algebra.QueryModelNode;
import org.openrdf.query.algebra.QueryModelVisitor;
import org.openrdf.query.algebra.TupleExpr;
import org.openrdf.query.algebra.UnaryTupleOperator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Group
extends UnaryTupleOperator {
    private Set<String> groupBindings = new LinkedHashSet<String>();
    private List<GroupElem> groupElements = new ArrayList<GroupElem>();

    public Group(TupleExpr arg) {
        super(arg);
    }

    public Group(TupleExpr arg, Iterable<String> groupBindingNames) {
        this(arg);
        this.setGroupBindingNames(groupBindingNames);
    }

    public Group(TupleExpr arg, Iterable<String> groupBindingNames, Iterable<GroupElem> groupElements) {
        this(arg, groupBindingNames);
        this.setGroupElements(groupElements);
    }

    public Set<String> getGroupBindingNames() {
        return Collections.unmodifiableSet(this.groupBindings);
    }

    public void addGroupBindingName(String bindingName) {
        this.groupBindings.add(bindingName);
    }

    public void setGroupBindingNames(Iterable<String> bindingNames) {
        this.groupBindings.clear();
        Iterators.addAll(bindingNames.iterator(), this.groupBindings);
    }

    public List<GroupElem> getGroupElements() {
        return Collections.unmodifiableList(this.groupElements);
    }

    public void addGroupElement(GroupElem groupElem) {
        this.groupElements.add(groupElem);
    }

    public void setGroupElements(Iterable<GroupElem> elements) {
        this.groupElements.clear();
        Iterators.addAll(elements.iterator(), this.groupElements);
    }

    public Set<String> getAggregateBindingNames() {
        HashSet<String> bindings = new HashSet<String>();
        for (GroupElem binding : this.groupElements) {
            bindings.add(binding.getName());
        }
        return bindings;
    }

    @Override
    public Set<String> getBindingNames() {
        LinkedHashSet<String> bindingNames = new LinkedHashSet<String>();
        bindingNames.addAll(this.getGroupBindingNames());
        bindingNames.addAll(this.getAggregateBindingNames());
        return bindingNames;
    }

    @Override
    public Set<String> getAssuredBindingNames() {
        LinkedHashSet<String> bindingNames = new LinkedHashSet<String>();
        bindingNames.addAll(this.getGroupBindingNames());
        bindingNames.retainAll(this.getArg().getAssuredBindingNames());
        return bindingNames;
    }

    @Override
    public <X extends Exception> void visit(QueryModelVisitor<X> visitor) throws X {
        visitor.meet(this);
    }

    @Override
    public <X extends Exception> void visitChildren(QueryModelVisitor<X> visitor) throws X {
        super.visitChildren(visitor);
        for (GroupElem ge : this.groupElements) {
            ge.visit(visitor);
        }
    }

    @Override
    public void replaceChildNode(QueryModelNode current, QueryModelNode replacement) {
        if (this.replaceNodeInList(this.groupElements, current, replacement)) {
            return;
        }
        super.replaceChildNode(current, replacement);
    }

    @Override
    public boolean equals(Object other) {
        if (other instanceof Group && super.equals(other)) {
            Group o = (Group)other;
            return ((Object)this.groupBindings).equals(o.getGroupBindingNames()) && ((Object)this.groupElements).equals(o.getGroupElements());
        }
        return false;
    }

    @Override
    public int hashCode() {
        return super.hashCode() ^ ((Object)this.groupBindings).hashCode() ^ ((Object)this.groupElements).hashCode();
    }

    @Override
    public Group clone() {
        Group clone = (Group)super.clone();
        clone.groupBindings = new LinkedHashSet<String>(this.getGroupBindingNames());
        clone.groupElements = new ArrayList<GroupElem>(this.getGroupElements().size());
        for (GroupElem ge : this.getGroupElements()) {
            clone.addGroupElement(ge.clone());
        }
        return clone;
    }
}

