/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.query;

import info.aduna.iteration.Iterations;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.openrdf.model.BNode;
import org.openrdf.model.Statement;
import org.openrdf.model.Value;
import org.openrdf.model.util.ModelUtil;
import org.openrdf.query.Binding;
import org.openrdf.query.BindingSet;
import org.openrdf.query.GraphQueryResult;
import org.openrdf.query.QueryEvaluationException;
import org.openrdf.query.TupleQueryResult;
import org.openrdf.query.TupleQueryResultHandler;
import org.openrdf.query.TupleQueryResultHandlerException;
import org.openrdf.rio.RDFHandler;
import org.openrdf.rio.RDFHandlerException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QueryResultUtil {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void report(TupleQueryResult tqr, TupleQueryResultHandler handler) throws TupleQueryResultHandlerException, QueryEvaluationException {
        handler.startQueryResult(tqr.getBindingNames());
        try {
            while (tqr.hasNext()) {
                BindingSet bindingSet = (BindingSet)tqr.next();
                handler.handleSolution(bindingSet);
            }
        }
        finally {
            tqr.close();
        }
        handler.endQueryResult();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void report(GraphQueryResult gqr, RDFHandler rdfHandler) throws RDFHandlerException, QueryEvaluationException {
        try {
            rdfHandler.startRDF();
            for (Map.Entry<String, String> entry : gqr.getNamespaces().entrySet()) {
                String prefix = entry.getKey();
                String namespace = entry.getValue();
                rdfHandler.handleNamespace(prefix, namespace);
            }
            while (gqr.hasNext()) {
                Statement st = (Statement)gqr.next();
                rdfHandler.handleStatement(st);
            }
            rdfHandler.endRDF();
        }
        finally {
            gqr.close();
        }
    }

    public static boolean equals(TupleQueryResult tqr1, TupleQueryResult tqr2) throws QueryEvaluationException {
        List<BindingSet> list1 = Iterations.asList(tqr1);
        List<BindingSet> list2 = Iterations.asList(tqr2);
        if (list1.size() != list2.size()) {
            return false;
        }
        return QueryResultUtil.matchBindingSets(list1, list2);
    }

    public static boolean isSubset(TupleQueryResult tqr1, TupleQueryResult tqr2) throws QueryEvaluationException {
        List<BindingSet> list1 = Iterations.asList(tqr1);
        List<BindingSet> list2 = Iterations.asList(tqr2);
        if (list1.size() > list2.size()) {
            return false;
        }
        return QueryResultUtil.matchBindingSets(list1, list2);
    }

    public static boolean equals(GraphQueryResult result1, GraphQueryResult result2) throws QueryEvaluationException {
        Set<Statement> graph1 = Iterations.asSet(result1);
        Set<Statement> graph2 = Iterations.asSet(result1);
        return ModelUtil.equals(graph1, graph2);
    }

    private static boolean matchBindingSets(List<? extends BindingSet> queryResult1, Iterable<? extends BindingSet> queryResult2) {
        return QueryResultUtil.matchBindingSets(queryResult1, queryResult2, new HashMap<BNode, BNode>(), 0);
    }

    private static boolean matchBindingSets(List<? extends BindingSet> queryResult1, Iterable<? extends BindingSet> queryResult2, Map<BNode, BNode> bNodeMapping, int idx) {
        boolean result = false;
        if (idx < queryResult1.size()) {
            BindingSet bs1 = queryResult1.get(idx);
            List<BindingSet> matchingBindingSets = QueryResultUtil.findMatchingBindingSets(bs1, queryResult2, bNodeMapping);
            for (BindingSet bs2 : matchingBindingSets) {
                HashMap<BNode, BNode> newBNodeMapping = new HashMap<BNode, BNode>(bNodeMapping);
                for (Binding binding : bs1) {
                    if (!(binding.getValue() instanceof BNode)) continue;
                    newBNodeMapping.put((BNode)binding.getValue(), (BNode)bs2.getValue(binding.getName()));
                }
                result = QueryResultUtil.matchBindingSets(queryResult1, queryResult2, newBNodeMapping, idx + 1);
                if (!result) continue;
                break;
            }
        } else {
            result = true;
        }
        return result;
    }

    private static List<BindingSet> findMatchingBindingSets(BindingSet st, Iterable<? extends BindingSet> model, Map<BNode, BNode> bNodeMapping) {
        ArrayList<BindingSet> result = new ArrayList<BindingSet>();
        for (BindingSet bindingSet : model) {
            if (!QueryResultUtil.bindingSetsMatch(st, bindingSet, bNodeMapping)) continue;
            result.add(bindingSet);
        }
        return result;
    }

    private static boolean bindingSetsMatch(BindingSet bs1, BindingSet bs2, Map<BNode, BNode> bNodeMapping) {
        for (Binding binding1 : bs1) {
            BNode mappedBNode;
            Value value1 = binding1.getValue();
            Value value2 = bs2.getValue(binding1.getName());
            if (!(value1 instanceof BNode && value2 instanceof BNode ? ((mappedBNode = bNodeMapping.get(value1)) != null ? !value2.equals(mappedBNode) : bNodeMapping.containsValue(value2)) : !value1.equals(value2))) continue;
            return false;
        }
        return true;
    }

    public static boolean bindingSetsCompatible(BindingSet bs1, BindingSet bs2) {
        HashSet<String> sharedBindings = new HashSet<String>(bs1.getBindingNames());
        sharedBindings.retainAll(bs2.getBindingNames());
        for (String bindingName : sharedBindings) {
            Value value2;
            Value value1 = bs1.getValue(bindingName);
            if (value1.equals(value2 = bs2.getValue(bindingName))) continue;
            return false;
        }
        return true;
    }
}

