/*
 * Decompiled with CFR 0.152.
 */
package info.aduna.collections.iterators;

import info.aduna.collections.iterators.IteratorWrapper;
import java.util.Iterator;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LimitIterator<E>
extends IteratorWrapper<E> {
    private final int limit;
    private int returnCount;

    public LimitIterator(Iterator<? extends E> iter, int limit) {
        super(iter);
        assert (limit >= 0);
        this.limit = limit;
        this.returnCount = 0;
    }

    @Override
    public boolean hasNext() {
        return this.returnCount < this.limit && super.hasNext();
    }

    @Override
    public E next() {
        if (this.returnCount >= this.limit) {
            throw new NoSuchElementException("limit reached");
        }
        ++this.returnCount;
        return super.next();
    }
}

