/*
 * Decompiled with CFR 0.152.
 */
package info.aduna.collections.iterators;

import info.aduna.collections.iterators.FilterIterator;
import info.aduna.collections.iterators.Iterators;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IntersectIterator<E>
extends FilterIterator<E> {
    private final Iterator<? extends E> arg2;
    private final boolean distinct;
    private boolean initialized;
    private Set<E> includeSet;

    public IntersectIterator(Iterator<? extends E> arg1, Iterator<? extends E> arg2) {
        this(arg1, arg2, false);
    }

    public IntersectIterator(Iterator<? extends E> arg1, Iterator<? extends E> arg2, boolean distinct) {
        super(arg1);
        assert (arg2 != null);
        this.arg2 = arg2;
        this.distinct = distinct;
        this.initialized = false;
    }

    @Override
    protected boolean accept(E object) {
        if (!this.initialized) {
            this.includeSet = Iterators.addAll(this.arg2, new HashSet());
            this.initialized = true;
        }
        if (this.includeSet.contains(object)) {
            if (this.distinct) {
                this.includeSet.remove(object);
            }
            return true;
        }
        return false;
    }

    @Override
    protected void handleClose() {
        super.handleClose();
        Iterators.closeCloseable(this.arg2);
    }
}

