/*
 * Decompiled with CFR 0.152.
 */
package info.aduna.collections.iterators;

import info.aduna.collections.iterators.CloseableIteratorBase;
import info.aduna.collections.iterators.Iterators;
import java.util.Iterator;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DelayedIterator<E>
extends CloseableIteratorBase<E> {
    private Iterator<? extends E> iter;

    protected abstract Iterator<? extends E> createIterator();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasNext() {
        if (this.iter == null) {
            DelayedIterator delayedIterator = this;
            synchronized (delayedIterator) {
                if (this.isClosed()) {
                    return false;
                }
                this.iter = this.createIterator();
            }
        }
        return this.iter.hasNext();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public E next() {
        if (this.iter == null) {
            DelayedIterator delayedIterator = this;
            synchronized (delayedIterator) {
                if (this.isClosed()) {
                    throw new NoSuchElementException("Iterator has been closed");
                }
                this.iter = this.createIterator();
            }
        }
        return this.iter.next();
    }

    @Override
    public void remove() {
        if (this.iter == null || this.isClosed()) {
            throw new IllegalStateException();
        }
        this.iter.remove();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void handleClose() {
        super.handleClose();
        DelayedIterator delayedIterator = this;
        synchronized (delayedIterator) {
            Iterators.closeCloseable(this.iter);
        }
    }
}

