(ns ^:no-doc onyx.messaging.common
  (:require [onyx.messaging.aeron :refer [aeron aeron-peer-group]] 
            [taoensso.timbre :refer [fatal]]))

(defn my-remote-ip []
  (apply str (butlast (slurp "http://checkip.amazonaws.com"))))

(defn bind-addr [peer-config]
  (:onyx.messaging/bind-addr peer-config))

(defn external-addr [peer-config]
  (or (:onyx.messaging/external-addr peer-config)
      (bind-addr peer-config)))

(defmulti messaging-require :onyx.messaging/impl)

(defmulti messenger :onyx.messaging/impl)

(defmulti messaging-peer-group :onyx.messaging/impl)

(defn safe-require [sym]
  (try (require sym)
       (catch Throwable e
         (fatal e
                (str "Error loading messaging. "
                     "If your peer is AOT compiled you will need to manually require " sym))
         (throw e))))

(defmethod messaging-require :aeron [_])

(defmethod messenger :aeron [_]
  aeron)

(defmethod messaging-peer-group :aeron [_]
  aeron-peer-group)
