/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.util;

import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.jgroups.util.SeqnoList;
import org.jgroups.util.Tuple;

public class Table<T> {
    protected final int num_rows;
    protected final int elements_per_row;
    protected final double resize_factor;
    protected T[][] matrix;
    protected long offset;
    protected int size;
    protected long low;
    protected long hr;
    protected long hd;
    protected long max_compaction_time = TimeUnit.NANOSECONDS.convert(10000L, TimeUnit.MILLISECONDS);
    protected long last_compaction_timestamp = 0L;
    protected final Lock lock = new ReentrantLock();
    protected final AtomicBoolean processing = new AtomicBoolean(false);
    protected int num_compactions = 0;
    protected int num_resizes = 0;
    protected int num_moves = 0;
    protected int num_purges = 0;
    protected static final long DEFAULT_MAX_COMPACTION_TIME = 10000L;
    protected static final double DEFAULT_RESIZE_FACTOR = 1.2;

    public Table() {
        this(5, 10000, 0L, 1.2);
    }

    public Table(long offset) {
        this();
        this.offset = offset;
    }

    public Table(int num_rows, int elements_per_row, long offset) {
        this(num_rows, elements_per_row, offset, 1.2);
    }

    public Table(int num_rows, int elements_per_row, long offset, double resize_factor) {
        this(num_rows, elements_per_row, offset, resize_factor, 10000L);
    }

    public Table(int num_rows, int elements_per_row, long offset, double resize_factor, long max_compaction_time) {
        this.num_rows = num_rows;
        this.elements_per_row = elements_per_row;
        this.resize_factor = resize_factor;
        this.max_compaction_time = TimeUnit.NANOSECONDS.convert(max_compaction_time, TimeUnit.MILLISECONDS);
        this.hr = this.hd = offset;
        this.low = this.hd;
        this.offset = this.hd;
        this.matrix = new Object[num_rows][];
        if (resize_factor <= 1.0) {
            throw new IllegalArgumentException("resize_factor needs to be > 1");
        }
    }

    public AtomicBoolean getProcessing() {
        return this.processing;
    }

    public long getOffset() {
        return this.offset;
    }

    public int capacity() {
        return this.matrix.length * this.elements_per_row;
    }

    public int getNumCompactions() {
        return this.num_compactions;
    }

    public int getNumMoves() {
        return this.num_moves;
    }

    public int getNumResizes() {
        return this.num_resizes;
    }

    public int getNumPurges() {
        return this.num_purges;
    }

    public int size() {
        return this.size;
    }

    public boolean isEmpty() {
        return this.size <= 0;
    }

    public long getLow() {
        return this.low;
    }

    public long getHighestDelivered() {
        return this.hd;
    }

    public long getHighestReceived() {
        return this.hr;
    }

    public long getMaxCompactionTime() {
        return this.max_compaction_time;
    }

    public void setMaxCompactionTime(long max_compaction_time) {
        this.max_compaction_time = TimeUnit.NANOSECONDS.convert(max_compaction_time, TimeUnit.MILLISECONDS);
    }

    public int getNumRows() {
        return this.matrix.length;
    }

    public void resetStats() {
        this.num_purges = 0;
        this.num_resizes = 0;
        this.num_moves = 0;
        this.num_compactions = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setHighestDelivered(long seqno) {
        this.lock.lock();
        try {
            this.hd = seqno;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean add(long seqno, T element) {
        this.lock.lock();
        try {
            boolean bl = this._add(seqno, element);
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean add(List<Tuple<Long, T>> elements) {
        if (elements == null) {
            return false;
        }
        boolean added = false;
        this.lock.lock();
        try {
            for (Tuple<Long, T> tuple : elements) {
                T element;
                long seqno = tuple.getVal1();
                if (!this._add(seqno, element = tuple.getVal2())) continue;
                added = true;
            }
        }
        finally {
            this.lock.unlock();
        }
        return added;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T get(long seqno) {
        this.lock.lock();
        try {
            if (seqno <= this.low || seqno > this.hr) {
                T t = null;
                return t;
            }
            int row_index = this.computeRow(seqno);
            if (row_index < 0 || row_index >= this.matrix.length) {
                T t = null;
                return t;
            }
            T[] row = this.matrix[row_index];
            if (row == null) {
                T t = null;
                return t;
            }
            int index = this.computeIndex(seqno);
            T t = index >= 0 ? (T)row[index] : null;
            return t;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T _get(long seqno) {
        this.lock.lock();
        try {
            int row_index = this.computeRow(seqno);
            if (row_index < 0 || row_index >= this.matrix.length) {
                T t = null;
                return t;
            }
            T[] row = this.matrix[row_index];
            if (row == null) {
                T t = null;
                return t;
            }
            int index = this.computeIndex(seqno);
            T t = index >= 0 ? (T)row[index] : null;
            return t;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<T> get(long from, long to) {
        this.lock.lock();
        try {
            if (from <= this.low) {
                from = this.low + 1L;
            }
            if (to > this.hr) {
                to = this.hr;
            }
            Getter getter = new Getter();
            this.forEach(from, to, getter);
            List list = getter.getList();
            return list;
        }
        finally {
            this.lock.unlock();
        }
    }

    public T remove() {
        return this.remove(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T remove(boolean nullify) {
        this.lock.lock();
        try {
            int row_index = this.computeRow(this.hd + 1L);
            if (row_index < 0 || row_index >= this.matrix.length) {
                T t = null;
                return t;
            }
            T[] row = this.matrix[row_index];
            if (row == null) {
                T t = null;
                return t;
            }
            int index = this.computeIndex(this.hd + 1L);
            if (index < 0) {
                T t = null;
                return t;
            }
            T existing_element = row[index];
            if (existing_element != null) {
                ++this.hd;
                this.size = Math.max(this.size - 1, 0);
                if (nullify) {
                    row[index] = null;
                    if (this.hd > this.low) {
                        this.low = this.hd;
                    }
                }
            }
            T t = existing_element;
            return t;
        }
        finally {
            this.lock.unlock();
        }
    }

    public List<T> removeMany(boolean nullify, int max_results) {
        return this.removeMany(null, nullify, max_results);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<T> removeMany(AtomicBoolean processing, boolean nullify, int max_results) {
        this.lock.lock();
        try {
            Remover remover = new Remover(nullify, max_results);
            this.forEach(this.hd + 1L, this.hr, remover);
            List retval = remover.getList();
            if (processing != null && (retval == null || retval.isEmpty())) {
                processing.set(false);
            }
            List list = retval;
            return list;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void purge(long seqno) {
        this.purge(seqno, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void purge(long seqno, boolean force) {
        this.lock.lock();
        try {
            if (force) {
                if (seqno > this.hr) {
                    seqno = this.hr;
                }
            } else if (seqno > this.hd) {
                seqno = this.hd;
            }
            int start_row = this.computeRow(this.low);
            int end_row = this.computeRow(seqno);
            if (start_row < 0) {
                start_row = 0;
            }
            if (end_row < 0) {
                return;
            }
            for (int i = start_row; i < end_row; ++i) {
                this.matrix[i] = null;
            }
            if (this.matrix[end_row] != null) {
                int index = this.computeIndex(seqno);
                for (int i = 0; i <= index; ++i) {
                    this.matrix[end_row][i] = null;
                }
            }
            if (seqno > this.low) {
                this.low = seqno;
            }
            if (force) {
                this.low = this.hd = seqno;
                this.size = this.computeSize();
            }
            ++this.num_purges;
            if (this.max_compaction_time <= 0L) {
                return;
            }
            long current_time = System.nanoTime();
            if (this.last_compaction_timestamp > 0L) {
                if (current_time - this.last_compaction_timestamp >= this.max_compaction_time) {
                    this._compact();
                    this.last_compaction_timestamp = current_time;
                }
            } else {
                this.last_compaction_timestamp = current_time;
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void compact() {
        this.lock.lock();
        try {
            this._compact();
        }
        finally {
            this.lock.unlock();
        }
    }

    public void forEach(long from, long to, Visitor<T> visitor) {
        int row = this.computeRow(from);
        int column = this.computeIndex(from);
        int distance = (int)(to - from + 1L);
        T[] current_row = row + 1 > this.matrix.length ? null : this.matrix[row];
        for (int i = 0; i < distance; ++i) {
            Object element;
            Object t = element = current_row == null ? null : (Object)current_row[column];
            if (!visitor.visit(from, element, row, column)) break;
            ++from;
            if (++column < this.elements_per_row) continue;
            column = 0;
            current_row = ++row + 1 > this.matrix.length ? null : this.matrix[row];
        }
    }

    protected boolean _add(long seqno, T element) {
        int index;
        T[] row;
        T existing_element;
        if (seqno <= this.hd) {
            return false;
        }
        int row_index = this.computeRow(seqno);
        if (row_index >= this.matrix.length) {
            this.resize(seqno);
            row_index = this.computeRow(seqno);
        }
        if ((existing_element = (row = this.getRow(row_index))[index = this.computeIndex(seqno)]) == null) {
            row[index] = element;
            ++this.size;
            if (seqno > this.hr) {
                this.hr = seqno;
            }
            return true;
        }
        return false;
    }

    protected void resize(long seqno) {
        int num_rows_to_purge = this.computeRow(this.low);
        int row_index = this.computeRow(seqno) - num_rows_to_purge;
        if (row_index < 0) {
            return;
        }
        int new_size = Math.max(row_index + 1, this.matrix.length);
        if (new_size > this.matrix.length) {
            Object[][] new_matrix = new Object[new_size][];
            System.arraycopy(this.matrix, num_rows_to_purge, new_matrix, 0, this.matrix.length - num_rows_to_purge);
            this.matrix = new_matrix;
            ++this.num_resizes;
        } else if (num_rows_to_purge > 0) {
            this.move(num_rows_to_purge);
        }
        this.offset += (long)(num_rows_to_purge * this.elements_per_row);
    }

    protected void move(int num_rows) {
        int i;
        if (num_rows <= 0 || num_rows > this.matrix.length) {
            return;
        }
        int target_index = 0;
        for (i = num_rows; i < this.matrix.length; ++i) {
            this.matrix[target_index++] = this.matrix[i];
        }
        for (i = this.matrix.length - num_rows; i < this.matrix.length; ++i) {
            this.matrix[i] = null;
        }
        ++this.num_moves;
    }

    protected void _compact() {
        int from = this.computeRow(this.low);
        int to = this.computeRow(this.hr);
        int range = to - from + 1;
        int new_size = (int)Math.max((double)range * this.resize_factor, (double)(range + 1));
        if ((new_size = Math.max(new_size, this.num_rows)) < this.matrix.length) {
            Object[][] new_matrix = new Object[new_size][];
            System.arraycopy(this.matrix, from, new_matrix, 0, range);
            this.matrix = new_matrix;
            this.offset += (long)(from * this.elements_per_row);
            ++this.num_compactions;
        }
    }

    public int computeSize() {
        Counter non_null_counter = new Counter();
        this.forEach(this.hd + 1L, this.hr, non_null_counter);
        return non_null_counter.getResult();
    }

    public int getNumMissing() {
        return (int)(this.hr - this.hd - (long)this.size);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SeqnoList getMissing() {
        this.lock.lock();
        try {
            Missing missing = new Missing();
            this.forEach(this.hd + 1L, this.hr, missing);
            SeqnoList seqnoList = missing.getMissingElements();
            return seqnoList;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long[] getDigest() {
        this.lock.lock();
        try {
            long[] lArray = new long[]{this.hd, this.hr};
            return lArray;
        }
        finally {
            this.lock.unlock();
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("[" + this.low + " | " + this.hd + " | " + this.hr + "] (" + this.size() + " elements, " + this.getNumMissing() + " missing)");
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String dump() {
        this.lock.lock();
        try {
            Dump dump = new Dump();
            this.forEach(this.low, this.hr, dump);
            String string = dump.getResult();
            return string;
        }
        finally {
            this.lock.unlock();
        }
    }

    protected T[] getRow(int index) {
        Object[] row = this.matrix[index];
        if (row == null) {
            row = new Object[this.elements_per_row];
            this.matrix[index] = row;
        }
        return row;
    }

    protected int computeRow(long seqno) {
        int diff = (int)(seqno - this.offset);
        if (diff < 0) {
            return diff;
        }
        return diff / this.elements_per_row;
    }

    protected int computeIndex(long seqno) {
        int diff = (int)(seqno - this.offset);
        if (diff < 0) {
            return diff;
        }
        return diff % this.elements_per_row;
    }

    protected class Missing
    implements Visitor<T> {
        protected SeqnoList missing_elements;
        protected long last_missing = -1L;

        protected Missing() {
        }

        protected SeqnoList getMissingElements() {
            return this.missing_elements;
        }

        @Override
        public boolean visit(long seqno, T element, int row, int column) {
            if (element == null) {
                if (this.last_missing == -1L) {
                    this.last_missing = seqno;
                }
            } else if (this.last_missing != -1L) {
                long tmp = seqno - 1L;
                if (this.missing_elements == null) {
                    this.missing_elements = new SeqnoList();
                }
                if (tmp - this.last_missing > 0L) {
                    this.missing_elements.add(this.last_missing, tmp);
                } else {
                    this.missing_elements.add(this.last_missing);
                }
                this.last_missing = -1L;
            }
            return true;
        }
    }

    protected class Dump
    implements Visitor<T> {
        protected final StringBuilder sb = new StringBuilder();
        protected boolean first = true;

        protected Dump() {
        }

        protected String getResult() {
            return this.sb.toString();
        }

        @Override
        public boolean visit(long seqno, T element, int row, int column) {
            if (element != null) {
                if (this.first) {
                    this.first = false;
                } else {
                    this.sb.append(", ");
                }
                this.sb.append(seqno);
            }
            return true;
        }
    }

    protected class Remover
    implements Visitor<T> {
        protected final boolean nullify;
        protected final int max_results;
        protected List<T> list;
        protected int num_results;

        public Remover(boolean nullify, int max_results) {
            this.nullify = nullify;
            this.max_results = max_results;
        }

        public List<T> getList() {
            return this.list;
        }

        @Override
        public boolean visit(long seqno, T element, int row, int column) {
            if (element != null) {
                if (this.list == null) {
                    this.list = new LinkedList();
                }
                this.list.add(element);
                if (seqno > Table.this.hd) {
                    Table.this.hd = seqno;
                }
                Table.this.size = Math.max(Table.this.size - 1, 0);
                if (this.nullify) {
                    Table.this.matrix[row][column] = null;
                    if (seqno > Table.this.low) {
                        Table.this.low = seqno;
                    }
                }
                return this.max_results == 0 || ++this.num_results < this.max_results;
            }
            return false;
        }
    }

    protected class Getter
    implements Visitor<T> {
        protected List<T> list;

        protected Getter() {
        }

        public List<T> getList() {
            return this.list;
        }

        @Override
        public boolean visit(long seqno, T element, int row, int column) {
            if (element != null) {
                if (this.list == null) {
                    this.list = new LinkedList();
                }
                this.list.add(element);
            }
            return true;
        }
    }

    protected class Counter
    implements Visitor<T> {
        protected int result = 0;

        protected Counter() {
        }

        public int getResult() {
            return this.result;
        }

        @Override
        public boolean visit(long seqno, T element, int row, int column) {
            if (element != null) {
                ++this.result;
            }
            return true;
        }
    }

    public static interface Visitor<T> {
        public boolean visit(long var1, T var3, int var4, int var5);
    }
}

