/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols.pbcast;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.jgroups.Address;
import org.jgroups.Event;
import org.jgroups.Message;
import org.jgroups.View;
import org.jgroups.annotations.MBean;
import org.jgroups.annotations.ManagedAttribute;
import org.jgroups.annotations.ManagedOperation;
import org.jgroups.annotations.Property;
import org.jgroups.protocols.TP;
import org.jgroups.protocols.pbcast.NakAckHeader2;
import org.jgroups.stack.DiagnosticsHandler;
import org.jgroups.stack.Protocol;
import org.jgroups.util.BoundedList;
import org.jgroups.util.Digest;
import org.jgroups.util.MessageBatch;
import org.jgroups.util.SeqnoList;
import org.jgroups.util.SuppressLog;
import org.jgroups.util.Table;
import org.jgroups.util.TimeScheduler;
import org.jgroups.util.Tuple;
import org.jgroups.util.Util;

@MBean(description="Reliable transmission multipoint FIFO protocol")
public class NAKACK2
extends Protocol
implements DiagnosticsHandler.ProbeHandler {
    protected static final int NUM_REBROADCAST_MSGS = 3;
    @Property(description="Max number of messages to be removed from a RingBuffer. This property might get removed anytime, so don't use it !")
    protected int max_msg_batch_size = 100;
    @Property(description="Retransmit retransmit responses (messages) using multicast rather than unicast")
    protected boolean use_mcast_xmit = true;
    @Property(description="Use a multicast to request retransmission of missing messages")
    protected boolean use_mcast_xmit_req = false;
    @Property(description="Ask a random member for retransmission of a missing message. Default is false")
    protected boolean xmit_from_random_member = false;
    @Property(description="Should messages delivered to application be discarded")
    protected boolean discard_delivered_msgs = true;
    @Property(description="Timeout to rebroadcast messages. Default is 2000 msec")
    protected long max_rebroadcast_timeout = 2000L;
    @Property(description="Should stability history be printed if we fail in retransmission. Default is false")
    protected boolean print_stability_history_on_failed_xmit = false;
    @Property(description="discards warnings about promiscuous traffic")
    protected boolean log_discard_msgs = true;
    @Property(description="If true, trashes warnings about retransmission messages not found in the xmit_table (used for testing)")
    protected boolean log_not_found_msgs = true;
    @Property(description="Interval (in milliseconds) at which missing messages (from all retransmit buffers) are retransmitted")
    protected long xmit_interval = 1000L;
    @Property(description="Number of rows of the matrix in the retransmission table (only for experts)", writable=false)
    protected int xmit_table_num_rows = 50;
    @Property(description="Number of elements of a row of the matrix in the retransmission table (only for experts). The capacity of the matrix is xmit_table_num_rows * xmit_table_msgs_per_row", writable=false)
    protected int xmit_table_msgs_per_row = 10000;
    @Property(description="Resize factor of the matrix in the retransmission table (only for experts)", writable=false)
    protected double xmit_table_resize_factor = 1.2;
    @Property(description="Number of milliseconds after which the matrix in the retransmission table is compacted (only for experts)", writable=false)
    protected long xmit_table_max_compaction_time = 10000L;
    @Property(description="Size of the queue to hold messages received after creating the channel, but before being connected (is_server=false). After becoming the server, the messages in the queue are fed into up() and the queue is cleared. The motivation is to avoid retransmissions (see https://issues.jboss.org/browse/JGRP-1509 for details). 0 disables the queue.")
    protected int become_server_queue_size = 50;
    @Property(description="Time during which identical warnings about messages from a non member will be suppressed. 0 disables this (every warning will be logged). Setting the log level to ERROR also disables this.")
    protected long suppress_time_non_member_warnings = 60000L;
    @ManagedAttribute(description="Number of retransmit requests received")
    protected final AtomicLong xmit_reqs_received = new AtomicLong(0L);
    @ManagedAttribute(description="Number of retransmit requests sent")
    protected final AtomicLong xmit_reqs_sent = new AtomicLong(0L);
    @ManagedAttribute(description="Number of retransmit responses received")
    protected final AtomicLong xmit_rsps_received = new AtomicLong(0L);
    @ManagedAttribute(description="Number of retransmit responses sent")
    protected final AtomicLong xmit_rsps_sent = new AtomicLong(0L);
    @ManagedAttribute(description="Number of messages sent")
    protected int num_messages_sent = 0;
    @ManagedAttribute(description="Number of messages received")
    protected int num_messages_received = 0;
    protected volatile boolean is_server = false;
    protected Address local_addr = null;
    protected volatile List<Address> members = new ArrayList<Address>();
    protected View view;
    private final AtomicLong seqno = new AtomicLong(0L);
    protected final ConcurrentMap<Address, Table<Message>> xmit_table = Util.createConcurrentMap();
    protected Future<?> xmit_task;
    protected final Map<Address, Long> xmit_task_map = new HashMap<Address, Long>();
    protected volatile boolean leaving = false;
    protected volatile boolean running = false;
    protected TimeScheduler timer = null;
    protected final Lock rebroadcast_lock = new ReentrantLock();
    protected final Condition rebroadcast_done = this.rebroadcast_lock.newCondition();
    protected volatile boolean rebroadcasting = false;
    protected final Lock rebroadcast_digest_lock = new ReentrantLock();
    protected Digest rebroadcast_digest = null;
    protected final BoundedList<Digest> stability_msgs = new BoundedList(10);
    protected final BoundedList<String> digest_history = new BoundedList(10);
    protected BoundedList<Message> become_server_queue;
    protected SuppressLog<Address> suppress_log_non_member;

    @ManagedAttribute(description="Is the retransmit task running")
    public boolean isXmitTaskRunning() {
        return this.xmit_task != null && !this.xmit_task.isDone();
    }

    @ManagedAttribute(description="Number of messages from non-members")
    public int getNonMemberMessages() {
        return this.suppress_log_non_member != null ? this.suppress_log_non_member.getCache().size() : 0;
    }

    @ManagedOperation(description="Clears the cache for messages from non-members")
    public void clearNonMemberCache() {
        if (this.suppress_log_non_member != null) {
            this.suppress_log_non_member.getCache().clear();
        }
    }

    public long getXmitRequestsReceived() {
        return this.xmit_reqs_received.get();
    }

    public long getXmitRequestsSent() {
        return this.xmit_reqs_sent.get();
    }

    public long getXmitResponsesReceived() {
        return this.xmit_rsps_received.get();
    }

    public long getXmitResponsesSent() {
        return this.xmit_rsps_sent.get();
    }

    public boolean isUseMcastXmit() {
        return this.use_mcast_xmit;
    }

    public boolean isXmitFromRandomMember() {
        return this.xmit_from_random_member;
    }

    public boolean isDiscardDeliveredMsgs() {
        return this.discard_delivered_msgs;
    }

    public boolean getLogDiscardMessages() {
        return this.log_discard_msgs;
    }

    public void setUseMcastXmit(boolean use_mcast_xmit) {
        this.use_mcast_xmit = use_mcast_xmit;
    }

    public void setUseMcastXmitReq(boolean flag) {
        this.use_mcast_xmit_req = flag;
    }

    public void setLogDiscardMessages(boolean flag) {
        this.log_discard_msgs = flag;
    }

    public void setXmitFromRandomMember(boolean xmit_from_random_member) {
        this.xmit_from_random_member = xmit_from_random_member;
    }

    public void setDiscardDeliveredMsgs(boolean discard_delivered_msgs) {
        this.discard_delivered_msgs = discard_delivered_msgs;
    }

    @ManagedAttribute(description="Actual size of the become_server_queue")
    public int getBecomeServerQueueSizeActual() {
        return this.become_server_queue != null ? this.become_server_queue.size() : -1;
    }

    public Table<Message> getWindow(Address sender) {
        return (Table)this.xmit_table.get(sender);
    }

    public void setTimer(TimeScheduler timer) {
        this.timer = timer;
    }

    @ManagedAttribute(description="Total number of undelivered messages in all retransmit buffers")
    public int getXmitTableUndeliveredMsgs() {
        int num = 0;
        for (Table buf : this.xmit_table.values()) {
            num += buf.size();
        }
        return num;
    }

    @ManagedAttribute(description="Total number of missing (= not received) messages in all retransmit buffers")
    public int getXmitTableMissingMessages() {
        int num = 0;
        for (Table buf : this.xmit_table.values()) {
            num += buf.getNumMissing();
        }
        return num;
    }

    @ManagedAttribute(description="Capacity of the retransmit buffer. Computed as xmit_table_num_rows * xmit_table_msgs_per_row")
    public long getXmitTableCapacity() {
        Table table = this.local_addr != null ? (Table)this.xmit_table.get(this.local_addr) : null;
        return table != null ? (long)table.capacity() : 0L;
    }

    @ManagedAttribute(description="Prints the number of rows currently allocated in the matrix. This value will not be lower than xmit_table_now_rows")
    public int getXmitTableNumCurrentRows() {
        Table table = this.local_addr != null ? (Table)this.xmit_table.get(this.local_addr) : null;
        return table != null ? table.getNumRows() : 0;
    }

    @ManagedAttribute(description="Returns the number of bytes of all messages in all retransmit buffers. To compute the size, Message.getLength() is used")
    public long getSizeOfAllMessages() {
        long retval = 0L;
        for (Table buf : this.xmit_table.values()) {
            retval += NAKACK2.sizeOfAllMessages(buf, false);
        }
        return retval;
    }

    @ManagedAttribute(description="Returns the number of bytes of all messages in all retransmit buffers. To compute the size, Message.size() is used")
    public long getSizeOfAllMessagesInclHeaders() {
        long retval = 0L;
        for (Table buf : this.xmit_table.values()) {
            retval += NAKACK2.sizeOfAllMessages(buf, true);
        }
        return retval;
    }

    @ManagedAttribute(description="Number of retransmit table compactions")
    public int getXmitTableNumCompactions() {
        Table table = this.local_addr != null ? (Table)this.xmit_table.get(this.local_addr) : null;
        return table != null ? table.getNumCompactions() : 0;
    }

    @ManagedAttribute(description="Number of retransmit table moves")
    public int getXmitTableNumMoves() {
        Table table = this.local_addr != null ? (Table)this.xmit_table.get(this.local_addr) : null;
        return table != null ? table.getNumMoves() : 0;
    }

    @ManagedAttribute(description="Number of retransmit table resizes")
    public int getXmitTableNumResizes() {
        Table table = this.local_addr != null ? (Table)this.xmit_table.get(this.local_addr) : null;
        return table != null ? table.getNumResizes() : 0;
    }

    @ManagedAttribute(description="Number of retransmit table purges")
    public int getXmitTableNumPurges() {
        Table table = this.local_addr != null ? (Table)this.xmit_table.get(this.local_addr) : null;
        return table != null ? table.getNumPurges() : 0;
    }

    @ManagedOperation(description="Prints the contents of the receiver windows for all members")
    public String printMessages() {
        StringBuilder ret = new StringBuilder(this.local_addr + ":\n");
        for (Map.Entry entry : this.xmit_table.entrySet()) {
            Address addr = (Address)entry.getKey();
            Table buf = (Table)entry.getValue();
            ret.append(addr).append(": ").append(buf.toString()).append('\n');
        }
        return ret.toString();
    }

    @ManagedAttribute
    public long getCurrentSeqno() {
        return this.seqno.get();
    }

    @ManagedOperation(description="Prints the stability messages received")
    public String printStabilityMessages() {
        StringBuilder sb = new StringBuilder();
        sb.append(Util.printListWithDelimiter(this.stability_msgs, "\n"));
        return sb.toString();
    }

    @ManagedOperation(description="Keeps information about the last N times a digest was set or merged")
    public String printDigestHistory() {
        StringBuilder sb = new StringBuilder(this.local_addr + ":\n");
        for (String tmp : this.digest_history) {
            sb.append(tmp).append("\n");
        }
        return sb.toString();
    }

    @ManagedOperation(description="Compacts the retransmit buffer")
    public void compact() {
        Table table;
        Table table2 = table = this.local_addr != null ? (Table)this.xmit_table.get(this.local_addr) : null;
        if (table != null) {
            table.compact();
        }
    }

    @ManagedOperation(description="Prints the number of rows currently allocated in the matrix for all members. This value will not be lower than xmit_table_now_rows")
    public String dumpXmitTablesNumCurrentRows() {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry entry : this.xmit_table.entrySet()) {
            sb.append(entry.getKey()).append(": ").append(((Table)entry.getValue()).getNumRows()).append("\n");
        }
        return sb.toString();
    }

    @Override
    @ManagedOperation(description="Resets all statistics")
    public void resetStats() {
        Table table;
        this.num_messages_received = 0;
        this.num_messages_sent = 0;
        this.xmit_reqs_received.set(0L);
        this.xmit_reqs_sent.set(0L);
        this.xmit_rsps_received.set(0L);
        this.xmit_rsps_sent.set(0L);
        this.stability_msgs.clear();
        this.digest_history.clear();
        Table table2 = table = this.local_addr != null ? (Table)this.xmit_table.get(this.local_addr) : null;
        if (table != null) {
            table.resetStats();
        }
    }

    @Override
    public void init() throws Exception {
        TP transport;
        if (this.xmit_from_random_member && this.discard_delivered_msgs) {
            this.discard_delivered_msgs = false;
            this.log.debug("xmit_from_random_member set to true: changed discard_delivered_msgs to false");
        }
        if ((transport = this.getTransport()) != null) {
            transport.registerProbeHandler(this);
            if (!transport.supportsMulticasting()) {
                if (this.use_mcast_xmit) {
                    this.log.warn("use_mcast_xmit should not be used because the transport (" + transport.getName() + ") does not support IP multicasting; setting use_mcast_xmit to false");
                    this.use_mcast_xmit = false;
                }
                if (this.use_mcast_xmit_req) {
                    this.log.warn("use_mcast_xmit_req should not be used because the transport (" + transport.getName() + ") does not support IP multicasting; setting use_mcast_xmit_req to false");
                    this.use_mcast_xmit_req = false;
                }
            }
        }
        if (this.become_server_queue_size > 0) {
            this.become_server_queue = new BoundedList(this.become_server_queue_size);
        }
        if (this.suppress_time_non_member_warnings > 0L) {
            this.suppress_log_non_member = new SuppressLog(this.log, "MsgDroppedNak", "SuppressMsg");
        }
    }

    @Override
    public Map<String, Object> dumpStats() {
        Map<String, Object> retval = super.dumpStats();
        retval.put("msgs", this.printMessages());
        return retval;
    }

    @Override
    public String printStats() {
        StringBuilder sb = new StringBuilder();
        sb.append("\nStability messages received\n");
        sb.append(this.printStabilityMessages()).append("\n");
        return sb.toString();
    }

    public String printStabilityHistory() {
        StringBuilder sb = new StringBuilder();
        int i = 1;
        for (Digest digest : this.stability_msgs) {
            sb.append(i++).append(": ").append(digest).append("\n");
        }
        return sb.toString();
    }

    @Override
    public List<Integer> providedUpServices() {
        return Arrays.asList(39, 41, 42, 53);
    }

    @Override
    public void start() throws Exception {
        this.timer = this.getTransport().getTimer();
        if (this.timer == null) {
            throw new Exception("timer is null");
        }
        this.running = true;
        this.leaving = false;
        this.startRetransmitTask();
    }

    @Override
    public void stop() {
        this.running = false;
        this.is_server = false;
        if (this.become_server_queue != null) {
            this.become_server_queue.clear();
        }
        this.stopRetransmitTask();
        this.xmit_task_map.clear();
        this.reset();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object down(Event evt) {
        switch (evt.getType()) {
            case 1: {
                Message msg = (Message)evt.getArg();
                Address dest = msg.getDest();
                if (dest != null || msg.isFlagSet(Message.NO_RELIABILITY)) break;
                this.send(evt, msg);
                return null;
            }
            case 30: {
                this.stable((Digest)evt.getArg());
                return null;
            }
            case 39: {
                return this.getDigest((Address)evt.getArg());
            }
            case 41: {
                this.setDigest((Digest)evt.getArg());
                return null;
            }
            case 42: {
                this.overwriteDigest((Digest)evt.getArg());
                return null;
            }
            case 53: {
                this.mergeDigest((Digest)evt.getArg());
                return null;
            }
            case 15: {
                View tmp_view = (View)evt.getArg();
                List<Address> mbrs = tmp_view.getMembers();
                this.members = new ArrayList<Address>(mbrs);
                break;
            }
            case 6: {
                View tmp_view = (View)evt.getArg();
                List<Address> mbrs = tmp_view.getMembers();
                this.members = new ArrayList<Address>(mbrs);
                this.view = tmp_view;
                this.adjustReceivers(mbrs);
                this.is_server = true;
                if (this.suppress_log_non_member != null) {
                    this.suppress_log_non_member.removeExpired(this.suppress_time_non_member_warnings);
                }
                this.xmit_task_map.keySet().retainAll(tmp_view.getMembers());
                break;
            }
            case 16: {
                this.is_server = true;
                this.flushBecomeServerQueue();
                break;
            }
            case 8: {
                this.local_addr = (Address)evt.getArg();
                break;
            }
            case 4: {
                this.leaving = true;
                this.reset();
                break;
            }
            case 78: {
                this.rebroadcasting = true;
                this.rebroadcast_digest = (Digest)evt.getArg();
                try {
                    this.rebroadcastMessages();
                }
                finally {
                    this.rebroadcasting = false;
                    this.rebroadcast_digest_lock.lock();
                    try {
                        this.rebroadcast_digest = null;
                    }
                    finally {
                        this.rebroadcast_digest_lock.unlock();
                    }
                }
                return null;
            }
        }
        return this.down_prot.down(evt);
    }

    @Override
    public Object up(Event evt) {
        switch (evt.getType()) {
            case 1: {
                NakAckHeader2 hdr;
                Message msg = (Message)evt.getArg();
                if (msg.isFlagSet(Message.NO_RELIABILITY) || (hdr = (NakAckHeader2)msg.getHeader(this.id)) == null) break;
                if (!this.is_server) {
                    if (this.become_server_queue != null) {
                        this.become_server_queue.add(msg);
                        if (this.log.isTraceEnabled()) {
                            this.log.trace(this.local_addr + ": message " + msg.getSrc() + "::" + hdr.seqno + " was added to queue (not yet server)");
                        }
                    } else if (this.log.isTraceEnabled()) {
                        this.log.trace(this.local_addr + ": message " + msg.getSrc() + "::" + hdr.seqno + " was discarded (not yet server)");
                    }
                    return null;
                }
                switch (hdr.type) {
                    case 1: {
                        this.handleMessage(msg, hdr);
                        return null;
                    }
                    case 2: {
                        SeqnoList missing = (SeqnoList)msg.getObject();
                        if (missing == null) {
                            return null;
                        }
                        this.handleXmitReq(msg.getSrc(), missing, hdr.sender);
                        return null;
                    }
                    case 3: {
                        this.handleXmitRsp(msg, hdr);
                        return null;
                    }
                }
                if (this.log.isErrorEnabled()) {
                    this.log.error("header type " + hdr.type + " not known");
                }
                return null;
            }
            case 30: {
                this.stable((Digest)evt.getArg());
                return null;
            }
            case 9: {
                if (!this.rebroadcasting) break;
                this.cancelRebroadcasting();
            }
        }
        return this.up_prot.up(evt);
    }

    @Override
    public void up(MessageBatch batch) {
        int size = batch.size();
        boolean got_retransmitted_msg = false;
        ArrayList<Tuple<Long, Message>> msgs = null;
        Iterator<Message> it = batch.iterator();
        block5: while (it.hasNext()) {
            NakAckHeader2 hdr;
            Message msg = it.next();
            if (msg == null || msg.isFlagSet(Message.Flag.NO_RELIABILITY) || (hdr = (NakAckHeader2)msg.getHeader(this.id)) == null) continue;
            it.remove();
            if (!this.is_server) {
                if (this.become_server_queue != null) {
                    this.become_server_queue.add(msg);
                    if (!this.log.isTraceEnabled()) continue;
                    this.log.trace(this.local_addr + ": message " + msg.getSrc() + "::" + hdr.seqno + " was added to queue (not yet server)");
                    continue;
                }
                if (!this.log.isTraceEnabled()) continue;
                this.log.trace(this.local_addr + ": message " + msg.getSrc() + "::" + hdr.seqno + " was discarded (not yet server)");
                continue;
            }
            switch (hdr.type) {
                case 1: {
                    if (msgs == null) {
                        msgs = new ArrayList<Tuple<Long, Message>>(size);
                    }
                    msgs.add(new Tuple<Long, Message>(hdr.seqno, msg));
                    continue block5;
                }
                case 2: {
                    SeqnoList missing = (SeqnoList)msg.getObject();
                    if (missing == null) continue block5;
                    this.handleXmitReq(msg.getSrc(), missing, hdr.sender);
                    continue block5;
                }
                case 3: {
                    Message xmitted_msg = this.msgFromXmitRsp(msg, hdr);
                    if (xmitted_msg == null) continue block5;
                    if (msgs == null) {
                        msgs = new ArrayList(size);
                    }
                    msgs.add(new Tuple<Long, Message>(hdr.seqno, xmitted_msg));
                    got_retransmitted_msg = true;
                    continue block5;
                }
            }
            if (!this.log.isErrorEnabled()) continue;
            this.log.error("header type " + hdr.type + " not known");
        }
        if (msgs != null) {
            this.handleMessages(batch.sender(), msgs, batch.mode() == MessageBatch.Mode.OOB);
        }
        if (got_retransmitted_msg && this.rebroadcasting) {
            this.checkForRebroadcasts();
        }
        if (!batch.isEmpty()) {
            this.up_prot.up(batch);
        }
    }

    @Override
    public Map<String, String> handleProbe(String ... keys) {
        HashMap<String, String> retval = new HashMap<String, String>();
        for (String key : keys) {
            if (key.equals("digest-history")) {
                retval.put(key, this.printDigestHistory());
            }
            if (!key.equals("dump-digest")) continue;
            retval.put(key, "\n" + this.printMessages());
        }
        return retval;
    }

    @Override
    public String[] supportedKeys() {
        return new String[]{"digest-history", "dump-digest"};
    }

    protected void send(Event evt, Message msg) {
        if (msg == null) {
            throw new NullPointerException("msg is null; event is " + evt);
        }
        if (!this.running) {
            if (this.log.isTraceEnabled()) {
                this.log.trace(this.local_addr + ": discarded message as we're not in the 'running' state, message: " + msg);
            }
            return;
        }
        Table buf = (Table)this.xmit_table.get(this.local_addr);
        if (buf == null) {
            return;
        }
        if (msg.getSrc() == null) {
            msg.setSrc(this.local_addr);
        }
        long msg_id = this.seqno.incrementAndGet();
        long sleep = 10L;
        while (this.running) {
            try {
                msg.putHeader(this.id, NakAckHeader2.createMessageHeader(msg_id));
                buf.add(msg_id, msg);
                break;
            }
            catch (Throwable t) {
                if (!this.running) break;
                Util.sleep(sleep);
                sleep = Math.min(5000L, sleep * 2L);
            }
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace(this.local_addr + " sending " + this.local_addr + "#" + msg_id);
        }
        this.down_prot.down(evt);
        ++this.num_messages_sent;
    }

    protected void handleMessage(Message msg, NakAckHeader2 hdr) {
        boolean added;
        Address sender = msg.getSrc();
        Table buf = (Table)this.xmit_table.get(sender);
        if (buf == null) {
            if (this.leaving) {
                return;
            }
            if (this.log.isWarnEnabled() && this.log_discard_msgs) {
                if (this.suppress_log_non_member != null) {
                    this.suppress_log_non_member.log(SuppressLog.Level.warn, sender, this.suppress_time_non_member_warnings, this.local_addr, hdr.seqno, sender, this.view);
                } else {
                    this.log.warn(Util.getMessage("MsgDroppedNak", this.local_addr, hdr.seqno, sender, this.view));
                }
            }
            return;
        }
        ++this.num_messages_received;
        boolean loopback = this.local_addr.equals(sender);
        boolean bl = added = loopback || buf.add(hdr.seqno, msg);
        if (added && this.log.isTraceEnabled()) {
            this.log.trace(new StringBuilder().append(this.local_addr).append(": received ").append(sender).append('#').append(hdr.seqno));
        }
        if (added && msg.isFlagSet(Message.OOB)) {
            if (loopback) {
                msg = (Message)buf.get(hdr.seqno);
            }
            if (msg != null && msg.isFlagSet(Message.OOB) && msg.setTransientFlagIfAbsent(Message.OOB_DELIVERED)) {
                if (this.log.isTraceEnabled()) {
                    this.log.trace(new StringBuilder().append(this.local_addr).append(": delivering ").append(sender).append('#').append(hdr.seqno));
                }
                try {
                    this.up_prot.up(new Event(1, msg));
                }
                catch (Throwable t) {
                    this.log.error("failed to deliver OOB message " + msg, t);
                }
            }
        }
        this.removeAndPassUp(buf, sender, loopback);
    }

    protected void handleMessages(Address sender, List<Tuple<Long, Message>> msgs, boolean oob) {
        boolean added;
        Table buf = (Table)this.xmit_table.get(sender);
        if (buf == null) {
            if (this.leaving) {
                return;
            }
            if (this.log.isWarnEnabled() && this.log_discard_msgs) {
                if (this.suppress_log_non_member != null) {
                    this.suppress_log_non_member.log(SuppressLog.Level.warn, sender, this.suppress_time_non_member_warnings, this.local_addr, "batch", sender, this.view);
                } else {
                    this.log.warn(Util.getMessage("MsgDroppedNak", this.local_addr, "batch", sender, this.view));
                }
            }
            return;
        }
        int size = msgs.size();
        this.num_messages_received += size;
        boolean loopback = this.local_addr.equals(sender);
        boolean bl = added = loopback || buf.add(msgs);
        if (added && this.log.isTraceEnabled()) {
            this.log.trace(new StringBuilder().append(this.local_addr).append(": received ").append(sender).append('#').append(msgs.get(0).getVal1()).append(" - #").append(msgs.get(size - 1).getVal1()).append(" (" + msgs.size() + " messages)"));
        }
        if (added && oob) {
            for (Tuple tuple : msgs) {
                long seq = tuple.getVal1();
                Message msg = loopback ? (Message)buf.get(seq) : (Message)tuple.getVal2();
                if (msg == null || !msg.isFlagSet(Message.OOB) || !msg.setTransientFlagIfAbsent(Message.OOB_DELIVERED)) continue;
                if (this.log.isTraceEnabled()) {
                    this.log.trace(new StringBuilder().append(this.local_addr).append(": delivering ").append(sender).append('#').append(seq));
                }
                try {
                    this.up_prot.up(new Event(1, msg));
                }
                catch (Throwable t) {
                    this.log.error("failed to deliver OOB message " + msg, t);
                }
            }
        }
        this.removeAndPassUp(buf, sender, loopback);
    }

    protected void removeAndPassUp(Table<Message> buf, Address sender, boolean loopback) {
        AtomicBoolean processing = buf.getProcessing();
        if (!processing.compareAndSet(false, true)) {
            return;
        }
        boolean remove_msgs = this.discard_delivered_msgs && !loopback;
        boolean released_processing = false;
        try {
            block6: while (true) {
                List<Message> msgs;
                if ((msgs = buf.removeMany(processing, remove_msgs, this.max_msg_batch_size)) == null || msgs.isEmpty()) {
                    released_processing = true;
                    if (this.rebroadcasting) {
                        this.checkForRebroadcasts();
                    }
                    return;
                }
                Iterator<Message> i$ = msgs.iterator();
                while (true) {
                    if (!i$.hasNext()) continue block6;
                    Message msg_to_deliver = i$.next();
                    if (msg_to_deliver.isFlagSet(Message.OOB) && !msg_to_deliver.setTransientFlagIfAbsent(Message.OOB_DELIVERED)) continue;
                    try {
                        if (this.log.isTraceEnabled()) {
                            NakAckHeader2 header = (NakAckHeader2)msg_to_deliver.getHeader(this.id);
                            this.log.trace(new StringBuilder().append(this.local_addr).append(": delivering ").append(sender).append('#').append(header.seqno));
                        }
                        this.up_prot.up(new Event(1, msg_to_deliver));
                    }
                    catch (Throwable t) {
                        this.log.error("failed to deliver message " + msg_to_deliver, t);
                    }
                }
                break;
            }
        }
        finally {
            if (!released_processing) {
                processing.set(false);
            }
        }
    }

    protected void handleXmitReq(Address xmit_requester, SeqnoList missing_msgs, Address original_sender) {
        Table buf;
        if (this.log.isTraceEnabled()) {
            StringBuilder sb = new StringBuilder();
            sb.append(this.local_addr).append(": received xmit request from ").append(xmit_requester).append(" for ");
            sb.append(original_sender).append(missing_msgs);
            this.log.trace(sb);
        }
        if (this.stats) {
            this.xmit_reqs_received.addAndGet(missing_msgs.size());
        }
        if ((buf = (Table)this.xmit_table.get(original_sender)) == null) {
            if (this.log.isErrorEnabled()) {
                StringBuilder sb = new StringBuilder();
                sb.append("(requester=").append(xmit_requester).append(", local_addr=").append(this.local_addr);
                sb.append(") ").append(original_sender).append(" not found in retransmission table");
                if (this.log.isTraceEnabled()) {
                    sb.append(":\n").append(this.printMessages());
                }
                if (this.print_stability_history_on_failed_xmit) {
                    sb.append(" (stability history:\n").append(this.printStabilityHistory());
                }
                this.log.error(sb.toString());
            }
            return;
        }
        for (long i : missing_msgs) {
            Message msg = (Message)buf.get(i);
            if (msg == null) {
                if (!this.log.isWarnEnabled() || !this.log_not_found_msgs || this.local_addr.equals(xmit_requester) || i <= buf.getLow()) continue;
                StringBuilder sb = new StringBuilder();
                sb.append("(requester=").append(xmit_requester).append(", local_addr=").append(this.local_addr);
                sb.append(") message ").append(original_sender).append("::").append(i);
                sb.append(" not found in retransmission table of ").append(original_sender).append(":\n").append(buf);
                if (this.print_stability_history_on_failed_xmit) {
                    sb.append(" (stability history:\n").append(this.printStabilityHistory());
                }
                this.log.warn(sb.toString());
                continue;
            }
            if (this.log.isTraceEnabled()) {
                this.log.trace(this.local_addr + ": resending " + original_sender + "::" + i);
            }
            this.sendXmitRsp(xmit_requester, msg);
        }
    }

    protected void flushBecomeServerQueue() {
        if (this.become_server_queue != null && !this.become_server_queue.isEmpty()) {
            if (this.log.isTraceEnabled()) {
                this.log.trace(this.local_addr + ": flushing become_server_queue (" + this.become_server_queue.size() + " elements)");
            }
            TP transport = this.getTransport();
            Executor thread_pool = transport.getDefaultThreadPool();
            Executor oob_thread_pool = transport.getOOBThreadPool();
            for (final Message msg : this.become_server_queue) {
                Executor pool = msg.isFlagSet(Message.Flag.OOB) ? oob_thread_pool : thread_pool;
                pool.execute(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        try {
                            NAKACK2.this.up(new Event(1, msg));
                        }
                        finally {
                            NAKACK2.this.become_server_queue.remove(msg);
                        }
                    }
                });
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void cancelRebroadcasting() {
        this.rebroadcast_lock.lock();
        try {
            this.rebroadcasting = false;
            this.rebroadcast_done.signalAll();
        }
        finally {
            this.rebroadcast_lock.unlock();
        }
    }

    protected void sendXmitRsp(Address dest, Message msg) {
        if (msg == null) {
            return;
        }
        if (this.stats) {
            this.xmit_rsps_sent.incrementAndGet();
        }
        if (msg.getSrc() == null) {
            msg.setSrc(this.local_addr);
        }
        if (this.use_mcast_xmit) {
            this.down_prot.down(new Event(1, msg));
            return;
        }
        Message xmit_msg = msg.copy(true, true);
        xmit_msg.setDest(dest);
        NakAckHeader2 hdr = (NakAckHeader2)xmit_msg.getHeader(this.id);
        NakAckHeader2 newhdr = hdr.copy();
        newhdr.type = (byte)3;
        xmit_msg.putHeader(this.id, newhdr);
        this.down_prot.down(new Event(1, xmit_msg));
    }

    protected void handleXmitRsp(Message msg, NakAckHeader2 hdr) {
        block5: {
            if (msg == null) {
                return;
            }
            try {
                if (this.stats) {
                    this.xmit_rsps_received.incrementAndGet();
                }
                msg.setDest(null);
                NakAckHeader2 newhdr = hdr.copy();
                newhdr.type = 1;
                msg.putHeader(this.id, newhdr);
                this.up(new Event(1, msg));
                if (this.rebroadcasting) {
                    this.checkForRebroadcasts();
                }
            }
            catch (Exception ex) {
                if (!this.log.isErrorEnabled()) break block5;
                this.log.error("failed handling retransmitted message", ex);
            }
        }
    }

    protected Message msgFromXmitRsp(Message msg, NakAckHeader2 hdr) {
        if (msg == null) {
            return null;
        }
        if (this.stats) {
            this.xmit_rsps_received.incrementAndGet();
        }
        msg.setDest(null);
        NakAckHeader2 newhdr = hdr.copy();
        newhdr.type = 1;
        msg.putHeader(this.id, newhdr);
        return msg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void rebroadcastMessages() {
        long sleep = this.max_rebroadcast_timeout / 3L;
        long wait_time = this.max_rebroadcast_timeout;
        long start = System.currentTimeMillis();
        while (wait_time > 0L) {
            Digest their_digest;
            this.rebroadcast_digest_lock.lock();
            try {
                if (this.rebroadcast_digest == null) {
                    return;
                }
                their_digest = this.rebroadcast_digest.copy();
            }
            finally {
                this.rebroadcast_digest_lock.unlock();
            }
            Digest my_digest = this.getDigest();
            boolean xmitted = false;
            for (Digest.DigestEntry entry : their_digest) {
                long my_high;
                long their_high;
                Address member = entry.getMember();
                long[] my_entry = my_digest.get(member);
                if (my_entry == null || (their_high = entry.getHighest()) <= (my_high = Math.max(my_entry[0], my_entry[1]))) continue;
                if (this.log.isTraceEnabled()) {
                    this.log.trace(this.local_addr + " fetching " + my_high + "-" + their_high + " from " + member);
                }
                this.retransmit(my_high + 1L, their_high, member, true);
                xmitted = true;
            }
            if (!xmitted) {
                return;
            }
            this.rebroadcast_lock.lock();
            try {
                my_digest = this.getDigest();
                this.rebroadcast_digest_lock.lock();
                try {
                    if (!this.rebroadcasting || my_digest.isGreaterThanOrEqual(this.rebroadcast_digest)) {
                        this.rebroadcast_digest_lock.unlock();
                        this.rebroadcast_lock.unlock();
                        return;
                    }
                }
                catch (Throwable throwable) {
                    this.rebroadcast_digest_lock.unlock();
                    throw throwable;
                }
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            this.rebroadcast_digest_lock.unlock();
            this.rebroadcast_done.await(sleep, TimeUnit.MILLISECONDS);
            wait_time -= System.currentTimeMillis() - start;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkForRebroadcasts() {
        boolean cancel_rebroadcasting;
        Digest tmp = this.getDigest();
        this.rebroadcast_digest_lock.lock();
        try {
            cancel_rebroadcasting = tmp.isGreaterThanOrEqual(this.rebroadcast_digest);
        }
        finally {
            this.rebroadcast_digest_lock.unlock();
        }
        if (cancel_rebroadcasting) {
            this.cancelRebroadcasting();
        }
    }

    protected void adjustReceivers(List<Address> new_members) {
        for (Address member : this.xmit_table.keySet()) {
            Table buf;
            if (new_members.contains(member) || this.local_addr != null && this.local_addr.equals(member) || (buf = (Table)this.xmit_table.remove(member)) == null || !this.log.isDebugEnabled()) continue;
            this.log.debug(this.local_addr + ": removed " + member + " from xmit_table (not member anymore)");
        }
    }

    public Digest getDigest() {
        HashMap<Address, long[]> map = new HashMap<Address, long[]>();
        for (Map.Entry entry : this.xmit_table.entrySet()) {
            Address sender = (Address)entry.getKey();
            Table buf = (Table)entry.getValue();
            long[] seqnos = buf.getDigest();
            map.put(sender, seqnos);
        }
        return new Digest(map);
    }

    public Digest getDigest(Address mbr) {
        if (mbr == null) {
            return this.getDigest();
        }
        Table buf = (Table)this.xmit_table.get(mbr);
        if (buf == null) {
            return null;
        }
        long[] seqnos = buf.getDigest();
        return new Digest(mbr, seqnos[0], seqnos[1]);
    }

    protected void setDigest(Digest digest) {
        this.setDigest(digest, false);
    }

    protected void mergeDigest(Digest digest) {
        this.setDigest(digest, true);
    }

    protected void overwriteDigest(Digest digest) {
        if (digest == null) {
            return;
        }
        StringBuilder sb = new StringBuilder("\n[overwriteDigest()]\n");
        sb.append("existing digest:  " + this.getDigest()).append("\nnew digest:       " + digest);
        for (Digest.DigestEntry entry : digest) {
            Address member = entry.getMember();
            if (member == null) continue;
            long highest_delivered_seqno = entry.getHighestDeliveredSeqno();
            Table<Message> buf = (Table<Message>)this.xmit_table.get(member);
            if (buf != null) {
                if (this.local_addr.equals(member)) {
                    buf.setHighestDelivered(highest_delivered_seqno);
                    continue;
                }
                this.xmit_table.remove(member);
            }
            buf = this.createTable(highest_delivered_seqno);
            this.xmit_table.put(member, buf);
        }
        sb.append("\n").append("resulting digest: " + this.getDigest());
        this.digest_history.add(sb.toString());
        if (this.log.isDebugEnabled()) {
            this.log.debug(sb.toString());
        }
    }

    protected void setDigest(Digest digest, boolean merge) {
        if (digest == null) {
            return;
        }
        StringBuilder sb = new StringBuilder(merge ? "\n[" + this.local_addr + " mergeDigest()]\n" : "\n[" + this.local_addr + " setDigest()]\n");
        sb.append("existing digest:  " + this.getDigest()).append("\nnew digest:       " + digest);
        boolean set_own_seqno = false;
        for (Digest.DigestEntry entry : digest) {
            Address member = entry.getMember();
            if (member == null) continue;
            long highest_delivered_seqno = entry.getHighestDeliveredSeqno();
            Table<Message> buf = (Table<Message>)this.xmit_table.get(member);
            if (buf != null) {
                if (!merge || this.local_addr != null && this.local_addr.equals(member) || buf.getHighestDelivered() >= highest_delivered_seqno) continue;
                this.xmit_table.remove(member);
                if (member.equals(this.local_addr)) {
                    this.seqno.set(highest_delivered_seqno);
                    set_own_seqno = true;
                }
            }
            buf = this.createTable(highest_delivered_seqno);
            this.xmit_table.put(member, buf);
        }
        sb.append("\n").append("resulting digest: " + this.getDigest());
        if (set_own_seqno) {
            sb.append("\nnew seqno for " + this.local_addr + ": " + this.seqno);
        }
        this.digest_history.add(sb.toString());
        if (this.log.isDebugEnabled()) {
            this.log.debug(sb.toString());
        }
    }

    protected Table<Message> createTable(long initial_seqno) {
        return new Table<Message>(this.xmit_table_num_rows, this.xmit_table_msgs_per_row, initial_seqno, this.xmit_table_resize_factor, this.xmit_table_max_compaction_time);
    }

    protected void stable(Digest digest) {
        if (this.members == null || this.local_addr == null || digest == null) {
            return;
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace(this.local_addr + ": received stable digest " + digest);
        }
        this.stability_msgs.add(digest);
        for (Digest.DigestEntry entry : digest) {
            Address member = entry.getMember();
            if (member == null) continue;
            long hd = entry.getHighestDeliveredSeqno();
            long hr = entry.getHighestReceivedSeqno();
            Table buf = (Table)this.xmit_table.get(member);
            if (buf != null) {
                long my_highest_rcvd = buf.getHighestReceived();
                long stability_highest_rcvd = hr;
                if (stability_highest_rcvd >= 0L && stability_highest_rcvd > my_highest_rcvd) {
                    if (this.log.isTraceEnabled()) {
                        this.log.trace(this.local_addr + ": my_highest_rcvd (" + my_highest_rcvd + ") < stability_highest_rcvd (" + stability_highest_rcvd + "): requesting retransmission of " + member + '#' + stability_highest_rcvd);
                    }
                    this.retransmit(stability_highest_rcvd, stability_highest_rcvd, member);
                }
            }
            if (hd < 0L) continue;
            if (this.log.isTraceEnabled()) {
                this.log.trace(this.local_addr + ": deleting msgs <= " + hd + " from " + member);
            }
            if (buf == null) continue;
            buf.purge(hd);
        }
    }

    protected void retransmit(long first_seqno, long last_seqno, Address sender) {
        if (first_seqno <= last_seqno) {
            this.retransmit(first_seqno, last_seqno, sender, false);
        }
    }

    protected void retransmit(long first_seqno, long last_seqno, Address sender, boolean multicast_xmit_request) {
        this.retransmit(new SeqnoList(first_seqno, last_seqno), sender, multicast_xmit_request);
    }

    protected void retransmit(SeqnoList missing_msgs, Address sender, boolean multicast_xmit_request) {
        Address random_member;
        Address dest = sender;
        if (multicast_xmit_request || this.use_mcast_xmit_req) {
            dest = null;
        } else if (this.xmit_from_random_member && !this.local_addr.equals(sender) && (random_member = (Address)Util.pickRandomElement(this.members)) != null && !this.local_addr.equals(random_member)) {
            dest = random_member;
            if (this.log.isTraceEnabled()) {
                this.log.trace(this.local_addr + ": picked random member " + dest + " to send XMIT request to");
            }
        }
        NakAckHeader2 hdr = NakAckHeader2.createXmitRequestHeader(sender);
        Message retransmit_msg = new Message(dest, null, missing_msgs);
        retransmit_msg.setFlag(Message.OOB);
        if (this.log.isTraceEnabled()) {
            this.log.trace(this.local_addr + ": sending XMIT_REQ (" + missing_msgs + ") to " + dest);
        }
        retransmit_msg.putHeader(this.id, hdr);
        this.down_prot.down(new Event(1, retransmit_msg));
        if (this.stats) {
            this.xmit_reqs_sent.addAndGet(missing_msgs.size());
        }
    }

    protected void reset() {
        this.seqno.set(0L);
        this.xmit_table.clear();
    }

    protected static long sizeOfAllMessages(Table<Message> buf, boolean include_headers) {
        Counter counter = new Counter(include_headers);
        buf.forEach(buf.getHighestDelivered() + 1L, buf.getHighestReceived(), counter);
        return counter.getResult();
    }

    protected void startRetransmitTask() {
        if (this.xmit_task == null || this.xmit_task.isDone()) {
            this.xmit_task = this.timer.scheduleWithFixedDelay(new RetransmitTask(), 0L, this.xmit_interval, TimeUnit.MILLISECONDS);
        }
    }

    protected void stopRetransmitTask() {
        if (this.xmit_task != null) {
            this.xmit_task.cancel(true);
            this.xmit_task = null;
        }
    }

    @ManagedOperation(description="Triggers the retransmission task, asking all senders for missing messages")
    public void triggerXmit() {
        for (Map.Entry entry : this.xmit_table.entrySet()) {
            SeqnoList missing;
            Address target = (Address)entry.getKey();
            Table buf = (Table)entry.getValue();
            if (buf != null && buf.getNumMissing() > 0 && (missing = buf.getMissing()) != null) {
                long highest = missing.getLast();
                Long prev_seqno = this.xmit_task_map.get(target);
                if (prev_seqno == null) {
                    this.xmit_task_map.put(target, highest);
                    continue;
                }
                missing.removeHigherThan(prev_seqno);
                if (highest > prev_seqno) {
                    this.xmit_task_map.put(target, highest);
                }
                if (missing.size() <= 0) continue;
                this.retransmit(missing, target, false);
                continue;
            }
            if (this.xmit_task_map.isEmpty()) continue;
            this.xmit_task_map.remove(target);
        }
    }

    protected static class Counter
    implements Table.Visitor<Message> {
        protected final boolean count_size;
        protected long result = 0L;

        public Counter(boolean count_size) {
            this.count_size = count_size;
        }

        public long getResult() {
            return this.result;
        }

        @Override
        public boolean visit(long seqno, Message element, int row, int column) {
            if (element != null) {
                this.result += this.count_size ? element.size() : (long)element.getLength();
            }
            return true;
        }
    }

    protected class RetransmitTask
    implements Runnable {
        protected RetransmitTask() {
        }

        @Override
        public void run() {
            NAKACK2.this.triggerXmit();
        }

        public String toString() {
            return NAKACK2.class.getSimpleName() + ": RetransmitTask (interval=" + NAKACK2.this.xmit_interval + " ms)";
        }
    }
}

