/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols;

import java.io.DataInput;
import java.io.DataOutput;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.Future;
import org.jgroups.Address;
import org.jgroups.Event;
import org.jgroups.Header;
import org.jgroups.Message;
import org.jgroups.PhysicalAddress;
import org.jgroups.View;
import org.jgroups.ViewId;
import org.jgroups.annotations.MBean;
import org.jgroups.annotations.ManagedAttribute;
import org.jgroups.annotations.ManagedOperation;
import org.jgroups.annotations.Property;
import org.jgroups.protocols.Discovery;
import org.jgroups.stack.Protocol;
import org.jgroups.util.ResponseCollector;
import org.jgroups.util.TimeScheduler;
import org.jgroups.util.Tuple;
import org.jgroups.util.UUID;
import org.jgroups.util.Util;

@MBean(description="Protocol to discover subgroups existing due to a network partition")
public class MERGE3
extends Protocol {
    protected long min_interval = 1000L;
    protected long max_interval = 10000L;
    @Property(description="The max number of merge participants to be involved in a merge. 0 sets this to unlimited.")
    protected int max_participants_in_merge = 100;
    @ManagedAttribute(description="Interval (in ms) after which we check for view inconsistencies", writable=true)
    protected long check_interval = 0L;
    protected Address local_addr = null;
    protected View view;
    protected TimeScheduler timer;
    protected Future<?> info_sender;
    protected Future<?> view_consistency_checker;
    protected final ConcurrentMap<ViewId, SortedSet<Address>> views = new ConcurrentHashMap<ViewId, SortedSet<Address>>(this.view != null ? this.view.size() : 16);
    protected final ResponseCollector<View> view_rsps = new ResponseCollector();
    protected boolean transport_supports_multicasting = true;
    protected String cluster_name;
    @ManagedAttribute(description="Whether or not the current member is the coordinator")
    protected volatile boolean is_coord = false;
    @ManagedAttribute(description="Number of times a MERGE event was sent up the stack")
    protected int num_merge_events = 0;

    @ManagedAttribute(description="Number of cached ViewIds")
    public int getViews() {
        return this.views.size();
    }

    @ManagedAttribute(description="Is the view consistency checker task running")
    public synchronized boolean isViewConsistencyCheckerRunning() {
        return this.view_consistency_checker != null && !this.view_consistency_checker.isDone();
    }

    @ManagedAttribute(description="Is the view consistency checker task running")
    public boolean isMergeTaskRunning() {
        return this.isViewConsistencyCheckerRunning();
    }

    @ManagedAttribute(description="Is the info sender task running")
    public synchronized boolean isInfoSenderRunning() {
        return this.info_sender != null && !this.info_sender.isDone();
    }

    @ManagedOperation(description="Lists the contents of the cached views")
    public String dumpViews() {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry entry : this.views.entrySet()) {
            sb.append(entry.getKey()).append(": ").append(entry.getValue()).append("\n");
        }
        return sb.toString();
    }

    @ManagedOperation(description="Clears the views cache")
    public void clearViews() {
        this.views.clear();
    }

    @Override
    public void init() throws Exception {
        this.timer = this.getTransport().getTimer();
        if (this.timer == null) {
            throw new Exception("timer cannot be retrieved");
        }
        if (this.min_interval >= this.max_interval) {
            throw new IllegalArgumentException("min_interval (" + this.min_interval + ") has to be < max_interval (" + this.max_interval + ")");
        }
        if (this.check_interval == 0L) {
            this.check_interval = this.computeCheckInterval();
        } else if (this.check_interval <= this.max_interval) {
            this.log.warn("set check_interval=" + this.computeCheckInterval() + " as it is <= max_interval");
            this.check_interval = this.computeCheckInterval();
        }
        if (this.max_interval <= 0L) {
            throw new Exception("max_interval must be > 0");
        }
        this.transport_supports_multicasting = this.getTransport().supportsMulticasting();
    }

    @Override
    public void stop() {
        super.stop();
        this.is_coord = false;
        this.stopViewConsistencyChecker();
        this.stopInfoSender();
    }

    public long getMinInterval() {
        return this.min_interval;
    }

    @Property(description="Minimum time in ms before sending an info message")
    public void setMinInterval(long i) {
        if (this.min_interval < 0L || this.min_interval >= this.max_interval) {
            throw new IllegalArgumentException("min_interval (" + this.min_interval + ") has to be < max_interval (" + this.max_interval + ")");
        }
        this.min_interval = i;
    }

    public long getMaxInterval() {
        return this.max_interval;
    }

    @Property(description="Interval (in milliseconds) when the next info message will be sent. A random value is picked from range [1..max_interval]")
    public void setMaxInterval(long val) {
        if (val <= 0L) {
            throw new IllegalArgumentException("max_interval must be > 0");
        }
        this.max_interval = val;
        this.check_interval = this.computeCheckInterval();
    }

    protected long computeCheckInterval() {
        return (long)((double)this.max_interval * 1.6);
    }

    protected boolean isMergeRunning() {
        Object retval = this.up_prot.up(new Event(100));
        return retval instanceof Boolean && (Boolean)retval != false;
    }

    protected synchronized void startInfoSender() {
        if (this.info_sender == null || this.info_sender.isDone()) {
            this.info_sender = this.timer.scheduleWithDynamicInterval(new InfoSender());
        }
    }

    protected synchronized void stopInfoSender() {
        if (this.info_sender != null) {
            this.info_sender.cancel(true);
            this.info_sender = null;
        }
    }

    protected synchronized void startViewConsistencyChecker() {
        if (this.view_consistency_checker == null || this.view_consistency_checker.isDone()) {
            this.view_consistency_checker = this.timer.scheduleWithDynamicInterval(new ViewConsistencyChecker());
        }
    }

    protected synchronized void stopViewConsistencyChecker() {
        if (this.view_consistency_checker != null) {
            this.view_consistency_checker.cancel(true);
            this.view_consistency_checker = null;
        }
    }

    @Override
    public Object down(Event evt) {
        switch (evt.getType()) {
            case 2: 
            case 80: 
            case 92: 
            case 93: {
                this.cluster_name = (String)evt.getArg();
                break;
            }
            case 4: {
                this.stopViewConsistencyChecker();
                this.stopInfoSender();
                break;
            }
            case 6: {
                Address coord;
                this.stopViewConsistencyChecker();
                this.stopInfoSender();
                Object ret = this.down_prot.down(evt);
                this.view = (View)evt.getArg();
                this.clearViews();
                if (this.ergonomics && this.max_participants_in_merge > 0) {
                    this.max_participants_in_merge = Math.max(100, this.view.size() / 3);
                }
                this.startInfoSender();
                List<Address> mbrs = this.view.getMembers();
                Address address = coord = mbrs.isEmpty() ? null : mbrs.get(0);
                if (coord != null && coord.equals(this.local_addr)) {
                    this.is_coord = true;
                    this.startViewConsistencyChecker();
                } else {
                    this.is_coord = false;
                }
                return ret;
            }
            case 8: {
                this.local_addr = (Address)evt.getArg();
            }
        }
        return this.down_prot.down(evt);
    }

    @Override
    public Object up(Event evt) {
        switch (evt.getType()) {
            case 1: {
                Message msg = (Message)evt.getArg();
                MergeHeader hdr = (MergeHeader)msg.getHeader(this.getId());
                if (hdr == null) break;
                Address sender = msg.getSrc();
                switch (hdr.type) {
                    case INFO: {
                        SortedSet tmp;
                        SortedSet<Address> existing;
                        if (hdr.logical_name != null && sender instanceof UUID) {
                            UUID.add(sender, hdr.logical_name);
                        }
                        if (hdr.physical_addrs != null) {
                            for (PhysicalAddress physical_addr : hdr.physical_addrs) {
                                this.down(new Event(89, new Tuple<Address, PhysicalAddress>(sender, physical_addr)));
                            }
                        }
                        if ((existing = (ConcurrentSkipListSet<Address>)this.views.get(hdr.view_id)) == null && (tmp = (SortedSet)this.views.putIfAbsent(hdr.view_id, existing = new ConcurrentSkipListSet<Address>())) != null) {
                            existing = tmp;
                        }
                        existing.add(sender);
                        if (!this.log.isTraceEnabled()) break;
                        this.log.trace(this.local_addr + " <-- " + sender + ": " + hdr + ", cached views: " + this.views.size());
                        break;
                    }
                    case VIEW_REQ: {
                        View tmp_view = this.view != null ? this.view.copy() : null;
                        MergeHeader tmphdr = MergeHeader.createViewResponse(tmp_view);
                        Message view_rsp = new Message(sender);
                        view_rsp.putHeader(this.getId(), tmphdr);
                        this.down_prot.down(new Event(1, view_rsp));
                        break;
                    }
                    case VIEW_RSP: {
                        if (hdr.view == null) break;
                        this.view_rsps.add(sender, hdr.view);
                        break;
                    }
                    default: {
                        this.log.error("Type " + (Object)((Object)hdr.type) + " not known");
                    }
                }
                return null;
            }
        }
        return this.up_prot.up(evt);
    }

    public static List<View> detectDifferentViews(Map<Address, View> map) {
        ArrayList<View> ret = new ArrayList<View>();
        for (View view : map.values()) {
            ViewId vid;
            if (view == null || Util.containsViewId(ret, vid = view.getVid())) continue;
            ret.add(view);
        }
        return ret;
    }

    public static class MergeHeader
    extends Header {
        protected Type type = Type.INFO;
        protected ViewId view_id;
        protected View view;
        protected String logical_name;
        protected Collection<PhysicalAddress> physical_addrs;

        public MergeHeader() {
        }

        public static MergeHeader createInfo(ViewId view_id, String logical_name, Collection<PhysicalAddress> physical_addrs) {
            return new MergeHeader(Type.INFO, view_id, null, logical_name, physical_addrs);
        }

        public static MergeHeader createViewRequest() {
            return new MergeHeader(Type.VIEW_REQ, null, null, null, null);
        }

        public static MergeHeader createViewResponse(View view) {
            return new MergeHeader(Type.VIEW_RSP, null, view, null, null);
        }

        protected MergeHeader(Type type, ViewId view_id, View view, String logical_name, Collection<PhysicalAddress> physical_addrs) {
            this.type = type;
            this.view_id = view_id;
            this.view = view;
            this.logical_name = logical_name;
            this.physical_addrs = physical_addrs;
        }

        @Override
        public int size() {
            int retval = 1;
            retval += Util.size(this.view_id);
            retval += Util.size(this.view);
            ++retval;
            if (this.logical_name != null) {
                retval += this.logical_name.length() + 2;
            }
            retval = (int)((long)retval + Util.size(this.physical_addrs));
            return retval;
        }

        @Override
        public void writeTo(DataOutput outstream) throws Exception {
            outstream.writeByte(this.type.ordinal());
            Util.writeViewId(this.view_id, outstream);
            Util.writeView(this.view, outstream);
            Util.writeString(this.logical_name, outstream);
            Util.writeAddresses(this.physical_addrs, outstream);
        }

        @Override
        public void readFrom(DataInput instream) throws Exception {
            this.type = Type.values()[instream.readByte()];
            this.view_id = Util.readViewId(instream);
            this.view = Util.readView(instream);
            this.logical_name = Util.readString(instream);
            this.physical_addrs = Util.readAddresses(instream, ArrayList.class);
        }

        @Override
        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append((Object)((Object)this.type) + ": ");
            if (this.view_id != null) {
                sb.append("view_id=" + this.view_id);
            } else if (this.view != null) {
                sb.append(" view=").append(this.view);
            }
            sb.append(", logical_name=" + this.logical_name + ", physical_addr=" + this.physical_addrs);
            return sb.toString();
        }

        protected static enum Type {
            INFO,
            VIEW_REQ,
            VIEW_RSP;

        }
    }

    protected class ViewConsistencyChecker
    implements TimeScheduler.Task {
        protected ViewConsistencyChecker() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                if (MERGE3.this.views.size() <= 1) {
                    if (MERGE3.this.log.isTraceEnabled()) {
                        MERGE3.this.log.trace("found no inconsistent views: " + MERGE3.this.dumpViews());
                    }
                    return;
                }
                this._run();
            }
            finally {
                MERGE3.this.clearViews();
            }
        }

        protected void _run() {
            Address merge_leader;
            TreeSet<Address> coords = new TreeSet<Address>();
            for (Map.Entry entry : MERGE3.this.views.entrySet()) {
                Address coord = ((ViewId)entry.getKey()).getCreator();
                SortedSet members = (SortedSet)entry.getValue();
                if (members == null || !members.contains(coord)) continue;
                coords.add(coord);
            }
            Address address = merge_leader = coords.isEmpty() ? null : (Address)coords.first();
            if (merge_leader == null || MERGE3.this.local_addr == null || !merge_leader.equals(MERGE3.this.local_addr)) {
                if (MERGE3.this.log.isTraceEnabled()) {
                    MERGE3.this.log.trace("I (" + MERGE3.this.local_addr + ") won't be the merge leader");
                }
                return;
            }
            if (MERGE3.this.log.isDebugEnabled()) {
                MERGE3.this.log.debug("I (" + MERGE3.this.local_addr + ") will be the merge leader");
            }
            for (SortedSet set : MERGE3.this.views.values()) {
                if (set.isEmpty()) continue;
                coords.add((Address)set.first());
            }
            if (coords.size() <= 1) {
                MERGE3.this.log.trace("cancelling merge as we only have 1 coordinator: " + coords);
                return;
            }
            if (MERGE3.this.log.isTraceEnabled()) {
                MERGE3.this.log.trace("merge participants are " + coords);
            }
            if (MERGE3.this.max_participants_in_merge > 0 && coords.size() > MERGE3.this.max_participants_in_merge) {
                int old_size = coords.size();
                Iterator it = coords.iterator();
                while (it.hasNext()) {
                    Address next = (Address)it.next();
                    if (next.equals(merge_leader) || coords.size() <= MERGE3.this.max_participants_in_merge) continue;
                    it.remove();
                }
                if (MERGE3.this.log.isTraceEnabled()) {
                    MERGE3.this.log.trace(MERGE3.this.local_addr + ": reduced " + old_size + " coords to " + MERGE3.this.max_participants_in_merge);
                }
            }
            MERGE3.this.view_rsps.reset(coords);
            for (Address target : coords) {
                if (target.equals(MERGE3.this.local_addr)) {
                    if (MERGE3.this.view == null) continue;
                    MERGE3.this.view_rsps.add(MERGE3.this.local_addr, MERGE3.this.view.copy());
                    continue;
                }
                Message view_req = new Message(target);
                MergeHeader hdr = MergeHeader.createViewRequest();
                view_req.putHeader(MERGE3.this.getId(), hdr);
                MERGE3.this.down_prot.down(new Event(1, view_req));
            }
            MERGE3.this.view_rsps.waitForAllResponses(MERGE3.this.check_interval / 10L);
            Map<Address, View> results = MERGE3.this.view_rsps.getResults();
            HashMap<Address, View> merge_views = new HashMap<Address, View>();
            for (Map.Entry<Address, View> entry : results.entrySet()) {
                if (entry.getValue() == null) continue;
                merge_views.put(entry.getKey(), entry.getValue());
            }
            if (merge_views.size() >= 2) {
                MERGE3.this.up_prot.up(new Event(14, merge_views));
                ++MERGE3.this.num_merge_events;
            }
        }

        @Override
        public long nextInterval() {
            return MERGE3.this.check_interval;
        }

        public String toString() {
            return MERGE3.class.getSimpleName() + ": " + this.getClass().getSimpleName();
        }
    }

    protected class InfoSender
    implements TimeScheduler.Task {
        protected InfoSender() {
        }

        @Override
        public void run() {
            if (MERGE3.this.view == null) {
                MERGE3.this.log.warn("view is null, cannot send INFO message");
                return;
            }
            PhysicalAddress physical_addr = MERGE3.this.local_addr != null ? (PhysicalAddress)MERGE3.this.down_prot.down(new Event(87, MERGE3.this.local_addr)) : null;
            String logical_name = UUID.get(MERGE3.this.local_addr);
            ViewId view_id = MERGE3.this.view.getViewId();
            MergeHeader hdr = MergeHeader.createInfo(view_id, logical_name, Arrays.asList(physical_addr));
            if (MERGE3.this.transport_supports_multicasting) {
                Message msg = new Message();
                msg.putHeader(MERGE3.this.getId(), hdr);
                MERGE3.this.down_prot.down(new Event(1, msg));
                return;
            }
            Discovery discovery_protocol = (Discovery)MERGE3.this.stack.findProtocol((Class<?>)Discovery.class);
            if (discovery_protocol == null) {
                MERGE3.this.log.warn("no discovery protocol found, cannot ask for physical addresses to send INFO message");
                return;
            }
            Collection physical_addrs = discovery_protocol.fetchClusterMembers(MERGE3.this.cluster_name);
            if (physical_addrs == null) {
                physical_addrs = (Collection)MERGE3.this.down_prot.down(new Event(102));
            }
            if (physical_addrs == null || physical_addrs.isEmpty()) {
                return;
            }
            if (MERGE3.this.log.isTraceEnabled()) {
                MERGE3.this.log.trace("discovery protocol " + discovery_protocol.getName() + " returned " + physical_addrs.size() + " physical addresses: " + Util.printListWithDelimiter(physical_addrs, ", ", 10));
            }
            for (PhysicalAddress addr : physical_addrs) {
                Message info = new Message(addr);
                info.putHeader(MERGE3.this.getId(), hdr);
                MERGE3.this.down_prot.down(new Event(1, info));
            }
        }

        @Override
        public long nextInterval() {
            return Math.max(MERGE3.this.min_interval, Util.random(MERGE3.this.max_interval) + MERGE3.this.max_interval / 2L);
        }

        public String toString() {
            return MERGE3.class.getSimpleName() + ": " + this.getClass().getSimpleName();
        }
    }
}

