/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.jgroups.Address;
import org.jgroups.Event;
import org.jgroups.Header;
import org.jgroups.Message;
import org.jgroups.annotations.MBean;
import org.jgroups.annotations.Property;
import org.jgroups.auth.AuthToken;
import org.jgroups.auth.X509Token;
import org.jgroups.conf.ClassConfigurator;
import org.jgroups.protocols.AuthHeader;
import org.jgroups.protocols.pbcast.GMS;
import org.jgroups.protocols.pbcast.JoinRsp;
import org.jgroups.stack.Protocol;

@MBean(description="Provides authentication of joiners, to prevent un-authorized joining of a cluster")
public class AUTH
extends Protocol {
    protected AuthToken auth_token = null;
    protected static final short gms_id = ClassConfigurator.getProtocolId(GMS.class);
    protected final List<UpHandler> up_handlers = new ArrayList<UpHandler>();
    protected Address local_addr;

    public AUTH() {
        this.name = "AUTH";
    }

    @Property(name="auth_class")
    public void setAuthClass(String class_name) throws Exception {
        Object obj = Class.forName(class_name).newInstance();
        this.auth_token = (AuthToken)obj;
        this.auth_token.setAuth(this);
    }

    public String getAuthClass() {
        return this.auth_token != null ? this.auth_token.getClass().getName() : null;
    }

    public AuthToken getAuthToken() {
        return this.auth_token;
    }

    public void setAuthToken(AuthToken token) {
        this.auth_token = token;
    }

    public void register(UpHandler handler) {
        this.up_handlers.add(handler);
    }

    public void unregister(UpHandler handler) {
        this.up_handlers.remove(handler);
    }

    public Address getAddress() {
        return this.local_addr;
    }

    @Override
    protected List<Object> getConfigurableObjects() {
        LinkedList<Object> retval = new LinkedList<Object>();
        if (this.auth_token != null) {
            retval.add(this.auth_token);
        }
        return retval;
    }

    @Override
    public void init() throws Exception {
        super.init();
        if (this.auth_token instanceof X509Token) {
            X509Token tmp = (X509Token)this.auth_token;
            tmp.setCertificate();
        }
        this.auth_token.init();
    }

    @Override
    public Object up(Event evt) {
        switch (evt.getType()) {
            case 1: {
                Message msg = (Message)evt.getArg();
                AuthHeader auth_hdr = (AuthHeader)msg.getHeader(this.id);
                if (auth_hdr == null) break;
                GMS.GmsHeader gms_hdr = AUTH.getGMSHeader(evt);
                if (gms_hdr == null) {
                    throw new IllegalStateException("found AuthHeader but no GmsHeader");
                }
                if (this.handleAuthHeader(gms_hdr, auth_hdr, msg)) break;
                return null;
            }
        }
        if (!this.callUpHandlers(evt)) {
            return null;
        }
        return this.up_prot.up(evt);
    }

    @Override
    public Object down(Event evt) {
        GMS.GmsHeader hdr = AUTH.getGMSHeader(evt);
        if (hdr != null && (hdr.getType() == 1 || hdr.getType() == 11 || hdr.getType() == 6)) {
            Message msg = (Message)evt.getArg();
            AuthHeader authHeader = new AuthHeader(this.auth_token);
            msg.putHeader(this.id, authHeader);
        }
        if (evt.getType() == 8) {
            this.local_addr = (Address)evt.getArg();
        }
        return this.down_prot.down(evt);
    }

    protected boolean handleAuthHeader(GMS.GmsHeader gms_hdr, AuthHeader auth_hdr, Message msg) {
        switch (gms_hdr.getType()) {
            case 1: 
            case 6: 
            case 11: {
                if (this.auth_token.authenticate(auth_hdr.getToken(), msg)) {
                    return true;
                }
                if (this.log.isWarnEnabled()) {
                    this.log.warn("failed to validate AuthHeader token from " + msg.getSrc() + ", token: " + this.auth_token);
                }
                this.sendRejectionMessage(gms_hdr.getType(), msg.getSrc(), "Authentication failed");
                return false;
            }
        }
        return true;
    }

    protected void sendRejectionMessage(byte type, Address dest, String error_msg) {
        switch (type) {
            case 1: 
            case 11: {
                this.sendJoinRejectionMessage(dest, error_msg);
                break;
            }
            case 6: {
                this.sendMergeRejectionMessage(dest);
                break;
            }
            default: {
                this.log.error("type " + type + " unknown");
            }
        }
    }

    protected void sendJoinRejectionMessage(Address dest, String error_msg) {
        if (dest == null) {
            return;
        }
        Message msg = new Message(dest, null, null);
        JoinRsp joinRes = new JoinRsp(error_msg);
        GMS.GmsHeader gmsHeader = new GMS.GmsHeader(2, joinRes);
        msg.putHeader(gms_id, gmsHeader);
        this.down_prot.down(new Event(1, msg));
    }

    protected void sendMergeRejectionMessage(Address dest) {
        Message msg = new Message(dest, null, null);
        msg.setFlag(Message.OOB);
        GMS.GmsHeader hdr = new GMS.GmsHeader(7);
        hdr.setMergeRejected(true);
        msg.putHeader(gms_id, hdr);
        if (this.log.isDebugEnabled()) {
            this.log.debug("merge response=" + hdr);
        }
        this.down_prot.down(new Event(1, msg));
    }

    protected boolean callUpHandlers(Event evt) {
        boolean pass_up = true;
        for (UpHandler handler : this.up_handlers) {
            if (handler.handleUpEvent(evt)) continue;
            pass_up = false;
        }
        return pass_up;
    }

    protected static GMS.GmsHeader getGMSHeader(Event evt) {
        switch (evt.getType()) {
            case 1: {
                Message msg = (Message)evt.getArg();
                Header hdr = msg.getHeader(gms_id);
                if (!(hdr instanceof GMS.GmsHeader)) break;
                return (GMS.GmsHeader)hdr;
            }
        }
        return null;
    }

    public static interface UpHandler {
        public boolean handleUpEvent(Event var1);
    }
}

