/*
 * Decompiled with CFR 0.152.
 */
package org.fasttcp.sys;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import org.fasttcp.sys.SerialData;

public class SerialConverter {
    private static byte[] extractBytes(String strBytes) {
        String[] splitBytes = strBytes.split(".");
        byte[] bytes = new byte[splitBytes.length];
        for (int i = 0; i < splitBytes.length; ++i) {
            bytes[i] = Byte.parseByte(splitBytes[i]);
        }
        return bytes;
    }

    private static String convertBytes(byte[] bytes) {
        StringBuilder sbBytes = new StringBuilder();
        for (int i = 0; i < bytes.length; ++i) {
            sbBytes.append(bytes[i]).append('.');
        }
        sbBytes.deleteCharAt(sbBytes.length() - 1);
        return sbBytes.toString();
    }

    public static String toSerialString(SerialData data) throws IOException {
        StringBuilder sbSerial = new StringBuilder();
        sbSerial.append(data.getType());
        if (data.hasData()) {
            sbSerial.append(' ');
            switch (data.getType()) {
                case "byte": {
                    sbSerial.append(data.getParsedData(Number.class).byteValue());
                    break;
                }
                case "bytes": {
                    sbSerial.append(SerialConverter.convertBytes(data.getParsedData(byte[].class)));
                    break;
                }
                case "d": {
                    sbSerial.append(data.getParsedData(Number.class).doubleValue());
                    break;
                }
                case "f": {
                    sbSerial.append(data.getParsedData(Number.class).floatValue());
                    break;
                }
                case "int": {
                    sbSerial.append(data.getParsedData(Number.class).intValue());
                    break;
                }
                case "l": {
                    sbSerial.append(data.getParsedData(Number.class).longValue());
                    break;
                }
                case "obj": {
                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                    ObjectOutputStream oos = new ObjectOutputStream(baos);
                    oos.writeObject(data.getData());
                    sbSerial.append(SerialConverter.convertBytes(baos.toByteArray()));
                    baos.close();
                    oos.close();
                    break;
                }
                case "sh": {
                    sbSerial.append(data.getParsedData(Number.class).shortValue());
                    break;
                }
                case "str": {
                    sbSerial.append(data.getData().toString());
                }
            }
        }
        return sbSerial.toString();
    }

    public static SerialData deserialize(String serialString) throws IOException, ClassNotFoundException {
        String[] cmdSplit = serialString.split(" ");
        String type = cmdSplit[0];
        SerialData data = new SerialData();
        data.setType(type);
        switch (type) {
            case "byte": {
                data.setParsedData(Byte.parseByte(cmdSplit[1]));
                break;
            }
            case "bytes": {
                data.setParsedData(SerialConverter.extractBytes(cmdSplit[1]));
                break;
            }
            case "d": {
                data.setParsedData(Double.parseDouble(cmdSplit[1]));
                break;
            }
            case "f": {
                data.setParsedData(Float.valueOf(Float.parseFloat(cmdSplit[1])));
                break;
            }
            case "int": {
                data.setParsedData(Integer.parseInt(cmdSplit[1]));
                break;
            }
            case "l": {
                data.setParsedData(Long.parseLong(cmdSplit[1]));
                break;
            }
            case "obj": {
                ByteArrayInputStream bais = new ByteArrayInputStream(SerialConverter.extractBytes(cmdSplit[1]));
                ObjectInputStream ois = new ObjectInputStream(bais);
                Object object = ois.readObject();
                bais.close();
                ois.close();
                data.setData(object);
                break;
            }
            case "sh": {
                data.setParsedData(Short.parseShort(cmdSplit[1]));
                break;
            }
            case "str": {
                int firstSplitLen = cmdSplit[0].length();
                data.setData(serialString.substring(firstSplitLen + 1));
            }
        }
        return data;
    }
}

