/*
 * Decompiled with CFR 0.152.
 */
package org.fasttcp.sys;

import java.util.GregorianCalendar;

public class Log {
    private String className;
    private String title;
    private String msg;

    public static void d(Class<?> clazz, String msg) {
        new Log(clazz, msg).info();
    }

    public static void w(Class<?> clazz, String msg) {
        new Log(clazz, msg).warning();
    }

    public static void e(Class<?> clazz, String msg) {
        new Log(clazz, msg).warning();
    }

    public static void d(Object obj, String msg) {
        Log.d(obj.getClass(), msg);
    }

    public static void w(Object obj, String msg) {
        Log.w(obj.getClass(), msg);
    }

    public static void e(Object obj, String msg) {
        Log.e(obj.getClass(), msg);
    }

    public static void d(String msg) {
        Log.d(null, msg);
    }

    public static void w(String msg) {
        Log.w(null, msg);
    }

    public static void e(String msg) {
        Log.e(null, msg);
    }

    public Log(Class<?> clazz, String title, String msg) {
        this.className = clazz == null ? null : clazz.getName();
        this.title = title;
        this.msg = msg;
    }

    public Log(Class<?> clazz, String msg) {
        this.className = clazz == null ? null : clazz.getName();
        this.msg = msg;
    }

    private String getCurrentTime() {
        StringBuilder sbTime = new StringBuilder();
        GregorianCalendar calendar = new GregorianCalendar();
        char timeSeparator = ':';
        byte hour = (byte)calendar.get(11);
        byte minutes = (byte)calendar.get(12);
        byte seconds = (byte)calendar.get(13);
        if (hour < 10) {
            sbTime.append('0').append(hour);
        } else {
            sbTime.append(hour);
        }
        sbTime.append(timeSeparator);
        if (minutes < 10) {
            sbTime.append('0').append(minutes);
        } else {
            sbTime.append(minutes);
        }
        sbTime.append(timeSeparator);
        if (seconds < 10) {
            sbTime.append('0').append(seconds);
        } else {
            sbTime.append(seconds);
        }
        return sbTime.toString();
    }

    private StringBuilder getWriter(String color) {
        return new StringBuilder().append(color);
    }

    private String getMsg(StringBuilder sbMsg) {
        sbMsg.append('[').append(this.getCurrentTime()).append("] ");
        if (this.className != null) {
            sbMsg.append(this.className).append(": ");
        }
        if (this.title != null) {
            sbMsg.append(this.title).append(": ");
        }
        sbMsg.append(this.msg);
        sbMsg.append("\u001b[0m");
        return sbMsg.toString();
    }

    public void error() {
        System.out.println(this.getMsg(this.getWriter("\u001b[31m")));
    }

    public void info() {
        System.out.println(this.getMsg(this.getWriter("\u001b[32m")));
    }

    public void warning() {
        System.out.println(this.getMsg(this.getWriter("\u001b[33m")));
    }

    public void printMsg() {
        this.info();
    }

    public void printMsg(TYPE type) {
        switch (type) {
            case INFO: {
                this.info();
                break;
            }
            case ERROR: {
                this.error();
                break;
            }
            case WARNING: {
                this.warning();
            }
        }
    }

    public static enum TYPE {
        INFO,
        WARNING,
        ERROR;

    }
}

