/*
 * Decompiled with CFR 0.152.
 */
package org.fasttcp.net;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.LinkedList;
import org.fasttcp.exceptions.ListenerNotDefinedException;
import org.fasttcp.io.SocketInputStream;
import org.fasttcp.net.Client;
import org.fasttcp.net.TransferPackage;
import org.fasttcp.net.interfaces.ClientListener;
import org.fasttcp.net.interfaces.ServerListener;
import org.fasttcp.sys.Log;

public class Server
extends Thread {
    private ServerSocket serverSocket;
    private LinkedList<Client> listClients;
    private ServerListener serverListener;
    private ServerListener defaultListener;
    private ClientListener clientListener;
    private boolean connected;
    static LinkedList<Server> listInstancedServers = new LinkedList();

    public Server() throws IOException {
        this.serverSocket = new ServerSocket();
        this.listClients = new LinkedList();
        listInstancedServers.add(this);
        this.configDefaultListener();
    }

    public Server(int port) throws IOException {
        this.serverSocket = new ServerSocket(port);
        this.listClients = new LinkedList();
        listInstancedServers.add(this);
        this.configDefaultListener();
    }

    private void configDefaultListener() {
        this.defaultListener = new ServerListener(){

            @Override
            public void onClientConnected(Socket socket) throws IOException, ClassNotFoundException {
                Log.d(this, "Client connected from " + socket.getInetAddress().getHostAddress());
                SocketInputStream inputStream = new SocketInputStream(socket.getInputStream());
                TransferPackage pkg = inputStream.readPackage();
                System.out.println("Petition Received: " + pkg.getData().toString());
                if (pkg.getData().getType().equals("con")) {
                    Server.this.serverListener.onClientConnected(socket);
                    Log.d(this, "Client " + Server.this.addClient(new Client(socket, Server.this.getId())) + " authorized");
                } else {
                    Log.e(this, "Host " + socket.getInetAddress().getHostAddress() + " not authorized");
                }
            }

            @Override
            public void onClientDisconnected(long clientId) {
                Server.this.serverListener.onClientDisconnected(clientId);
                Server.this.removeClient(clientId);
                Log.d(this, "Client " + clientId + " disconnected");
            }
        };
    }

    private void closeAll() {
        this.listClients.parallelStream().forEach(cli -> {
            try {
                cli.unlink();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        });
        listInstancedServers.removeIf(srv -> srv.getId() == this.getId());
        try {
            this.serverSocket.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        Log.d(this, "Server closed");
        Log.d(this, "Port " + this.serverSocket.getLocalPort() + " released");
    }

    public void bind(int port) throws IOException {
        this.serverSocket.bind(new InetSocketAddress(port));
    }

    public synchronized void disconnect() {
        this.connected = false;
    }

    private synchronized long addClient(Client client) {
        client.setListener(this.clientListener);
        if (!client.isAlive()) {
            client.start();
        }
        this.listClients.add(client);
        return client.getId();
    }

    private synchronized void removeClient(long clientId) {
        this.listClients.parallelStream().filter(cli -> cli.getId() == clientId).iterator().remove();
        Log.d(this, "Client " + clientId + " removed");
    }

    public synchronized LinkedList<Client> getListClients() {
        return new LinkedList<Client>(this.listClients);
    }

    public synchronized ServerListener getServerListener() {
        return this.serverListener;
    }

    public synchronized void setServerListener(ServerListener serverListener) {
        this.serverListener = serverListener;
    }

    public synchronized ClientListener getClientListener() {
        return this.clientListener;
    }

    public synchronized void setClientListener(ClientListener clientListener) {
        this.clientListener = clientListener;
    }

    @Override
    public void run() {
        if (this.serverListener == null || this.clientListener == null) {
            throw new ListenerNotDefinedException();
        }
        this.connected = true;
        Log.d(this, "Server started in port " + this.serverSocket.getLocalPort());
        while (this.connected) {
            try {
                Log.d(this, "Listening clients...");
                this.defaultListener.onClientConnected(this.serverSocket.accept());
                Thread.sleep(1L);
            }
            catch (IOException | ClassNotFoundException | InterruptedException e) {
                e.printStackTrace();
            }
        }
        this.closeAll();
    }
}

