/*
 * Decompiled with CFR 0.152.
 */
package org.fasttcp.io;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.SocketTimeoutException;
import org.fasttcp.io.interfaces.ReceivableStream;
import org.fasttcp.net.TransferPackage;

public class SocketInputStream
extends DataInputStream
implements ReceivableStream {
    public SocketInputStream(InputStream socketStream) {
        super(socketStream);
    }

    protected void waitForData() throws IOException {
        while (this.available() == 0) {
            try {
                Thread.sleep(1L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    protected boolean hasPackages() throws IOException {
        return this.readShort() == 1020;
    }

    protected boolean hasResidue() throws IOException {
        return this.readShort() == 1022;
    }

    protected byte[] readData() throws IOException {
        this.waitForData();
        try {
            int available = this.readInt();
            byte[] buffer = new byte[available];
            for (int i = 0; i < available; ++i) {
                buffer[i] = (byte)this.read();
            }
            return buffer;
        }
        catch (SocketTimeoutException e) {
            return null;
        }
    }

    @Override
    public String readString() throws IOException {
        String str = new String(this.readData(), "UNICODE");
        return str;
    }

    @Override
    public byte[] readBytes() throws IOException {
        return this.readData();
    }

    @Override
    public TransferPackage readPackage() throws IOException, ClassNotFoundException {
        return new TransferPackage(this.readString());
    }
}

